/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.Java;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SaslChannelBuilder.class);
    private final SecurityProtocol securityProtocol;
    private final ListenerName listenerName;
    private final String clientSaslMechanism;
    private final Mode mode;
    private final JaasContext jaasContext;
    private final boolean handshakeRequestEnable;
    private final CredentialCache credentialCache;
    private LoginManager loginManager;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private KerberosShortNamer kerberosShortNamer;

    public SaslChannelBuilder(Mode mode, JaasContext jaasContext, SecurityProtocol securityProtocol, ListenerName listenerName, String clientSaslMechanism, boolean handshakeRequestEnable, CredentialCache credentialCache) {
        this.mode = mode;
        this.jaasContext = jaasContext;
        this.securityProtocol = securityProtocol;
        this.listenerName = listenerName;
        this.handshakeRequestEnable = handshakeRequestEnable;
        this.clientSaslMechanism = clientSaslMechanism;
        this.credentialCache = credentialCache;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            List enabledMechanisms;
            this.configs = configs;
            boolean hasKerberos = this.mode == Mode.SERVER ? (enabledMechanisms = (List)this.configs.get("sasl.enabled.mechanisms")) == null || enabledMechanisms.contains("GSSAPI") : this.clientSaslMechanism.equals("GSSAPI");
            if (hasKerberos) {
                String defaultRealm;
                try {
                    defaultRealm = SaslChannelBuilder.defaultKerberosRealm();
                }
                catch (Exception ke) {
                    defaultRealm = "";
                }
                List principalToLocalRules = (List)configs.get("sasl.kerberos.principal.to.local.rules");
                if (principalToLocalRules != null) {
                    this.kerberosShortNamer = KerberosShortNamer.fromUnparsedRules(defaultRealm, principalToLocalRules);
                }
            }
            this.loginManager = LoginManager.acquireLoginManager(this.jaasContext, hasKerberos, configs);
            if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
                this.sslFactory = new SslFactory(this.mode, "none");
                this.sslFactory.configure(configs);
            }
        }
        catch (Exception e) {
            this.close();
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool) throws KafkaException {
        try {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            Socket socket = socketChannel.socket();
            TransportLayer transportLayer = this.buildTransportLayer(id, key, socketChannel);
            Authenticator authenticator = this.mode == Mode.SERVER ? this.buildServerAuthenticator(this.configs, id, transportLayer, this.loginManager.subject()) : this.buildClientAuthenticator(this.configs, id, socket.getInetAddress().getHostName(), this.loginManager.serviceName(), transportLayer, this.loginManager.subject());
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        if (this.loginManager != null) {
            this.loginManager.release();
            this.loginManager = null;
        }
    }

    private TransportLayer buildTransportLayer(String id, SelectionKey key, SocketChannel socketChannel) throws IOException {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            return SslTransportLayer.create(id, key, this.sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
        }
        return new PlaintextTransportLayer(key);
    }

    protected SaslServerAuthenticator buildServerAuthenticator(Map<String, ?> configs, String id, TransportLayer transportLayer, Subject subject) throws IOException {
        return new SaslServerAuthenticator(configs, id, this.jaasContext, subject, this.kerberosShortNamer, this.credentialCache, this.listenerName, this.securityProtocol, transportLayer);
    }

    protected SaslClientAuthenticator buildClientAuthenticator(Map<String, ?> configs, String id, String serverHost, String servicePrincipal, TransportLayer transportLayer, Subject subject) throws IOException {
        return new SaslClientAuthenticator(configs, id, subject, servicePrincipal, serverHost, this.clientSaslMechanism, this.handshakeRequestEnable, transportLayer);
    }

    LoginManager loginManager() {
        return this.loginManager;
    }

    private static String defaultKerberosRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = Java.isIbmJdk() ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }
}

