/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;

public class SslFactory
implements Configurable {
    private final Mode mode;
    private final String clientAuthConfigOverride;
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore = null;
    private Password keyPassword;
    private SecurityStore truststore;
    private String[] cipherSuites;
    private String[] enabledProtocols;
    private String endpointIdentification;
    private SecureRandom secureRandomImplementation;
    private SSLContext sslContext;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    public SslFactory(Mode mode) {
        this(mode, null);
    }

    public SslFactory(Mode mode, String clientAuthConfigOverride) {
        this.mode = mode;
        this.clientAuthConfigOverride = clientAuthConfigOverride;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        String clientAuthConfig;
        String secureRandomImplementation;
        String endpointIdentification;
        List enabledProtocolsList;
        this.protocol = (String)configs.get("ssl.protocol");
        this.provider = (String)configs.get("ssl.provider");
        List cipherSuitesList = (List)configs.get("ssl.cipher.suites");
        if (cipherSuitesList != null) {
            this.cipherSuites = cipherSuitesList.toArray(new String[cipherSuitesList.size()]);
        }
        if ((enabledProtocolsList = (List)configs.get("ssl.enabled.protocols")) != null) {
            this.enabledProtocols = enabledProtocolsList.toArray(new String[enabledProtocolsList.size()]);
        }
        if ((endpointIdentification = (String)configs.get("ssl.endpoint.identification.algorithm")) != null) {
            this.endpointIdentification = endpointIdentification;
        }
        if ((secureRandomImplementation = (String)configs.get("ssl.secure.random.implementation")) != null) {
            try {
                this.secureRandomImplementation = SecureRandom.getInstance(secureRandomImplementation);
            }
            catch (GeneralSecurityException e) {
                throw new KafkaException(e);
            }
        }
        if ((clientAuthConfig = this.clientAuthConfigOverride) == null) {
            clientAuthConfig = (String)configs.get("ssl.client.auth");
        }
        if (clientAuthConfig != null) {
            if (clientAuthConfig.equals("required")) {
                this.needClientAuth = true;
            } else if (clientAuthConfig.equals("requested")) {
                this.wantClientAuth = true;
            }
        }
        this.kmfAlgorithm = (String)configs.get("ssl.keymanager.algorithm");
        this.tmfAlgorithm = (String)configs.get("ssl.trustmanager.algorithm");
        this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (Password)configs.get("ssl.keystore.password"), (Password)configs.get("ssl.key.password"));
        this.createTruststore((String)configs.get("ssl.truststore.type"), (String)configs.get("ssl.truststore.location"), (Password)configs.get("ssl.truststore.password"));
        try {
            this.sslContext = this.createSSLContext();
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    private SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        SSLContext sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
        KeyManager[] keyManagers = null;
        if (this.keystore != null) {
            String kmfAlgorithm = this.kmfAlgorithm != null ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
            KeyStore ks = this.keystore.load();
            Password keyPassword = this.keyPassword != null ? this.keyPassword : this.keystore.password;
            kmf.init(ks, keyPassword.value().toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        String tmfAlgorithm = this.tmfAlgorithm != null ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        KeyStore ts = this.truststore == null ? null : this.truststore.load();
        tmf.init(ts);
        sslContext.init(keyManagers, tmf.getTrustManagers(), this.secureRandomImplementation);
        return sslContext;
    }

    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        if (this.cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        if (this.mode == Mode.SERVER) {
            sslEngine.setUseClientMode(false);
            if (this.needClientAuth) {
                sslEngine.setNeedClientAuth(this.needClientAuth);
            } else {
                sslEngine.setWantClientAuth(this.wantClientAuth);
            }
        } else {
            sslEngine.setUseClientMode(true);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm(this.endpointIdentification);
            sslEngine.setSSLParameters(sslParams);
        }
        return sslEngine;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    private void createKeystore(String type, String path, Password password, Password keyPassword) {
        if (path == null && password != null) {
            throw new KafkaException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new KafkaException("SSL key store is specified, but key store password is not specified.");
        }
        if (path != null && password != null) {
            this.keystore = new SecurityStore(type, path, password);
            this.keyPassword = keyPassword;
        }
    }

    private void createTruststore(String type, String path, Password password) {
        if (path == null && password != null) {
            throw new KafkaException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (path != null) {
            this.truststore = new SecurityStore(type, path, password);
        }
    }

    private static class SecurityStore {
        private final String type;
        private final String path;
        private final Password password;

        private SecurityStore(String type, String path, Password password) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            this.path = path;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore load() throws GeneralSecurityException, IOException {
            try (FileInputStream in = null;){
                KeyStore ks = KeyStore.getInstance(this.type);
                in = new FileInputStream(this.path);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
    }
}

