/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.plain;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.plain.PlainSaslServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PlainSaslServerTest {
    private static final String USER_A = "userA";
    private static final String PASSWORD_A = "passwordA";
    private static final String USER_B = "userB";
    private static final String PASSWORD_B = "passwordB";
    private PlainSaslServer saslServer;

    @Before
    public void setUp() throws Exception {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("user_userA", PASSWORD_A);
        options.put("user_userB", PASSWORD_B);
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), options);
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig);
        this.saslServer = new PlainSaslServer(jaasContext);
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.saslMessage("", USER_A, PASSWORD_A));
        Assert.assertEquals((long)0L, (long)nextChallenge.length);
    }

    @Test
    public void authorizatonIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.saslMessage(USER_A, USER_A, PASSWORD_A));
        Assert.assertEquals((long)0L, (long)nextChallenge.length);
    }

    @Test(expected=SaslAuthenticationException.class)
    public void authorizatonIdNotEqualsAuthenticationId() throws Exception {
        this.saslServer.evaluateResponse(this.saslMessage(USER_B, USER_A, PASSWORD_A));
    }

    private byte[] saslMessage(String authorizationId, String userName, String password) {
        String nul = "\u0000";
        String message = String.format("%s%s%s%s%s", authorizationId, nul, userName, nul, password);
        return message.getBytes(StandardCharsets.UTF_8);
    }
}

