/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class StickyAssignorTest {
    private StickyAssignor assignor = new StickyAssignor();

    @Test
    public void testOneConsumerNoTopic() {
        String consumerId = "consumer";
        HashMap partitionsPerTopic = new HashMap();
        Map<String, PartitionAssignor.Subscription> subscriptions = Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 0);
        Map<String, PartitionAssignor.Subscription> subscriptions = Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerOneTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        Map<String, PartitionAssignor.Subscription> subscriptions = Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0), StickyAssignorTest.tp(topic, 1), StickyAssignorTest.tp(topic, 2)), assignment.get(consumerId));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String topic = "topic";
        String otherTopic = "other";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        partitionsPerTopic.put(otherTopic, 3);
        Map<String, PartitionAssignor.Subscription> subscriptions = Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0), StickyAssignorTest.tp(topic, 1), StickyAssignorTest.tp(topic, 2)), assignment.get(consumerId));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 1);
        partitionsPerTopic.put(topic2, 2);
        Map<String, PartitionAssignor.Subscription> subscriptions = Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic1, 0), StickyAssignorTest.tp(topic2, 0), StickyAssignorTest.tp(topic2, 1)), assignment.get(consumerId));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 1);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0)), assignment.get(consumer1));
        Assert.assertEquals(Collections.emptyList(), assignment.get(consumer2));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 2);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0)), assignment.get(consumer1));
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 1)), assignment.get(consumer2));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testMultipleConsumersMixedTopicSubscriptions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 2);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1)));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1, topic2)));
        subscriptions.put(consumer3, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic1, 0), StickyAssignorTest.tp(topic1, 2)), assignment.get(consumer1));
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic2, 0), StickyAssignorTest.tp(topic2, 1)), assignment.get(consumer2));
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic1, 1)), assignment.get(consumer3));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 3);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1, topic2)));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic1, 0), StickyAssignorTest.tp(topic1, 2), StickyAssignorTest.tp(topic2, 1)), assignment.get(consumer1));
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic1, 1), StickyAssignorTest.tp(topic2, 0), StickyAssignorTest.tp(topic2, 2)), assignment.get(consumer2));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testAddRemoveConsumerOneTopic() {
        String topic = "topic";
        String consumer1 = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0), StickyAssignorTest.tp(topic, 1), StickyAssignorTest.tp(topic, 2)), assignment.get(consumer1));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        String consumer2 = "consumer2";
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer1)))));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 1), StickyAssignorTest.tp(topic, 2)), assignment.get(consumer1));
        Assert.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(topic, 0)), assignment.get(consumer2));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
        subscriptions.remove(consumer1);
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer2)))));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertTrue((boolean)((List)assignment.get(consumer2)).contains(StickyAssignorTest.tp(topic, 0)));
        Assert.assertTrue((boolean)((List)assignment.get(consumer2)).contains(StickyAssignorTest.tp(topic, 1)));
        Assert.assertTrue((boolean)((List)assignment.get(consumer2)).contains(StickyAssignorTest.tp(topic, 2)));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testPoorRoundRobinAssignmentScenario() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i <= 5; ++i) {
            partitionsPerTopic.put(String.format("topic%d", i), i % 2 + 1);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put("consumer1", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5")));
        subscriptions.put("consumer2", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic1", "topic3", "topic5")));
        subscriptions.put("consumer3", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic1", "topic3", "topic5")));
        subscriptions.put("consumer4", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5")));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
    }

    @Test
    public void testAddRemoveTopicTwoConsumers() {
        String topic = "topic";
        String consumer1 = "consumer";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        List consumer1Assignment1 = (List)assignment.get(consumer1);
        List consumer2Assignment1 = (List)assignment.get(consumer2);
        Assert.assertTrue((consumer1Assignment1.size() == 1 && consumer2Assignment1.size() == 2 || consumer1Assignment1.size() == 2 && consumer2Assignment1.size() == 1 ? 1 : 0) != 0);
        String topic2 = "topic2";
        partitionsPerTopic.put(topic2, 3);
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic, topic2), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer1)))));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic, topic2), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer2)))));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        List consumer1assignment = (List)assignment.get(consumer1);
        List consumer2assignment = (List)assignment.get(consumer2);
        Assert.assertTrue((consumer1assignment.size() == 3 && consumer2assignment.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment1));
        Assert.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment1));
        Assert.assertTrue((boolean)this.assignor.isSticky());
        partitionsPerTopic.remove(topic);
        subscriptions.put(consumer1, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic2), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer1)))));
        subscriptions.put(consumer2, new PartitionAssignor.Subscription(StickyAssignorTest.topics(topic2), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer2)))));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        List consumer1Assignment3 = (List)assignment.get(consumer1);
        List consumer2Assignment3 = (List)assignment.get(consumer2);
        Assert.assertTrue((consumer1Assignment3.size() == 1 && consumer2Assignment3.size() == 2 || consumer1Assignment3.size() == 2 && consumer2Assignment3.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment3));
        Assert.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment3));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testReassignmentAfterOneConsumerLeaves() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i < 20; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 20), i);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (int i = 1; i < 20; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= i; ++j) {
                topics.add(this.getTopicName(j, 20));
            }
            subscriptions.put(this.getConsumerName(i, 20), new PartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        for (int i = 1; i < 20; ++i) {
            String consumer = this.getConsumerName(i, 20);
            subscriptions.put(consumer, new PartitionAssignor.Subscription(((PartitionAssignor.Subscription)subscriptions.get(consumer)).topics(), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer)))));
        }
        subscriptions.remove("consumer10");
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testReassignmentAfterOneConsumerAdded() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 20);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (int i = 1; i < 10; ++i) {
            subscriptions.put(this.getConsumerName(i, 10), new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic")));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        subscriptions.put(this.getConsumerName(10, 10), new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic")));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testSameSubscriptions() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i < 15; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 15), i);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (int i = 1; i < 9; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= partitionsPerTopic.size(); ++j) {
                topics.add(this.getTopicName(j, 15));
            }
            subscriptions.put(this.getConsumerName(i, 9), new PartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        for (int i = 1; i < 9; ++i) {
            String consumer = this.getConsumerName(i, 9);
            subscriptions.put(consumer, new PartitionAssignor.Subscription(((PartitionAssignor.Subscription)subscriptions.get(consumer)).topics(), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer)))));
        }
        subscriptions.remove(this.getConsumerName(5, 9));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testLargeAssignmentWithMultipleConsumersLeaving() {
        int i;
        Random rand = new Random();
        int topicCount = 40;
        int consumerCount = 200;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < topicCount; ++i2) {
            partitionsPerTopic.put(this.getTopicName(i2, topicCount), rand.nextInt(10) + 1);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (int i3 = 0; i3 < consumerCount; ++i3) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 0; j < rand.nextInt(20); ++j) {
                topics.add(this.getTopicName(rand.nextInt(topicCount), topicCount));
            }
            subscriptions.put(this.getConsumerName(i3, consumerCount), new PartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        for (i = 1; i < consumerCount; ++i) {
            String consumer = this.getConsumerName(i, consumerCount);
            subscriptions.put(consumer, new PartitionAssignor.Subscription(((PartitionAssignor.Subscription)subscriptions.get(consumer)).topics(), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer)))));
        }
        for (i = 0; i < 50; ++i) {
            String c = this.getConsumerName(rand.nextInt(consumerCount), consumerCount);
            subscriptions.remove(c);
        }
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testNewSubscription() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i < 5; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 5), 1);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (int i = 0; i < 3; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = i; j <= 3 * i - 2; ++j) {
                topics.add(this.getTopicName(j, 5));
            }
            subscriptions.put(this.getConsumerName(i, 3), new PartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        ((PartitionAssignor.Subscription)subscriptions.get(this.getConsumerName(0, 3))).topics().add(this.getTopicName(1, 5));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testReassignmentWithRandomSubscriptionsAndChanges() {
        int minNumConsumers = 20;
        int maxNumConsumers = 40;
        int minNumTopics = 10;
        int maxNumTopics = 20;
        for (int round = 1; round <= 100; ++round) {
            int numTopics = 10 + new Random().nextInt(10);
            ArrayList<String> topics = new ArrayList<String>();
            for (int i = 0; i < numTopics; ++i) {
                topics.add(this.getTopicName(i, 20));
            }
            HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
            for (int i = 0; i < numTopics; ++i) {
                partitionsPerTopic.put(this.getTopicName(i, 20), i + 1);
            }
            int numConsumers = 20 + new Random().nextInt(20);
            HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(StickyAssignorTest.getRandomSublist(topics));
                subscriptions.put(this.getConsumerName(i, 40), new PartitionAssignor.Subscription(sub));
            }
            StickyAssignor assignor = new StickyAssignor();
            Map assignment = assignor.assign(partitionsPerTopic, subscriptions);
            StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
            subscriptions.clear();
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(StickyAssignorTest.getRandomSublist(topics));
                String consumer = this.getConsumerName(i, 40);
                subscriptions.put(consumer, new PartitionAssignor.Subscription(sub, StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get(consumer)))));
            }
            assignment = assignor.assign(partitionsPerTopic, subscriptions);
            StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
            Assert.assertTrue((boolean)assignor.isSticky());
        }
    }

    @Test
    public void testMoveExistingAssignments() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i <= 6; ++i) {
            partitionsPerTopic.put(String.format("topic%02d", i), 1);
        }
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put("consumer01", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01", "topic02"), StickyAssignor.serializeTopicPartitionAssignment(StickyAssignorTest.partitions(StickyAssignorTest.tp("topic01", 0)))));
        subscriptions.put("consumer02", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01", "topic02", "topic03", "topic04"), StickyAssignor.serializeTopicPartitionAssignment(StickyAssignorTest.partitions(StickyAssignorTest.tp("topic02", 0), StickyAssignorTest.tp("topic03", 0)))));
        subscriptions.put("consumer03", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic02", "topic03", "topic04", "topic05", "topic06"), StickyAssignor.serializeTopicPartitionAssignment(StickyAssignorTest.partitions(StickyAssignorTest.tp("topic04", 0), StickyAssignorTest.tp("topic05", 0), StickyAssignorTest.tp("topic06", 0)))));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
    }

    @Test
    public void testStickiness() {
        List topicPartitions;
        String consumer;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic01", 3);
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        subscriptions.put("consumer01", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01")));
        subscriptions.put("consumer02", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01")));
        subscriptions.put("consumer03", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01")));
        subscriptions.put("consumer04", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01")));
        Map assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        HashMap partitionsAssigned = new HashMap();
        Set assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            int size = topicPartitions.size();
            Assert.assertTrue((String)("Consumer " + consumer + " is assigned more topic partitions than expected."), (size <= 1 ? 1 : 0) != 0);
            if (size != 1) continue;
            partitionsAssigned.put(consumer, topicPartitions.get(0));
        }
        subscriptions.remove("consumer01");
        subscriptions.put("consumer02", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01"), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get("consumer02")))));
        subscriptions.put("consumer03", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01"), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get("consumer03")))));
        subscriptions.put("consumer04", new PartitionAssignor.Subscription(StickyAssignorTest.topics("topic01"), StickyAssignor.serializeTopicPartitionAssignment((List)((List)assignment.get("consumer04")))));
        assignment = this.assignor.assign(partitionsPerTopic, subscriptions);
        StickyAssignorTest.verifyValidityAndBalance(subscriptions, assignment);
        Assert.assertTrue((boolean)this.assignor.isSticky());
        assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            Assert.assertEquals((String)("Consumer " + consumer + " is assigned more topic partitions than expected."), (long)1L, (long)topicPartitions.size());
            Assert.assertTrue((String)("Stickiness was not honored for consumer " + consumer), (!partitionsAssigned.containsKey(consumer) || ((List)assignment.get(consumer)).contains(partitionsAssigned.get(consumer)) ? 1 : 0) != 0);
        }
    }

    private String getTopicName(int i, int maxNum) {
        return this.getCanonicalName("t", i, maxNum);
    }

    private String getConsumerName(int i, int maxNum) {
        return this.getCanonicalName("c", i, maxNum);
    }

    private String getCanonicalName(String str, int i, int maxNum) {
        return str + this.pad(i, Integer.toString(maxNum).length());
    }

    private String pad(int num, int digits) {
        StringBuilder sb = new StringBuilder();
        int iDigits = Integer.toString(num).length();
        for (int i = 1; i <= digits - iDigits; ++i) {
            sb.append("0");
        }
        sb.append(num);
        return sb.toString();
    }

    private static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    private static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    private static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }

    private static boolean isFullyBalanced(Map<String, List<TopicPartition>> assignment) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (List<TopicPartition> topicPartitions : assignment.values()) {
            int size = topicPartitions.size();
            if (size < min) {
                min = size;
            }
            if (size <= max) continue;
            max = size;
        }
        return max - min <= 1;
    }

    private static List<String> getRandomSublist(ArrayList<String> list) {
        ArrayList<String> selectedItems = new ArrayList<String>(list);
        int len = list.size();
        Random random = new Random();
        int howManyToRemove = random.nextInt(len);
        for (int i = 1; i <= howManyToRemove; ++i) {
            selectedItems.remove(random.nextInt(selectedItems.size()));
        }
        return selectedItems;
    }

    private static void verifyValidityAndBalance(Map<String, PartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        int size = subscriptions.size();
        assert (size == assignments.size());
        List consumers = Utils.sorted(assignments.keySet());
        for (int i = 0; i < size; ++i) {
            String consumer = (String)consumers.get(i);
            List<TopicPartition> partitions = assignments.get(consumer);
            for (TopicPartition partition : partitions) {
                Assert.assertTrue((String)("Error: Partition " + partition + "is assigned to c" + i + ", but it is not subscribed to Topic t" + partition.topic() + "\nSubscriptions: " + subscriptions.toString() + "\nAssignments: " + assignments.toString()), (boolean)subscriptions.get(consumer).topics().contains(partition.topic()));
            }
            if (i == size - 1) continue;
            for (int j = i + 1; j < size; ++j) {
                String otherConsumer = (String)consumers.get(j);
                List<TopicPartition> otherPartitions = assignments.get(otherConsumer);
                HashSet<TopicPartition> intersection = new HashSet<TopicPartition>(partitions);
                intersection.retainAll(otherPartitions);
                Assert.assertTrue((String)("Error: Consumers c" + i + " and c" + j + " have common partitions assigned to them: " + ((Object)intersection).toString() + "\nSubscriptions: " + subscriptions.toString() + "\nAssignments: " + assignments.toString()), (boolean)intersection.isEmpty());
                int len = partitions.size();
                int otherLen = otherPartitions.size();
                if (Math.abs(len - otherLen) <= 1) continue;
                Map map = CollectionUtils.groupDataByTopic(partitions);
                Map otherMap = CollectionUtils.groupDataByTopic(otherPartitions);
                if (len > otherLen) {
                    for (String topic : map.keySet()) {
                        Assert.assertTrue((String)("Error: Some partitions can be moved from c" + i + " to c" + j + " to achieve a better balance\nc" + i + " has " + len + " partitions, and c" + j + " has " + otherLen + " partitions.\nSubscriptions: " + subscriptions.toString() + "\nAssignments: " + assignments.toString()), (!otherMap.containsKey(topic) ? 1 : 0) != 0);
                    }
                }
                if (otherLen <= len) continue;
                for (String topic : otherMap.keySet()) {
                    Assert.assertTrue((String)("Error: Some partitions can be moved from c" + j + " to c" + i + " to achieve a better balance\nc" + i + " has " + len + " partitions, and c" + j + " has " + otherLen + " partitions.\nSubscriptions: " + subscriptions.toString() + "\nAssignments: " + assignments.toString()), (!map.containsKey(topic) ? 1 : 0) != 0);
                }
            }
        }
    }
}

