/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerClientInitialResponseTest {
    @Test
    public void testToken() throws Exception {
        String message = "n,,\u0001auth=Bearer 123.345.567\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"123.345.567", (Object)response.tokenValue());
        Assert.assertEquals((Object)"", (Object)response.authorizationId());
    }

    @Test
    public void testAuthorizationId() throws Exception {
        String message = "n,a=myuser,\u0001auth=Bearer 345\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"345", (Object)response.tokenValue());
        Assert.assertEquals((Object)"myuser", (Object)response.authorizationId());
    }

    @Test
    public void testProperties() throws Exception {
        String message = "n,,\u0001propA=valueA1, valueA2\u0001auth=Bearer 567\u0001propB=valueB\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"567", (Object)response.tokenValue());
        Assert.assertEquals((Object)"", (Object)response.authorizationId());
        Assert.assertEquals((Object)"valueA1, valueA2", (Object)response.propertyValue("propA"));
        Assert.assertEquals((Object)"valueB", (Object)response.propertyValue("propB"));
    }

    @Test
    public void testRfc7688Example() throws Exception {
        String message = "n,a=user@example.com,\u0001host=server.example.com\u0001port=143\u0001auth=Bearer vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg\u0001\u0001";
        OAuthBearerClientInitialResponse response = new OAuthBearerClientInitialResponse(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"vF9dft4qmTc2Nvb3RlckBhbHRhdmlzdGEuY29tCg", (Object)response.tokenValue());
        Assert.assertEquals((Object)"user@example.com", (Object)response.authorizationId());
        Assert.assertEquals((Object)"server.example.com", (Object)response.propertyValue("host"));
        Assert.assertEquals((Object)"143", (Object)response.propertyValue("port"));
    }
}

