/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class ClientUtilsTest {
    @Test
    public void testParseAndValidateAddresses() {
        this.check("127.0.0.1:8000");
        this.check("mydomain.com:8080");
        this.check("[::1]:8000");
        this.check("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "mydomain.com:10000");
        List<InetSocketAddress> validatedAddresses = this.check("some.invalid.hostname.foo.bar.local:9999", "mydomain.com:10000");
        Assert.assertEquals((long)1L, (long)validatedAddresses.size());
        InetSocketAddress onlyAddress = validatedAddresses.get(0);
        Assert.assertEquals((Object)"mydomain.com", (Object)onlyAddress.getHostName());
        Assert.assertEquals((long)10000L, (long)onlyAddress.getPort());
    }

    @Test(expected=ConfigException.class)
    public void testNoPort() {
        this.check("127.0.0.1");
    }

    @Test(expected=ConfigException.class)
    public void testOnlyBadHostname() {
        this.check("some.invalid.hostname.foo.bar.local:9999");
    }

    private List<InetSocketAddress> check(String ... url) {
        return ClientUtils.parseAndValidateAddresses(Arrays.asList(url));
    }
}

