/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class CreateDelegationTokenRequestData
implements ApiMessage {
    private List<CreatableRenewers> renewers = new ArrayList<CreatableRenewers>();
    private long maxLifetimeMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreateDelegationTokenRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public CreateDelegationTokenRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public CreateDelegationTokenRequestData() {
        this.maxLifetimeMs = 0L;
    }

    public short apiKey() {
        return 38;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.renewers.clear();
        } else {
            this.renewers.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.renewers.add(new CreatableRenewers(readable, version));
            }
        }
        this.maxLifetimeMs = readable.readLong();
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.renewers.size());
        for (CreatableRenewers element : this.renewers) {
            element.write(writable, version);
        }
        writable.writeLong(this.maxLifetimeMs);
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("renewers");
        this.renewers = new ArrayList<CreatableRenewers>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.renewers.add(new CreatableRenewers((Struct)nestedObject, version));
        }
        this.maxLifetimeMs = struct.getLong("max_lifetime_ms");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.renewers.size()];
        int i = 0;
        for (CreatableRenewers element : this.renewers) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("renewers", (Object)nestedObjects);
        struct.set("max_lifetime_ms", (Object)this.maxLifetimeMs);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        for (CreatableRenewers element : this.renewers) {
            size += element.size(version);
        }
        return size += 8;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateDelegationTokenRequestData)) {
            return false;
        }
        CreateDelegationTokenRequestData other = (CreateDelegationTokenRequestData)obj;
        if (this.renewers == null ? other.renewers != null : !this.renewers.equals(other.renewers)) {
            return false;
        }
        return this.maxLifetimeMs == other.maxLifetimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.renewers == null ? 0 : this.renewers.hashCode());
        hashCode = 31 * hashCode + ((int)(this.maxLifetimeMs >> 32) ^ (int)this.maxLifetimeMs);
        return hashCode;
    }

    public String toString() {
        return "CreateDelegationTokenRequestData(renewers=" + MessageUtil.deepToString(this.renewers.iterator()) + ", maxLifetimeMs=" + this.maxLifetimeMs + ")";
    }

    public List<CreatableRenewers> renewers() {
        return this.renewers;
    }

    public long maxLifetimeMs() {
        return this.maxLifetimeMs;
    }

    public CreateDelegationTokenRequestData setRenewers(List<CreatableRenewers> v) {
        this.renewers = v;
        return this;
    }

    public CreateDelegationTokenRequestData setMaxLifetimeMs(long v) {
        this.maxLifetimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("renewers", (Type)new ArrayOf((Type)CreatableRenewers.SCHEMA_0), "A list of those who are allowed to renew this token before it expires."), new Field("max_lifetime_ms", (Type)Type.INT64, "The maximum lifetime of the token in milliseconds, or -1 to use the server side default.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class CreatableRenewers
    implements Message {
        private String principalType;
        private String principalName;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatableRenewers(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatableRenewers(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatableRenewers() {
            this.principalType = "";
            this.principalName = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.principalType = readable.readNullableString();
            this.principalName = readable.readNullableString();
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.principalType);
            writable.writeString(this.principalName);
        }

        public void fromStruct(Struct struct, short version) {
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.principalType);
            size += 2;
            return size += MessageUtil.serializedUtf8Length((CharSequence)this.principalName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableRenewers)) {
                return false;
            }
            CreatableRenewers other = (CreatableRenewers)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            return !(this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatableRenewers(principalType='" + this.principalType + "', principalName='" + this.principalName + "')";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public CreatableRenewers setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public CreatableRenewers setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("principal_type", (Type)Type.STRING, "The type of the Kafka principal."), new Field("principal_name", (Type)Type.STRING, "The name of the Kafka principal.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

