/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DeleteGroupsRequestData
implements ApiMessage {
    private List<String> groupsNames = new ArrayList<String>();
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DeleteGroupsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DeleteGroupsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DeleteGroupsRequestData() {
    }

    public short apiKey() {
        return 42;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.groupsNames.clear();
        } else {
            this.groupsNames.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.groupsNames.add(readable.readNullableString());
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.groupsNames.size());
        for (String element : this.groupsNames) {
            writable.writeString(element);
        }
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("groups_names");
        this.groupsNames = new ArrayList<String>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.groupsNames.add((String)nestedObject);
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        String[] nestedObjects = new String[this.groupsNames.size()];
        int i = 0;
        for (String element : this.groupsNames) {
            nestedObjects[i++] = element;
        }
        struct.set("groups_names", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        for (String element : this.groupsNames) {
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)element);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteGroupsRequestData)) {
            return false;
        }
        DeleteGroupsRequestData other = (DeleteGroupsRequestData)obj;
        return !(this.groupsNames == null ? other.groupsNames != null : !this.groupsNames.equals(other.groupsNames));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupsNames == null ? 0 : this.groupsNames.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteGroupsRequestData(groupsNames=" + MessageUtil.deepToString(this.groupsNames.iterator()) + ")";
    }

    public List<String> groupsNames() {
        return this.groupsNames;
    }

    public DeleteGroupsRequestData setGroupsNames(List<String> v) {
        this.groupsNames = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("groups_names", (Type)new ArrayOf((Type)Type.STRING), "The group names to delete.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

