/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ListOffsetRequestData
implements ApiMessage {
    private int replicaId;
    private byte isolationLevel;
    private List<ListOffsetTopic> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_0), "Each topic in the request.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_1), "Each topic in the request.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public ListOffsetRequestData(Readable readable, short version) {
        this.topics = new ArrayList<ListOffsetTopic>();
        this.read(readable, version);
    }

    public ListOffsetRequestData(Struct struct, short version) {
        this.topics = new ArrayList<ListOffsetTopic>();
        this.fromStruct(struct, version);
    }

    public ListOffsetRequestData() {
        this.replicaId = 0;
        this.isolationLevel = 0;
        this.topics = new ArrayList<ListOffsetTopic>();
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable readable, short version) {
        this.replicaId = readable.readInt();
        this.isolationLevel = version >= 2 ? readable.readByte() : (byte)0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new ListOffsetTopic(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.replicaId);
        if (version >= 2) {
            writable.writeByte(this.isolationLevel);
        }
        writable.writeInt(this.topics.size());
        for (ListOffsetTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.replicaId = struct.getInt("replica_id");
        this.isolationLevel = version >= 2 ? struct.getByte("isolation_level") : (byte)0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new ListOffsetTopic((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("replica_id", (Object)this.replicaId);
        if (version >= 2) {
            struct.set("isolation_level", (Object)this.isolationLevel);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        if (version >= 2) {
            ++size;
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + version);
        }
        size += 4;
        for (ListOffsetTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetRequestData)) {
            return false;
        }
        ListOffsetRequestData other = (ListOffsetRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.isolationLevel != other.isolationLevel) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + this.isolationLevel;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ListOffsetRequestData(replicaId=" + this.replicaId + ", isolationLevel=" + this.isolationLevel + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public byte isolationLevel() {
        return this.isolationLevel;
    }

    public List<ListOffsetTopic> topics() {
        return this.topics;
    }

    public ListOffsetRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public ListOffsetRequestData setIsolationLevel(byte v) {
        this.isolationLevel = v;
        return this;
    }

    public ListOffsetRequestData setTopics(List<ListOffsetTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", (Type)Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_1), "Each topic in the request.")});
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", (Type)Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_4), "Each topic in the request.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartition
    implements Message {
        private int partitionIndex;
        private int currentLeaderEpoch;
        private long timestamp;
        private int maxNumOffsets;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("timestamp", (Type)Type.INT64, "The current timestamp."), new Field("max_num_offsets", (Type)Type.INT32, "The maximum number of offsets to report.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public ListOffsetPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public ListOffsetPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = 0;
            this.timestamp = 0L;
            this.maxNumOffsets = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.currentLeaderEpoch = version >= 4 ? readable.readInt() : 0;
            this.timestamp = readable.readLong();
            this.maxNumOffsets = version <= 0 ? readable.readInt() : 0;
        }

        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            if (version >= 4) {
                writable.writeInt(this.currentLeaderEpoch);
            }
            writable.writeLong(this.timestamp);
            if (version <= 0) {
                writable.writeInt(this.maxNumOffsets);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = version >= 4 ? struct.getInt("current_leader_epoch") : 0;
            this.timestamp = struct.getLong("timestamp");
            this.maxNumOffsets = version <= 0 ? struct.getInt("max_num_offsets") : 0;
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (version >= 4) {
                struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            }
            struct.set("timestamp", (Object)this.timestamp);
            if (version <= 0) {
                struct.set("max_num_offsets", (Object)this.maxNumOffsets);
            }
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 4;
            if (version >= 4) {
                size += 4;
            } else if (this.currentLeaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeaderEpoch at version " + version);
            }
            size += 8;
            if (version <= 0) {
                size += 4;
            } else if (this.maxNumOffsets != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartition)) {
                return false;
            }
            ListOffsetPartition other = (ListOffsetPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return this.maxNumOffsets == other.maxNumOffsets;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + this.maxNumOffsets;
            return hashCode;
        }

        public String toString() {
            return "ListOffsetPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", timestamp=" + this.timestamp + ", maxNumOffsets=" + this.maxNumOffsets + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int maxNumOffsets() {
            return this.maxNumOffsets;
        }

        public ListOffsetPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public ListOffsetPartition setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartition setMaxNumOffsets(int v) {
            this.maxNumOffsets = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("timestamp", (Type)Type.INT64, "The current timestamp.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("current_leader_epoch", (Type)Type.INT32, "The current leader epoch."), new Field("timestamp", (Type)Type.INT64, "The current timestamp.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopic
    implements Message {
        private String name;
        private List<ListOffsetPartition> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_0), "Each partition in the request.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetTopic(Readable readable, short version) {
            this.partitions = new ArrayList<ListOffsetPartition>();
            this.read(readable, version);
        }

        public ListOffsetTopic(Struct struct, short version) {
            this.partitions = new ArrayList<ListOffsetPartition>();
            this.fromStruct(struct, version);
        }

        public ListOffsetTopic() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartition>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new ListOffsetPartition(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (ListOffsetPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new ListOffsetPartition((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            for (ListOffsetPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopic)) {
                return false;
            }
            ListOffsetTopic other = (ListOffsetTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ListOffsetTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartition> partitions() {
            return this.partitions;
        }

        public ListOffsetTopic setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopic setPartitions(List<ListOffsetPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_1), "Each partition in the request.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_4), "Each partition in the request.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

