/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ListOffsetResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<ListOffsetTopicResponse> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_0), "Each topic in the response.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public ListOffsetResponseData(Readable readable, short version) {
        this.topics = new ArrayList<ListOffsetTopicResponse>();
        this.read(readable, version);
    }

    public ListOffsetResponseData(Struct struct, short version) {
        this.topics = new ArrayList<ListOffsetTopicResponse>();
        this.fromStruct(struct, version);
    }

    public ListOffsetResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<ListOffsetTopicResponse>();
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 2 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new ListOffsetTopicResponse(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        if (version >= 2) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.topics.size());
        for (ListOffsetTopicResponse element : this.topics) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopicResponse>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new ListOffsetTopicResponse((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopicResponse element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        if (version >= 2) {
            size += 4;
        }
        size += 4;
        for (ListOffsetTopicResponse element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetResponseData)) {
            return false;
        }
        ListOffsetResponseData other = (ListOffsetResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ListOffsetResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ListOffsetTopicResponse> topics() {
        return this.topics;
    }

    public ListOffsetResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListOffsetResponseData setTopics(List<ListOffsetTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response.")});
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_4), "Each topic in the response.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private List<Long> oldStyleOffsets;
        private long timestamp;
        private long offset;
        private int leaderEpoch;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("old_style_offsets", (Type)new ArrayOf((Type)Type.INT64), "The result offsets.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetPartitionResponse(Readable readable, short version) {
            this.oldStyleOffsets = new ArrayList<Long>();
            this.read(readable, version);
        }

        public ListOffsetPartitionResponse(Struct struct, short version) {
            this.oldStyleOffsets = new ArrayList<Long>();
            this.fromStruct(struct, version);
        }

        public ListOffsetPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.oldStyleOffsets = new ArrayList<Long>();
            this.timestamp = -1L;
            this.offset = -1L;
            this.leaderEpoch = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
            if (version <= 0) {
                int arrayLength = readable.readInt();
                if (arrayLength < 0) {
                    this.oldStyleOffsets.clear();
                } else {
                    this.oldStyleOffsets.clear();
                    for (int i = 0; i < arrayLength; ++i) {
                        this.oldStyleOffsets.add(readable.readLong());
                    }
                }
            } else {
                this.oldStyleOffsets = new ArrayList<Long>();
            }
            this.timestamp = version >= 1 ? readable.readLong() : -1L;
            this.offset = version >= 1 ? readable.readLong() : -1L;
            this.leaderEpoch = version >= 4 ? readable.readInt() : 0;
        }

        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
            if (version <= 0) {
                writable.writeInt(this.oldStyleOffsets.size());
                for (Long element : this.oldStyleOffsets) {
                    writable.writeLong(element.longValue());
                }
            }
            if (version >= 1) {
                writable.writeLong(this.timestamp);
            }
            if (version >= 1) {
                writable.writeLong(this.offset);
            }
            if (version >= 4) {
                writable.writeInt(this.leaderEpoch);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            if (version <= 0) {
                Object[] nestedObjects = struct.getArray("old_style_offsets");
                this.oldStyleOffsets = new ArrayList<Long>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.oldStyleOffsets.add((Long)nestedObject);
                }
            } else {
                this.oldStyleOffsets = new ArrayList<Long>();
            }
            this.timestamp = version >= 1 ? struct.getLong("timestamp") : -1L;
            this.offset = version >= 1 ? struct.getLong("offset") : -1L;
            this.leaderEpoch = version >= 4 ? struct.getInt("leader_epoch") : 0;
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            if (version <= 0) {
                Long[] nestedObjects = new Long[this.oldStyleOffsets.size()];
                int i = 0;
                for (Long element : this.oldStyleOffsets) {
                    nestedObjects[i++] = element;
                }
                struct.set("old_style_offsets", (Object)nestedObjects);
            }
            if (version >= 1) {
                struct.set("timestamp", (Object)this.timestamp);
            }
            if (version >= 1) {
                struct.set("offset", (Object)this.offset);
            }
            if (version >= 4) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            }
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            if (version <= 0) {
                size += 4;
                size += this.oldStyleOffsets.size() * 8;
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + version);
            }
            if (version >= 1) {
                size += 8;
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + version);
            }
            if (version >= 1) {
                size += 8;
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + version);
            }
            if (version >= 4) {
                size += 4;
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartitionResponse)) {
                return false;
            }
            ListOffsetPartitionResponse other = (ListOffsetPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.oldStyleOffsets == null ? other.oldStyleOffsets != null : !this.oldStyleOffsets.equals(other.oldStyleOffsets)) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.leaderEpoch == other.leaderEpoch;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.oldStyleOffsets == null ? 0 : this.oldStyleOffsets.hashCode());
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public String toString() {
            return "ListOffsetPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", oldStyleOffsets=" + MessageUtil.deepToString(this.oldStyleOffsets.iterator()) + ", timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public List<Long> oldStyleOffsets() {
            return this.oldStyleOffsets;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long offset() {
            return this.offset;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public ListOffsetPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ListOffsetPartitionResponse setOldStyleOffsets(List<Long> v) {
            this.oldStyleOffsets = v;
            return this;
        }

        public ListOffsetPartitionResponse setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartitionResponse setOffset(long v) {
            this.offset = v;
            return this;
        }

        public ListOffsetPartitionResponse setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset."), new Field("leader_epoch", (Type)Type.INT32, "")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopicResponse
    implements Message {
        private String name;
        private List<ListOffsetPartitionResponse> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_0), "Each partition in the response.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetTopicResponse(Readable readable, short version) {
            this.partitions = new ArrayList<ListOffsetPartitionResponse>();
            this.read(readable, version);
        }

        public ListOffsetTopicResponse(Struct struct, short version) {
            this.partitions = new ArrayList<ListOffsetPartitionResponse>();
            this.fromStruct(struct, version);
        }

        public ListOffsetTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartitionResponse>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new ListOffsetPartitionResponse(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (ListOffsetPartitionResponse element : this.partitions) {
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartitionResponse>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new ListOffsetPartitionResponse((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartitionResponse element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            for (ListOffsetPartitionResponse element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopicResponse)) {
                return false;
            }
            ListOffsetTopicResponse other = (ListOffsetTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ListOffsetTopicResponse(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartitionResponse> partitions() {
            return this.partitions;
        }

        public ListOffsetTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopicResponse setPartitions(List<ListOffsetPartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_1), "Each partition in the response.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_4), "Each partition in the response.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

