/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Collections;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;

public class RequestContextTest {
    @Test
    public void testSerdeUnsupportedApiVersionRequest() throws Exception {
        int correlationId = 23423;
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, Short.MAX_VALUE, "", correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL);
        Assert.assertEquals((long)0L, (long)context.apiVersion());
        ByteBuffer requestBuffer = ByteBuffer.allocate(8);
        requestBuffer.putInt(3709234);
        requestBuffer.putInt(29034);
        requestBuffer.flip();
        RequestAndSize requestAndSize = context.parseRequest(requestBuffer);
        Assert.assertTrue((boolean)(requestAndSize.request instanceof ApiVersionsRequest));
        ApiVersionsRequest request = (ApiVersionsRequest)requestAndSize.request;
        Assert.assertTrue((boolean)request.hasUnsupportedRequestVersion());
        Send send = context.buildResponse((AbstractResponse)new ApiVersionsResponse(0, Errors.UNSUPPORTED_VERSION, Collections.emptyList()));
        ByteBufferChannel channel = new ByteBufferChannel(256L);
        send.writeTo((GatheringByteChannel)channel);
        ByteBuffer responseBuffer = channel.buffer();
        responseBuffer.flip();
        responseBuffer.getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer);
        Assert.assertEquals((long)correlationId, (long)responseHeader.correlationId());
        Struct struct = ApiKeys.API_VERSIONS.parseResponse((short)0, responseBuffer);
        ApiVersionsResponse response = (ApiVersionsResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.API_VERSIONS, (Struct)struct, (short)0);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)response.error());
        Assert.assertTrue((boolean)response.apiVersions().isEmpty());
    }
}

