/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.expiring;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredential;
import org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshConfig;
import org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshingLogin;
import org.apache.kafka.common.utils.MockScheduler;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ExpiringCredentialRefreshingLoginTest {
    private static final Configuration EMPTY_WILDCARD_CONFIGURATION = new Configuration(){

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[0];
        }
    };

    @Test
    public void testRefresh() throws Exception {
        for (int numExpectedRefreshes : new int[]{0, 1, 2}) {
            for (boolean clientReloginAllowedBeforeLogout : new boolean[]{true, false}) {
                short minPeriodSeconds;
                Subject subject = new Subject();
                LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
                Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
                MockTime mockTime = new MockTime();
                long startMs = mockTime.milliseconds();
                long lifetimeMinutes = 100L;
                long refreshEveryMinutes = 80L;
                long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
                short bufferSeconds = minPeriodSeconds = 0;
                MockScheduler mockScheduler = new MockScheduler(mockTime);
                List<KafkaFutureImpl<Long>> waiters = ExpiringCredentialRefreshingLoginTest.addWaiters(mockScheduler, 60000L * refreshEveryMinutes, numExpectedRefreshes + 1);
                TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
                TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout);
                testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
                long expectedFinalMs = startMs + (long)(numExpectedRefreshes * 1000 * 60) * refreshEveryMinutes;
                Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
                Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
                testExpiringCredentialRefreshingLogin.login();
                Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
                testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
                Assert.assertEquals((long)expectedFinalMs, (long)mockTime.milliseconds());
                for (int i = 0; i < numExpectedRefreshes; ++i) {
                    KafkaFutureImpl<Long> waiter = waiters.get(i);
                    Assert.assertTrue((boolean)waiter.isDone());
                    Assert.assertEquals((long)((long)((i + 1) * 1000 * 60) * refreshEveryMinutes), (long)((Long)waiter.get() - startMs));
                }
                Assert.assertFalse((boolean)waiters.get(numExpectedRefreshes).isDone());
                InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockLoginContext});
                ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
                ((LoginContext)inOrder.verify((Object)mockLoginContext)).getSubject();
                for (int i = 0; i < numExpectedRefreshes; ++i) {
                    if (clientReloginAllowedBeforeLogout) {
                        ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
                        ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
                        continue;
                    }
                    ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
                    ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
                }
            }
        }
    }

    @Test
    public void testRefreshWithExpirationSmallerThanConfiguredBuffers() throws Exception {
        short minPeriodSeconds;
        int numExpectedRefreshes = 1;
        boolean clientReloginAllowedBeforeLogout = true;
        LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Subject subject = new Subject();
        Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
        MockTime mockTime = new MockTime();
        long startMs = mockTime.milliseconds();
        long lifetimeMinutes = 10L;
        long refreshEveryMinutes = 8L;
        long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
        short bufferSeconds = minPeriodSeconds = (short)(1L + lifetimeMinutes * 60L / 2L);
        MockScheduler mockScheduler = new MockScheduler(mockTime);
        List<KafkaFutureImpl<Long>> waiters = ExpiringCredentialRefreshingLoginTest.addWaiters(mockScheduler, 60000L * refreshEveryMinutes, numExpectedRefreshes + 1);
        TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
        TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout);
        testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
        long expectedFinalMs = startMs + (long)(numExpectedRefreshes * 1000 * 60) * refreshEveryMinutes;
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
        testExpiringCredentialRefreshingLogin.login();
        Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedFinalMs, (long)mockTime.milliseconds());
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            KafkaFutureImpl<Long> waiter = waiters.get(i);
            Assert.assertTrue((boolean)waiter.isDone());
            Assert.assertEquals((long)((long)((i + 1) * 1000 * 60) * refreshEveryMinutes), (long)((Long)waiter.get() - startMs));
        }
        Assert.assertFalse((boolean)waiters.get(numExpectedRefreshes).isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockLoginContext});
        ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
        }
    }

    @Test
    public void testRefreshWithExpirationSmallerThanConfiguredBuffersAndOlderCreateTime() throws Exception {
        short minPeriodSeconds;
        int numExpectedRefreshes = 1;
        boolean clientReloginAllowedBeforeLogout = true;
        LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Subject subject = new Subject();
        Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
        MockTime mockTime = new MockTime();
        long startMs = mockTime.milliseconds();
        long lifetimeMinutes = 10L;
        long refreshEveryMinutes = 8L;
        long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
        short bufferSeconds = minPeriodSeconds = (short)(1L + lifetimeMinutes * 60L / 2L);
        MockScheduler mockScheduler = new MockScheduler(mockTime);
        List<KafkaFutureImpl<Long>> waiters = ExpiringCredentialRefreshingLoginTest.addWaiters(mockScheduler, 60000L * refreshEveryMinutes, numExpectedRefreshes + 1);
        TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
        TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout){

            @Override
            public long getCreateMs() {
                return super.getCreateMs() - 3600000L;
            }
        };
        testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
        long expectedFinalMs = startMs + (long)(numExpectedRefreshes * 1000 * 60) * refreshEveryMinutes;
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
        testExpiringCredentialRefreshingLogin.login();
        Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedFinalMs, (long)mockTime.milliseconds());
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            KafkaFutureImpl<Long> waiter = waiters.get(i);
            Assert.assertTrue((boolean)waiter.isDone());
            Assert.assertEquals((long)((long)((i + 1) * 1000 * 60) * refreshEveryMinutes), (long)((Long)waiter.get() - startMs));
        }
        Assert.assertFalse((boolean)waiters.get(numExpectedRefreshes).isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockLoginContext});
        ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
        }
    }

    @Test
    public void testRefreshWithMinPeriodIntrusion() throws Exception {
        int numExpectedRefreshes = 1;
        boolean clientReloginAllowedBeforeLogout = true;
        Subject subject = new Subject();
        LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
        MockTime mockTime = new MockTime();
        long startMs = mockTime.milliseconds();
        long lifetimeMinutes = 10L;
        long refreshEveryMinutes = 8L;
        long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
        int bufferIntrusionSeconds = 1;
        short minPeriodSeconds = (short)(refreshEveryMinutes * 60L + (long)bufferIntrusionSeconds);
        short bufferSeconds = 0;
        MockScheduler mockScheduler = new MockScheduler(mockTime);
        List<KafkaFutureImpl<Long>> waiters = ExpiringCredentialRefreshingLoginTest.addWaiters(mockScheduler, 1000L * (60L * refreshEveryMinutes + (long)bufferIntrusionSeconds), numExpectedRefreshes + 1);
        TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
        TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout);
        testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
        long expectedFinalMs = startMs + (long)(numExpectedRefreshes * 1000) * (60L * refreshEveryMinutes + (long)bufferIntrusionSeconds);
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
        testExpiringCredentialRefreshingLogin.login();
        Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedFinalMs, (long)mockTime.milliseconds());
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            KafkaFutureImpl<Long> waiter = waiters.get(i);
            Assert.assertTrue((boolean)waiter.isDone());
            Assert.assertEquals((long)((long)((i + 1) * 1000) * (60L * refreshEveryMinutes + (long)bufferIntrusionSeconds)), (long)((Long)waiter.get() - startMs));
        }
        Assert.assertFalse((boolean)waiters.get(numExpectedRefreshes).isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockLoginContext});
        ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
        }
    }

    @Test
    public void testRefreshWithPreExpirationBufferIntrusion() throws Exception {
        int numExpectedRefreshes = 1;
        boolean clientReloginAllowedBeforeLogout = true;
        Subject subject = new Subject();
        LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
        MockTime mockTime = new MockTime();
        long startMs = mockTime.milliseconds();
        long lifetimeMinutes = 10L;
        long refreshEveryMinutes = 8L;
        long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
        int bufferIntrusionSeconds = 1;
        short bufferSeconds = (short)((lifetimeMinutes - refreshEveryMinutes) * 60L + (long)bufferIntrusionSeconds);
        short minPeriodSeconds = 0;
        MockScheduler mockScheduler = new MockScheduler(mockTime);
        List<KafkaFutureImpl<Long>> waiters = ExpiringCredentialRefreshingLoginTest.addWaiters(mockScheduler, 1000L * (60L * refreshEveryMinutes - (long)bufferIntrusionSeconds), numExpectedRefreshes + 1);
        TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
        TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout);
        testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
        long expectedFinalMs = startMs + (long)(numExpectedRefreshes * 1000) * (60L * refreshEveryMinutes - (long)bufferIntrusionSeconds);
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
        testExpiringCredentialRefreshingLogin.login();
        Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedFinalMs, (long)mockTime.milliseconds());
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            KafkaFutureImpl<Long> waiter = waiters.get(i);
            Assert.assertTrue((boolean)waiter.isDone());
            Assert.assertEquals((long)((long)((i + 1) * 1000) * (60L * refreshEveryMinutes - (long)bufferIntrusionSeconds)), (long)((Long)waiter.get() - startMs));
        }
        Assert.assertFalse((boolean)waiters.get(numExpectedRefreshes).isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockLoginContext});
        ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
        for (int i = 0; i < numExpectedRefreshes; ++i) {
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).login();
            ((LoginContext)inOrder.verify((Object)mockLoginContext)).logout();
        }
    }

    @Test
    public void testLoginExceptionCausesCorrectLogout() throws Exception {
        short minPeriodSeconds;
        int numExpectedRefreshes = 3;
        boolean clientReloginAllowedBeforeLogout = true;
        Subject subject = new Subject();
        LoginContext mockLoginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)mockLoginContext.getSubject()).thenReturn((Object)subject);
        ((LoginContext)Mockito.doNothing().doThrow(new Throwable[]{new LoginException()}).doNothing().when((Object)mockLoginContext)).login();
        MockTime mockTime = new MockTime();
        long startMs = mockTime.milliseconds();
        long lifetimeMinutes = 100L;
        long refreshEveryMinutes = 80L;
        long absoluteLastRefreshMs = startMs + (long)((1 + numExpectedRefreshes) * 1000 * 60) * refreshEveryMinutes - 60000L * refreshEveryMinutes / 2L;
        short bufferSeconds = minPeriodSeconds = 0;
        TestLoginContextFactory testLoginContextFactory = new TestLoginContextFactory();
        TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin = new TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshingLoginTest.refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(1.0 * (double)refreshEveryMinutes / (double)lifetimeMinutes, minPeriodSeconds, bufferSeconds, clientReloginAllowedBeforeLogout), testLoginContextFactory, mockTime, 60000L * lifetimeMinutes, absoluteLastRefreshMs, clientReloginAllowedBeforeLogout);
        testLoginContextFactory.configure(mockLoginContext, testExpiringCredentialRefreshingLogin);
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        Assert.assertFalse((boolean)testLoginContextFactory.refresherThreadDoneFuture().isDone());
        testExpiringCredentialRefreshingLogin.login();
        Assert.assertTrue((boolean)testLoginContextFactory.refresherThreadStartedFuture().isDone());
        testLoginContextFactory.refresherThreadDoneFuture().get(1L, TimeUnit.SECONDS);
    }

    private static List<KafkaFutureImpl<Long>> addWaiters(MockScheduler mockScheduler, long refreshEveryMillis, int numWaiters) {
        ArrayList<KafkaFutureImpl<Long>> retvalWaiters = new ArrayList<KafkaFutureImpl<Long>>(numWaiters);
        for (int i = 1; i <= numWaiters; ++i) {
            KafkaFutureImpl waiter = new KafkaFutureImpl();
            mockScheduler.addWaiter((long)i * refreshEveryMillis, (KafkaFutureImpl<Long>)waiter);
            retvalWaiters.add((KafkaFutureImpl<Long>)waiter);
        }
        return retvalWaiters;
    }

    private static ExpiringCredentialRefreshConfig refreshConfigThatPerformsReloginEveryGivenPercentageOfLifetime(double refreshWindowFactor, short minPeriodSeconds, short bufferSeconds, boolean clientReloginAllowedBeforeLogout) {
        HashMap<String, Number> configs = new HashMap<String, Number>();
        configs.put("sasl.login.refresh.window.factor", refreshWindowFactor);
        configs.put("sasl.login.refresh.window.jitter", 0);
        configs.put("sasl.login.refresh.min.period.seconds", minPeriodSeconds);
        configs.put("sasl.login.refresh.buffer.seconds", bufferSeconds);
        return new ExpiringCredentialRefreshConfig(new ConfigDef().withClientSaslSupport().parse(configs), clientReloginAllowedBeforeLogout);
    }

    private static class TestLoginContextFactory
    extends ExpiringCredentialRefreshingLogin.LoginContextFactory {
        private final KafkaFutureImpl<Object> refresherThreadStartedFuture = new KafkaFutureImpl();
        private final KafkaFutureImpl<Object> refresherThreadDoneFuture = new KafkaFutureImpl();
        private TestLoginContext testLoginContext;

        private TestLoginContextFactory() {
        }

        public void configure(LoginContext mockLoginContext, TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin) throws LoginException {
            if (Objects.requireNonNull(mockLoginContext).getClass().equals(LoginContext.class) || mockLoginContext.getClass().equals(TestLoginContext.class)) {
                throw new IllegalArgumentException();
            }
            this.testLoginContext = new TestLoginContext(Objects.requireNonNull(testExpiringCredentialRefreshingLogin), mockLoginContext);
        }

        public LoginContext createLoginContext(ExpiringCredentialRefreshingLogin expiringCredentialRefreshingLogin) throws LoginException {
            return new LoginContext("", null, null, EMPTY_WILDCARD_CONFIGURATION){
                private boolean loginSuccess;
                {
                    super(x0, x1, x2, x3);
                    this.loginSuccess = false;
                }

                @Override
                public void login() throws LoginException {
                    testLoginContext.login();
                    this.loginSuccess = true;
                }

                @Override
                public void logout() throws LoginException {
                    if (!this.loginSuccess) {
                        throw new IllegalStateException("logout called without a successful login");
                    }
                    testLoginContext.logout();
                }

                @Override
                public Subject getSubject() {
                    return testLoginContext.getSubject();
                }
            };
        }

        public void refresherThreadStarted() {
            this.refresherThreadStartedFuture.complete(null);
        }

        public void refresherThreadDone() {
            this.refresherThreadDoneFuture.complete(null);
        }

        public Future<?> refresherThreadStartedFuture() {
            return this.refresherThreadStartedFuture;
        }

        public Future<?> refresherThreadDoneFuture() {
            return this.refresherThreadDoneFuture;
        }
    }

    private static class TestLoginContext
    extends LoginContext {
        private final TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin;
        private final LoginContext mockLoginContext;

        public TestLoginContext(TestExpiringCredentialRefreshingLogin testExpiringCredentialRefreshingLogin, LoginContext mockLoginContext) throws LoginException {
            super("contextName", null, null, EMPTY_WILDCARD_CONFIGURATION);
            this.testExpiringCredentialRefreshingLogin = Objects.requireNonNull(testExpiringCredentialRefreshingLogin);
            if (Objects.requireNonNull(mockLoginContext).getClass().equals(LoginContext.class) || mockLoginContext.getClass().equals(this.getClass())) {
                throw new IllegalArgumentException();
            }
            this.mockLoginContext = mockLoginContext;
        }

        @Override
        public void login() throws LoginException {
            this.mockLoginContext.login();
            this.testExpiringCredentialRefreshingLogin.createNewExpiringCredential();
        }

        @Override
        public void logout() throws LoginException {
            this.mockLoginContext.logout();
            this.testExpiringCredentialRefreshingLogin.clearExpiringCredential();
        }

        @Override
        public Subject getSubject() {
            return this.mockLoginContext.getSubject();
        }
    }

    private static class TestExpiringCredentialRefreshingLogin
    extends ExpiringCredentialRefreshingLogin {
        private ExpiringCredential expiringCredential;
        private ExpiringCredential tmpExpiringCredential;
        private final Time time;
        private final long lifetimeMillis;
        private final long absoluteLastRefreshTimeMs;
        private final boolean clientReloginAllowedBeforeLogout;

        public TestExpiringCredentialRefreshingLogin(ExpiringCredentialRefreshConfig refreshConfig, ExpiringCredentialRefreshingLogin.LoginContextFactory loginContextFactory, Time time, long lifetimeMillis, long absoluteLastRefreshMs, boolean clientReloginAllowedBeforeLogout) {
            super("contextName", EMPTY_WILDCARD_CONFIGURATION, refreshConfig, null, TestExpiringCredentialRefreshingLogin.class, loginContextFactory, Objects.requireNonNull(time));
            this.time = time;
            this.lifetimeMillis = lifetimeMillis;
            this.absoluteLastRefreshTimeMs = absoluteLastRefreshMs;
            this.clientReloginAllowedBeforeLogout = clientReloginAllowedBeforeLogout;
        }

        public long getCreateMs() {
            return this.time.milliseconds();
        }

        public long getExpireTimeMs() {
            return this.time.milliseconds() + this.lifetimeMillis;
        }

        public void createNewExpiringCredential() {
            if (!this.clientReloginAllowedBeforeLogout) {
                this.expiringCredential = this.internalNewExpiringCredential();
            } else {
                boolean initialLogin;
                boolean bl = initialLogin = this.expiringCredential == null;
                if (initialLogin) {
                    this.expiringCredential = this.internalNewExpiringCredential();
                } else {
                    this.tmpExpiringCredential = this.internalNewExpiringCredential();
                }
            }
        }

        public void clearExpiringCredential() {
            this.expiringCredential = !this.clientReloginAllowedBeforeLogout ? null : this.tmpExpiringCredential;
        }

        public ExpiringCredential expiringCredential() {
            return this.expiringCredential;
        }

        private ExpiringCredential internalNewExpiringCredential() {
            return new ExpiringCredential(){
                private final long createMs;
                private final long expireTimeMs;
                {
                    this.createMs = this.getCreateMs();
                    this.expireTimeMs = this.getExpireTimeMs();
                }

                public String principalName() {
                    return "Created at " + new Date(this.createMs);
                }

                public Long startTimeMs() {
                    return this.createMs;
                }

                public long expireTimeMs() {
                    return this.expireTimeMs;
                }

                public Long absoluteLastRefreshTimeMs() {
                    return absoluteLastRefreshTimeMs;
                }

                public String toString() {
                    return String.format("startTimeMs=%d, expireTimeMs=%d, absoluteLastRefreshTimeMs=%s", this.startTimeMs(), this.expireTimeMs(), this.absoluteLastRefreshTimeMs());
                }
            };
        }
    }
}

