/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;

public class JoinGroupResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private int generationId;
    private String protocolName;
    private String leader;
    private String memberId;
    private List<JoinGroupResponseMember> members;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public JoinGroupResponseData(Readable readable, short version) {
        this.members = new ArrayList<JoinGroupResponseMember>();
        this.read(readable, version);
    }

    public JoinGroupResponseData(Struct struct, short version) {
        this.members = new ArrayList<JoinGroupResponseMember>();
        this.fromStruct(struct, version);
    }

    public JoinGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.generationId = 0;
        this.protocolName = "";
        this.leader = "";
        this.memberId = "";
        this.members = new ArrayList<JoinGroupResponseMember>();
    }

    @Override
    public short apiKey() {
        return 11;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 2 ? readable.readInt() : 0;
        this.errorCode = readable.readShort();
        this.generationId = readable.readInt();
        this.protocolName = readable.readNullableString();
        this.leader = readable.readNullableString();
        this.memberId = readable.readNullableString();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.members = null;
        } else {
            this.members.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.members.add(new JoinGroupResponseMember(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 2) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeShort(this.errorCode);
        writable.writeInt(this.generationId);
        writable.writeString(this.protocolName);
        writable.writeString(this.leader);
        writable.writeString(this.memberId);
        writable.writeInt(this.members.size());
        for (JoinGroupResponseMember element : this.members) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        this.generationId = struct.getInt("generation_id");
        this.protocolName = struct.getString("protocol_name");
        this.leader = struct.getString("leader");
        this.memberId = struct.getString("member_id");
        Object[] nestedObjects = struct.getArray("members");
        this.members = new ArrayList<JoinGroupResponseMember>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.members.add(new JoinGroupResponseMember((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        struct.set("generation_id", (Object)this.generationId);
        struct.set("protocol_name", (Object)this.protocolName);
        struct.set("leader", (Object)this.leader);
        struct.set("member_id", (Object)this.memberId);
        Struct[] nestedObjects = new Struct[this.members.size()];
        int i = 0;
        for (JoinGroupResponseMember element : this.members) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("members", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 2) {
            size += 4;
        }
        size += 2;
        size += 4;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.protocolName);
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.leader);
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.memberId);
        size += 4;
        for (JoinGroupResponseMember element : this.members) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinGroupResponseData)) {
            return false;
        }
        JoinGroupResponseData other = (JoinGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.protocolName == null ? other.protocolName != null : !this.protocolName.equals(other.protocolName)) {
            return false;
        }
        if (this.leader == null ? other.leader != null : !this.leader.equals(other.leader)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.members == null ? other.members != null : !this.members.equals(other.members));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.protocolName == null ? 0 : this.protocolName.hashCode());
        hashCode = 31 * hashCode + (this.leader == null ? 0 : this.leader.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    public String toString() {
        return "JoinGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", generationId=" + this.generationId + ", protocolName='" + this.protocolName + "', leader='" + this.leader + "', memberId='" + this.memberId + "', members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int generationId() {
        return this.generationId;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public String leader() {
        return this.leader;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<JoinGroupResponseMember> members() {
        return this.members;
    }

    public JoinGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public JoinGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public JoinGroupResponseData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public JoinGroupResponseData setProtocolName(String v) {
        this.protocolName = v;
        return this;
    }

    public JoinGroupResponseData setLeader(String v) {
        this.leader = v;
        return this;
    }

    public JoinGroupResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public JoinGroupResponseData setMembers(List<JoinGroupResponseMember> v) {
        this.members = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.STRING, "The leader of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("members", new ArrayOf(JoinGroupResponseMember.SCHEMA_0), ""));
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.STRING, "The leader of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("members", new ArrayOf(JoinGroupResponseMember.SCHEMA_0), "")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class JoinGroupResponseMember
    implements Message {
        private String memberId;
        private byte[] metadata;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;

        public JoinGroupResponseMember(Readable readable, short version) {
            this.read(readable, version);
        }

        public JoinGroupResponseMember(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public JoinGroupResponseMember() {
            this.memberId = "";
            this.metadata = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable readable, short version) {
            this.memberId = readable.readNullableString();
            this.metadata = readable.readNullableBytes();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.memberId);
            writable.writeBytes(this.metadata);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.memberId = struct.getString("member_id");
            this.metadata = struct.getByteArray("metadata");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("member_id", (Object)this.memberId);
            struct.setByteArray("metadata", this.metadata);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.memberId);
            size += 4;
            return size += this.metadata.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JoinGroupResponseMember)) {
                return false;
            }
            JoinGroupResponseMember other = (JoinGroupResponseMember)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            return Arrays.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.metadata);
            return hashCode;
        }

        public String toString() {
            return "JoinGroupResponseMember(memberId='" + this.memberId + "', metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        public JoinGroupResponseMember setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public JoinGroupResponseMember setMetadata(byte[] v) {
            this.metadata = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("member_id", Type.STRING, "The group member ID."), new Field("metadata", Type.BYTES, "The group member metadata.")))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

