/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RequestHeaderTest {
    @Test
    public void testSerdeControlledShutdownV0() {
        int correlationId = 2342;
        ByteBuffer rawBuffer = ByteBuffer.allocate(32);
        rawBuffer.putShort(ApiKeys.CONTROLLED_SHUTDOWN.id);
        rawBuffer.putShort((short)0);
        rawBuffer.putInt(correlationId);
        rawBuffer.flip();
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)rawBuffer);
        Assert.assertEquals((Object)ApiKeys.CONTROLLED_SHUTDOWN, (Object)deserialized.apiKey());
        Assert.assertEquals((long)0L, (long)deserialized.apiVersion());
        Assert.assertEquals((long)correlationId, (long)deserialized.correlationId());
        Assert.assertEquals((Object)"", (Object)deserialized.clientId());
        Struct serialized = deserialized.toStruct();
        ByteBuffer serializedBuffer = TestUtils.toBuffer(serialized);
        Assert.assertEquals((long)ApiKeys.CONTROLLED_SHUTDOWN.id, (long)serializedBuffer.getShort(0));
        Assert.assertEquals((long)0L, (long)serializedBuffer.getShort(2));
        Assert.assertEquals((long)correlationId, (long)serializedBuffer.getInt(4));
        Assert.assertEquals((long)8L, (long)serializedBuffer.limit());
    }

    @Test
    public void testRequestHeader() {
        RequestHeader header = new RequestHeader(ApiKeys.FIND_COORDINATOR, 1, "", 10);
        ByteBuffer buffer = TestUtils.toBuffer(header.toStruct());
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((Object)header, (Object)deserialized);
    }

    @Test
    public void testRequestHeaderWithNullClientId() {
        RequestHeader header = new RequestHeader(ApiKeys.FIND_COORDINATOR, 1, null, 10);
        Struct headerStruct = header.toStruct();
        ByteBuffer buffer = TestUtils.toBuffer(headerStruct);
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((Object)header.apiKey(), (Object)deserialized.apiKey());
        Assert.assertEquals((long)header.apiVersion(), (long)deserialized.apiVersion());
        Assert.assertEquals((long)header.correlationId(), (long)deserialized.correlationId());
        Assert.assertEquals((Object)"", (Object)deserialized.clientId());
    }
}

