/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.Test;

public class ProducerRecordTest {
    @Test
    public void testEqualsAndHashCode() {
        ProducerRecord producerRecord = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)1);
        Assert.assertEquals((Object)producerRecord, (Object)producerRecord);
        Assert.assertEquals((long)producerRecord.hashCode(), (long)producerRecord.hashCode());
        ProducerRecord equalRecord = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)1);
        Assert.assertEquals((Object)producerRecord, (Object)equalRecord);
        Assert.assertEquals((long)producerRecord.hashCode(), (long)equalRecord.hashCode());
        ProducerRecord topicMisMatch = new ProducerRecord("test-1", Integer.valueOf(1), (Object)"key", (Object)1);
        Assert.assertFalse((boolean)producerRecord.equals((Object)topicMisMatch));
        ProducerRecord partitionMismatch = new ProducerRecord("test", Integer.valueOf(2), (Object)"key", (Object)1);
        Assert.assertFalse((boolean)producerRecord.equals((Object)partitionMismatch));
        ProducerRecord keyMisMatch = new ProducerRecord("test", Integer.valueOf(1), (Object)"key-1", (Object)1);
        Assert.assertFalse((boolean)producerRecord.equals((Object)keyMisMatch));
        ProducerRecord valueMisMatch = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)2);
        Assert.assertFalse((boolean)producerRecord.equals((Object)valueMisMatch));
        ProducerRecord nullFieldsRecord = new ProducerRecord("topic", null, null, null, null, null);
        Assert.assertEquals((Object)nullFieldsRecord, (Object)nullFieldsRecord);
        Assert.assertEquals((long)nullFieldsRecord.hashCode(), (long)nullFieldsRecord.hashCode());
    }

    @Test
    public void testInvalidRecords() {
        try {
            new ProducerRecord(null, Integer.valueOf(0), (Object)"key", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException to be raised because topic is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ProducerRecord("test", Integer.valueOf(0), Long.valueOf(-1L), (Object)"key", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException to be raised because of negative timestamp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ProducerRecord("test", Integer.valueOf(-1), (Object)"key", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException to be raised because of negative partition");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

