/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class InitProducerIdRequestData
implements ApiMessage {
    private String transactionalId;
    private int transactionTimeoutMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public InitProducerIdRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public InitProducerIdRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public InitProducerIdRequestData() {
        this.transactionalId = "";
        this.transactionTimeoutMs = 0;
    }

    public short apiKey() {
        return 22;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.transactionalId = readable.readNullableString();
        this.transactionTimeoutMs = readable.readInt();
    }

    public void write(Writable writable, short version) {
        writable.writeNullableString(this.transactionalId);
        writable.writeInt(this.transactionTimeoutMs);
    }

    public void fromStruct(Struct struct, short version) {
        this.transactionalId = struct.getString("transactional_id");
        this.transactionTimeoutMs = struct.getInt("transaction_timeout_ms");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("transaction_timeout_ms", (Object)this.transactionTimeoutMs);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 2;
        if (this.transactionalId != null) {
            size += MessageUtil.serializedUtf8Length((CharSequence)this.transactionalId);
        }
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitProducerIdRequestData)) {
            return false;
        }
        InitProducerIdRequestData other = (InitProducerIdRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        return this.transactionTimeoutMs == other.transactionTimeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + this.transactionTimeoutMs;
        return hashCode;
    }

    public String toString() {
        return "InitProducerIdRequestData(transactionalId='" + this.transactionalId + "', transactionTimeoutMs=" + this.transactionTimeoutMs + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public InitProducerIdRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public InitProducerIdRequestData setTransactionTimeoutMs(int v) {
        this.transactionTimeoutMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.NULLABLE_STRING, "The transactional id, or null if the producer is not transactional."), new Field("transaction_timeout_ms", (Type)Type.INT32, "The time in ms to wait for before aborting idle transactions sent by this producer. This is only relevant if a TransactionalId has been defined.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

