/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class SaslChannelBuilderTest {
    @Test
    public void testCloseBeforeConfigureIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testCloseAfterConfigIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.configure(new HashMap());
        Assert.assertNotNull(builder.loginManagers().get("PLAIN"));
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testLoginManagerReleasedIfConfigureThrowsException() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_SSL);
        try {
            builder.configure(Collections.singletonMap("ssl.enabled.protocols", "1"));
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (KafkaException e) {
            Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        }
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    private SaslChannelBuilder createChannelBuilder(SecurityProtocol securityProtocol) {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("PLAIN", jaasContext);
        return new SaslChannelBuilder(Mode.CLIENT, jaasContexts, securityProtocol, new ListenerName("PLAIN"), false, "PLAIN", true, null, null, Time.SYSTEM);
    }
}

