/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public final class MessageTest {
    private final String memberId = "memberId";
    private final String instanceId = "instanceId";
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testAddOffsetsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnRequestData().setTransactionalId("foobar").setProducerId(52596993799604990L).setProducerEpoch((short)123).setGroupId("baaz"));
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnResponseData().setThrottleTimeMs(42).setErrorCode((short)0));
    }

    @Test
    public void testAddPartitionsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddPartitionsToTxnRequestData().setTransactionalId("blah").setProducerId(52596993799604990L).setProducerEpoch((short)30000).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("Topic").setPartitions(Collections.singletonList(1))).iterator())));
    }

    @Test
    public void testCreateTopicsVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new CreateTopicsRequestData().setTimeoutMs(1000).setTopics(new CreateTopicsRequestData.CreatableTopicCollection()));
    }

    @Test
    public void testDescribeAclsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeAclsRequestData().setResourceType((byte)42).setResourceNameFilter(null).setResourcePatternType((byte)3).setPrincipalFilter("abc").setHostFilter(null).setOperation((byte)0).setPermissionType((byte)0));
    }

    @Test
    public void testMetadataVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new MetadataRequestData().setTopics(Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName("foo"), new MetadataRequestData.MetadataRequestTopic().setName("bar"))));
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(false).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
    }

    @Test
    public void testHeartbeatVersions() throws Exception {
        Supplier<HeartbeatRequestData> newRequest = () -> new HeartbeatRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupRequestVersions() throws Exception {
        Supplier<JoinGroupRequestData> newRequest = () -> new JoinGroupRequestData().setGroupId("groupId").setMemberId("memberId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection()).setSessionTimeoutMs(10000);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newRequest.get().setRebalanceTimeoutMs(20000));
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupResponseVersions() throws Exception {
        Supplier<JoinGroupResponseData> newResponse = () -> new JoinGroupResponseData().setMemberId("memberId").setLeader("memberId").setGenerationId(1).setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId")));
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTrips(newResponse.get().members().get(0).setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, newResponse.get().members().get(0).setGroupInstanceId("instanceId"));
    }

    @Test
    public void testLeaveGroupResponseVersions() throws Exception {
        Supplier<LeaveGroupResponseData> newResponse = () -> new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code());
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newResponse.get().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setMemberId("memberId").setGroupInstanceId("instanceId"))));
    }

    @Test
    public void testSyncGroupDefaultGroupInstanceId() throws Exception {
        Supplier<SyncGroupRequestData> request = () -> new SyncGroupRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15).setAssignments(new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>());
        this.testAllMessageRoundTrips((Message)request.get());
        this.testAllMessageRoundTrips((Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetCommitDefaultGroupInstanceId() throws Exception {
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>()).setGroupId("groupId"));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>()).setGenerationId(15);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)7, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetForLeaderEpochVersions() throws Exception {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataNoCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartitionIndex(0).setLeaderEpoch(3);
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataWithCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartitionIndex(0).setLeaderEpoch(3).setCurrentLeaderEpoch(5);
        this.testAllMessageRoundTrips((Message)new OffsetForLeaderEpochRequestData().setTopics(Collections.singletonList(new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setName("foo").setPartitions(Collections.singletonList(partitionDataNoCurrentEpoch)))));
        this.testAllMessageRoundTripsBeforeVersion((short)2, partitionDataWithCurrentEpoch, partitionDataNoCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)2, partitionDataWithCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5));
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData());
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData().setReplicaId(-2));
    }

    @Test
    public void testLeaderAndIsrVersions() throws Exception {
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateNoAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0))));
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateWithAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0)).setAddingReplicas(Collections.singletonList(1)).setRemovingReplicas(Collections.singletonList(1))));
        this.testAllMessageRoundTripsBetweenVersions((short)2, (short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)), (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateNoAddingRemovingReplicas)));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)));
    }

    @Test
    public void testOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset(offset))))));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId(groupId).setMemberId("memberId").setGroupInstanceId("instanceId").setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset(offset).setCommitTimestamp(20L))))).setRetentionTimeMs(20L);
        for (short version = 0; version <= ApiKeys.OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            OffsetCommitRequestData requestData = request.get();
            if (version < 1) {
                requestData.setMemberId("");
                requestData.setGenerationId(-1);
            }
            if (version != 1) {
                requestData.topics().get(0).partitions().get(0).setCommitTimestamp(-1L);
            }
            if (version < 2 || version > 4) {
                requestData.setRetentionTimeMs(-1L);
            }
            if (version < 6) {
                requestData.topics().get(0).partitions().get(0).setCommittedLeaderEpoch(-1);
            }
            if (version < 7) {
                requestData.setGroupInstanceId(null);
            }
            if (version == 1) {
                this.testEquivalentMessageRoundTrip(version, (Message)requestData);
                continue;
            }
            if (version >= 2 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)4, (Message)requestData, (Message)requestData);
                continue;
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testOffsetCommitResponseVersions() throws Exception {
        Supplier<OffsetCommitResponseData> response = () -> new OffsetCommitResponseData().setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20);
        for (short version = 0; version <= ApiKeys.OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            OffsetCommitResponseData responseData = response.get();
            if (version < 3) {
                responseData.setThrottleTimeMs(0);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)responseData);
        }
    }

    @Test
    public void testTxnOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        String txnId = "transactionalId";
        int producerId = 25;
        short producerEpoch = 10;
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset(offset))))));
        Supplier<TxnOffsetCommitRequestData> request = () -> new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset(offset)))));
        for (short version = 0; version <= ApiKeys.TXN_OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            TxnOffsetCommitRequestData requestData = request.get();
            if (version < 6) {
                requestData.topics().get(0).partitions().get(0).setCommittedLeaderEpoch(-1);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testTxnOffsetCommitResponseVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20));
    }

    @Test
    public void testOffsetFetchVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        this.testAllMessageRoundTrips((Message)new OffsetFetchRequestData().setTopics(new ArrayList<OffsetFetchRequestData.OffsetFetchRequestTopic>()).setGroupId(groupId));
        this.testAllMessageRoundTrips((Message)new OffsetFetchRequestData().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(topicName).setPartitionIndexes(Collections.singletonList(5)))));
        OffsetFetchRequestData allPartitionData = new OffsetFetchRequestData().setGroupId(groupId).setTopics(null);
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            if (version < 2) {
                short finalVersion = version;
                Assert.assertThrows(SchemaException.class, () -> this.testAllMessageRoundTripsFromVersion(finalVersion, (Message)allPartitionData));
                continue;
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)allPartitionData);
        }
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))).setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            OffsetFetchResponseData responseData = response.get();
            if (version <= 1) {
                responseData.setErrorCode(Errors.NONE.code());
            }
            if (version <= 2) {
                responseData.setThrottleTimeMs(0);
            }
            if (version <= 4) {
                responseData.topics().get(0).partitions().get(0).setCommittedLeaderEpoch(-1);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)responseData);
        }
    }

    @Test
    public void testProduceResponseVersions() throws Exception {
        String topicName = "topic";
        int partitionIndex = 0;
        short errorCode = Errors.INVALID_TOPIC_EXCEPTION.code();
        long baseOffset = 12L;
        int throttleTimeMs = 1234;
        long logAppendTimeMs = 1234L;
        long logStartOffset = 1234L;
        int batchIndex = 0;
        String batchIndexErrorMessage = "error message";
        String errorMessage = "global error message";
        this.testAllMessageRoundTrips((Message)new ProduceResponseData().setResponses(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitions(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setPartitionIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset))))));
        Supplier<ProduceResponseData> response = () -> new ProduceResponseData().setResponses(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitions(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setPartitionIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset).setLogAppendTimeMs(logAppendTimeMs).setLogStartOffset(logStartOffset).setRecordErrors(Collections.singletonList(new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(batchIndex).setBatchIndexErrorMessage(batchIndexErrorMessage))).setErrorMessage(errorMessage))))).setThrottleTimeMs(throttleTimeMs);
        for (short version = 0; version <= ApiKeys.PRODUCE.latestVersion(); version = (short)(version + 1)) {
            ProduceResponseData responseData = response.get();
            if (version < 8) {
                responseData.responses().get(0).partitions().get(0).setRecordErrors(Collections.emptyList());
                responseData.responses().get(0).partitions().get(0).setErrorMessage(null);
            }
            if (version < 5) {
                responseData.responses().get(0).partitions().get(0).setLogStartOffset(-1L);
            }
            if (version < 2) {
                responseData.responses().get(0).partitions().get(0).setLogAppendTimeMs(-1L);
            }
            if (version < 1) {
                responseData.setThrottleTimeMs(0);
            }
            if (version >= 3 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)4, (Message)responseData, (Message)responseData);
                continue;
            }
            if (version >= 6 && version <= 7) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)7, (Message)responseData, (Message)responseData);
                continue;
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    private void testAllMessageRoundTrips(Message message) throws Exception {
        this.testAllMessageRoundTripsFromVersion(message.lowestSupportedVersion(), message);
    }

    private void testAllMessageRoundTripsBeforeVersion(short beforeVersion, Message message, Message expected) throws Exception {
        this.testAllMessageRoundTripsBetweenVersions((short)0, beforeVersion, message, expected);
    }

    private void testAllMessageRoundTripsBetweenVersions(short startVersion, short endVersion, Message message, Message expected) throws Exception {
        for (short version = startVersion; version < endVersion; version = (short)(version + 1)) {
            this.testMessageRoundTrip(version, message, expected);
        }
    }

    private void testAllMessageRoundTripsFromVersion(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version < message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testMessageRoundTrip(short version, Message message, Message expected) throws Exception {
        this.testByteBufferRoundTrip(version, message, expected);
        this.testStructRoundTrip(version, message, expected);
    }

    private void testEquivalentMessageRoundTrip(short version, Message message) throws Exception {
        this.testStructRoundTrip(version, message, message);
        this.testByteBufferRoundTrip(version, message, message);
    }

    private void testByteBufferRoundTrip(short version, Message message, Message expected) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assert.assertEquals((String)("The result of the size function does not match the number of bytes written for version " + version), (long)size, (long)buf.position());
        Message message2 = (Message)message.getClass().newInstance();
        buf.flip();
        message2.read((Readable)byteBufferAccessor, version);
        Assert.assertEquals((String)("The result of the size function does not match the number of bytes read back in for version " + version), (long)size, (long)buf.position());
        Assert.assertEquals((String)("The message object created after a round trip did not match for version " + version), (Object)expected, (Object)message2);
        Assert.assertEquals((long)expected.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private void testStructRoundTrip(short version, Message message, Message expected) throws Exception {
        Struct struct = message.toStruct(version);
        Message message2 = (Message)message.getClass().newInstance();
        message2.fromStruct(struct, version);
        Assert.assertEquals((Object)expected, (Object)message2);
        Assert.assertEquals((long)expected.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    @Test
    public void testMessageVersions() throws Exception {
        for (ApiKeys apiKey : ApiKeys.values()) {
            ApiMessage message = null;
            try {
                message = ApiMessageType.fromApiKey(apiKey.id).newRequest();
            }
            catch (UnsupportedVersionException e) {
                Assert.fail((String)("No request message spec found for API " + apiKey));
            }
            Assert.assertTrue((String)("Request message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()), (apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0);
            try {
                message = ApiMessageType.fromApiKey(apiKey.id).newResponse();
            }
            catch (UnsupportedVersionException e) {
                Assert.fail((String)("No response message spec found for API " + apiKey));
            }
            Assert.assertTrue((String)("Response message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()), (apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRequestSchemas() throws Exception {
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema[] manualSchemas = apiKey.requestSchemas;
            Schema[] generatedSchemas = ApiMessageType.fromApiKey(apiKey.id).requestSchemas();
            Assert.assertEquals((String)("Mismatching request SCHEMAS lengths for api key " + apiKey), (long)manualSchemas.length, (long)generatedSchemas.length);
            for (int v = 0; v < manualSchemas.length; ++v) {
                try {
                    if (generatedSchemas[v] == null) continue;
                    MessageTest.compareTypes(manualSchemas[v], generatedSchemas[v]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to compare request schemas for version " + v + " of " + apiKey, e);
                }
            }
        }
    }

    @Test
    public void testResponseSchemas() {
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema[] manualSchemas = apiKey.responseSchemas;
            Schema[] generatedSchemas = ApiMessageType.fromApiKey(apiKey.id).responseSchemas();
            Assert.assertEquals((String)("Mismatching response SCHEMAS lengths for api key " + apiKey), (long)manualSchemas.length, (long)generatedSchemas.length);
            for (int v = 0; v < manualSchemas.length; ++v) {
                try {
                    if (generatedSchemas[v] == null) continue;
                    MessageTest.compareTypes(manualSchemas[v], generatedSchemas[v]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to compare response schemas for version " + v + " of " + apiKey, e);
                }
            }
        }
    }

    private static void compareTypes(Schema schemaA, Schema schemaB) {
        MessageTest.compareTypes(new NamedType("schemaA", (Type)schemaA), new NamedType("schemaB", (Type)schemaB));
    }

    private static void compareTypes(NamedType typeA, NamedType typeB) {
        List<NamedType> listA = MessageTest.flatten(typeA);
        List<NamedType> listB = MessageTest.flatten(typeB);
        if (listA.size() != listB.size()) {
            throw new RuntimeException("Can't match up structures: typeA has " + Utils.join(listA, (String)", ") + ", but typeB has " + Utils.join(listB, (String)", "));
        }
        for (int i = 0; i < listA.size(); ++i) {
            NamedType entryB;
            NamedType entryA = listA.get(i);
            if (!entryA.hasSimilarType(entryB = listB.get(i))) {
                throw new RuntimeException("Type " + entryA + " in schema A does not match type " + entryB + " in schema B.");
            }
            if (entryA.type.isNullable() != entryB.type.isNullable()) {
                throw new RuntimeException(String.format("Type %s in Schema A is %s, but type %s in Schema B is %s", entryA, entryA.type.isNullable() ? "nullable" : "non-nullable", entryB, entryB.type.isNullable() ? "nullable" : "non-nullable"));
            }
            if (!entryA.type.isArray()) continue;
            MessageTest.compareTypes(new NamedType(entryA.name, (Type)entryA.type.arrayElementType().get()), new NamedType(entryB.name, (Type)entryB.type.arrayElementType().get()));
        }
    }

    private static List<NamedType> flatten(NamedType type) {
        if (!(type.type instanceof Schema)) {
            return Collections.singletonList(type);
        }
        Schema schema = (Schema)type.type;
        ArrayList<NamedType> results = new ArrayList<NamedType>();
        for (BoundField field : schema.fields()) {
            results.addAll(MessageTest.flatten(new NamedType(field.def.name, field.def.type)));
        }
        return results;
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.verifyWriteRaisesUve((short)0, "validateOnly", (Message)new CreateTopicsRequestData().setValidateOnly(true));
        this.verifyWriteSucceeds((short)0, (Message)new CreateTopicsRequestData().setValidateOnly(false));
        this.verifyWriteSucceeds((short)0, (Message)new OffsetCommitRequestData().setRetentionTimeMs(123L));
        this.verifyWriteRaisesUve((short)5, "forgotten", (Message)new FetchRequestData().setForgotten(Collections.singletonList(new FetchRequestData.ForgottenTopic().setName("foo"))));
    }

    @Test
    public void testNonIgnorableFieldWithDefaultNull() throws Exception {
        this.verifyWriteRaisesUve((short)0, "groupInstanceId", (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId("instanceId"));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId(null));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId"));
    }

    @Test
    public void testWriteNullForNonNullableFieldRaisesException() throws Exception {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData().setTopics(null);
        for (short i = 0; i <= createTopics.highestSupportedVersion(); i = (short)(i + 1)) {
            this.verifyWriteRaisesNpe(i, (Message)createTopics);
        }
        MetadataRequestData metadata = new MetadataRequestData().setTopics(null);
        this.verifyWriteRaisesNpe((short)0, (Message)metadata);
    }

    @Test
    public void testUnknownTaggedFields() throws Exception {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
        RawTaggedField field1000 = new RawTaggedField(1000, new byte[]{1, 2, 3});
        createTopics.unknownTaggedFields().add(field1000);
        this.verifyWriteRaisesUve((short)0, "Tagged fields were set", (Message)createTopics);
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
    }

    private void verifyWriteRaisesNpe(short version, Message message) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        Assert.assertThrows(NullPointerException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
    }

    private void verifyWriteRaisesUve(short version, String problemText, Message message) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        UnsupportedVersionException e = (UnsupportedVersionException)Assert.assertThrows(UnsupportedVersionException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
        Assert.assertTrue((String)("Expected to get an error message about " + problemText + ", but got: " + e.getMessage()), (boolean)e.getMessage().contains(problemText));
    }

    private void verifyWriteSucceeds(short version, Message message) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size * 2);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        ByteBuffer alt = buf.duplicate();
        alt.flip();
        StringBuilder bld = new StringBuilder();
        while (alt.hasRemaining()) {
            bld.append(String.format(" %02x", alt.get()));
        }
        Assert.assertEquals((String)("Expected the serialized size to be " + size + ", but it was " + buf.position()), (long)size, (long)buf.position());
    }

    private static class NamedType {
        final String name;
        final Type type;

        NamedType(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        boolean hasSimilarType(NamedType other) {
            if (this.type.getClass().equals(other.type.getClass())) {
                return true;
            }
            return this.type.getClass().equals(Type.RECORDS.getClass()) ? other.type.getClass().equals(Type.NULLABLE_BYTES.getClass()) : this.type.getClass().equals(Type.NULLABLE_BYTES.getClass()) && other.type.getClass().equals(Type.RECORDS.getClass());
        }

        public String toString() {
            return this.name + "[" + this.type + "]";
        }
    }
}

