/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ApiVersionsResponseTest {
    @Test
    public void shouldCreateApiResponseOnlyWithKeysSupportedByMagicValue() {
        ApiVersionsResponse response = ApiVersionsResponse.apiVersionsResponse((int)10, (byte)1);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assert.assertEquals((long)10L, (long)response.throttleTimeMs());
    }

    @Test
    public void shouldCreateApiResponseThatHasAllApiKeysSupportedByBroker() {
        Assert.assertEquals(this.apiKeysInResponse(ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE), (Object)Utils.mkSet((Object[])ApiKeys.values()));
    }

    @Test
    public void shouldReturnAllKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = ApiVersionsResponse.apiVersionsResponse((int)0, (byte)2);
        Assert.assertEquals((Object)Utils.mkSet((Object[])ApiKeys.values()), this.apiKeysInResponse(response));
        Assert.assertEquals((long)0L, (long)response.throttleTimeMs());
    }

    @Test
    public void shouldHaveCorrectDefaultApiVersionsResponse() {
        ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiVersions = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.data.apiKeys();
        Assert.assertEquals((String)"API versions for all API keys must be maintained.", (long)apiVersions.size(), (long)ApiKeys.values().length);
        for (ApiKeys key : ApiKeys.values()) {
            int i;
            ApiVersionsResponseData.ApiVersionsResponseKey version = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.apiVersion(key.id);
            Assert.assertNotNull((String)("Could not find ApiVersion for API " + key.name), (Object)version);
            Assert.assertEquals((String)("Incorrect min version for Api " + key.name), (long)version.minVersion(), (long)key.oldestVersion());
            Assert.assertEquals((String)("Incorrect max version for Api " + key.name), (long)version.maxVersion(), (long)key.latestVersion());
            for (i = 0; i < version.minVersion(); ++i) {
                Assert.assertNull((String)("Request version " + i + " for API " + version.apiKey() + " must be null"), (Object)key.requestSchemas[i]);
                Assert.assertNull((String)("Response version " + i + " for API " + version.apiKey() + " must be null"), (Object)key.responseSchemas[i]);
            }
            for (i = version.minVersion(); i <= version.maxVersion(); ++i) {
                Assert.assertNotNull((String)("Request version " + i + " for API " + version.apiKey() + " must not be null"), (Object)key.requestSchemas[i]);
                Assert.assertNotNull((String)("Response version " + i + " for API " + version.apiKey() + " must not be null"), (Object)key.responseSchemas[i]);
            }
        }
    }

    private void verifyApiKeysForMagic(ApiVersionsResponse response, byte maxMagic) {
        Iterator iterator = response.data.apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersionsResponseKey version = (ApiVersionsResponseData.ApiVersionsResponseKey)iterator.next();
            Assert.assertTrue((ApiKeys.forId((int)version.apiKey()).minRequiredInterBrokerMagic <= maxMagic ? 1 : 0) != 0);
        }
    }

    private Set<ApiKeys> apiKeysInResponse(ApiVersionsResponse apiVersions) {
        HashSet<ApiKeys> apiKeys = new HashSet<ApiKeys>();
        Iterator iterator = apiVersions.data.apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersionsResponseKey version = (ApiVersionsResponseData.ApiVersionsResponseKey)iterator.next();
            apiKeys.add(ApiKeys.forId((int)version.apiKey()));
        }
        return apiKeys;
    }
}

