/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageTestUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class LeaderAndIsrRequestTest {
    @Test
    public void testUnsupportedVersion() {
        LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder((short)(ApiKeys.LEADER_AND_ISR.latestVersion() + 1), 0, 0, 0L, Collections.emptyList(), Collections.emptySet());
        Assert.assertThrows(UnsupportedVersionException.class, () -> ((LeaderAndIsrRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = ApiKeys.LEADER_AND_ISR.oldestVersion(); version < ApiKeys.LEADER_AND_ISR.latestVersion(); version = (short)(version + 1)) {
            LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder(version, 0, 0, 0L, Collections.emptyList(), Collections.emptySet());
            LeaderAndIsrRequest request = (LeaderAndIsrRequest)builder.build();
            LeaderAndIsrResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }

    @Test
    public void testVersionLogic() {
        for (short version = ApiKeys.LEADER_AND_ISR.oldestVersion(); version <= ApiKeys.LEADER_AND_ISR.latestVersion(); version = (short)(version + 1)) {
            List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = Arrays.asList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic0").setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setAddingReplicas(Arrays.asList(3)).setRemovingReplicas(Arrays.asList(2)), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic0").setPartitionIndex(1).setControllerEpoch(2).setLeader(1).setLeaderEpoch(11).setIsr(Arrays.asList(1, 2, 3)).setZkVersion(11).setReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(2).setLeader(2).setLeaderEpoch(11).setIsr(Arrays.asList(2, 3, 4)).setZkVersion(11).setReplicas(Arrays.asList(2, 3, 4)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()));
            List<Node> liveNodes = Arrays.asList(new Node(0, "host0", 9090), new Node(1, "host1", 9091));
            LeaderAndIsrRequest request = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(version, 1, 2, 3L, partitionStates, liveNodes).build();
            List liveLeaders = liveNodes.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            Assert.assertEquals(new HashSet<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>(partitionStates), this.iterableToSet(request.partitionStates()));
            Assert.assertEquals(liveLeaders, (Object)request.liveLeaders());
            Assert.assertEquals((long)1L, (long)request.controllerId());
            Assert.assertEquals((long)2L, (long)request.controllerEpoch());
            Assert.assertEquals((long)3L, (long)request.brokerEpoch());
            ByteBuffer byteBuffer = MessageTestUtil.messageToByteBuffer((Message)request.data(), request.version());
            LeaderAndIsrRequest deserializedRequest = new LeaderAndIsrRequest(new LeaderAndIsrRequestData((Readable)new ByteBufferAccessor(byteBuffer), version), version);
            if (version < 3) {
                partitionStates.get(0).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList());
            }
            Assert.assertEquals(new HashSet<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>(partitionStates), this.iterableToSet(deserializedRequest.partitionStates()));
            Assert.assertEquals(liveLeaders, (Object)deserializedRequest.liveLeaders());
            Assert.assertEquals((long)1L, (long)request.controllerId());
            Assert.assertEquals((long)2L, (long)request.controllerEpoch());
            Assert.assertEquals((long)3L, (long)request.brokerEpoch());
        }
    }

    @Test
    public void testTopicPartitionGroupingSizeReduction() {
        Set<TopicPartition> tps = TestUtils.generateRandomTopicPartitions(10, 10);
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()));
        }
        LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder(2, 0, 0, 0L, partitionStates, Collections.emptySet());
        LeaderAndIsrRequest v2 = builder.build((short)2);
        LeaderAndIsrRequest v1 = builder.build((short)1);
        int size2 = MessageTestUtil.messageSize((Message)v2.data(), v2.version());
        int size1 = MessageTestUtil.messageSize((Message)v1.data(), v1.version());
        Assert.assertTrue((String)("Expected v2 < v1: v2=" + size2 + ", v1=" + size1), (size2 < size1 ? 1 : 0) != 0);
    }

    private <T> Set<T> iterableToSet(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }
}

