/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetCommitResponseTest {
    protected final int throttleTimeMs = 10;
    protected final String topicOne = "topic1";
    protected final int partitionOne = 1;
    protected final Errors errorOne = Errors.COORDINATOR_NOT_AVAILABLE;
    protected final Errors errorTwo = Errors.NOT_COORDINATOR;
    protected final String topicTwo = "topic2";
    protected final int partitionTwo = 2;
    protected TopicPartition tp1 = new TopicPartition("topic1", 1);
    protected TopicPartition tp2 = new TopicPartition("topic2", 2);
    protected Map<Errors, Integer> expectedErrorCounts;
    protected Map<TopicPartition, Errors> errorsMap;

    @Before
    public void setUp() {
        this.expectedErrorCounts = new HashMap<Errors, Integer>();
        this.expectedErrorCounts.put(this.errorOne, 1);
        this.expectedErrorCounts.put(this.errorTwo, 1);
        this.errorsMap = new HashMap<TopicPartition, Errors>();
        this.errorsMap.put(this.tp1, this.errorOne);
        this.errorsMap.put(this.tp2, this.errorTwo);
    }

    @Test
    public void testConstructorWithErrorResponse() {
        OffsetCommitResponse response = new OffsetCommitResponse(10, this.errorsMap);
        Assert.assertEquals(this.expectedErrorCounts, (Object)response.errorCounts());
        Assert.assertEquals((long)10L, (long)response.throttleTimeMs());
    }

    @Test
    public void testConstructorWithStruct() {
        OffsetCommitResponseData data = new OffsetCommitResponseData().setTopics(Arrays.asList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(this.errorOne.code()))), new OffsetCommitResponseData.OffsetCommitResponseTopic().setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(2).setErrorCode(this.errorTwo.code()))))).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            OffsetCommitResponse response = new OffsetCommitResponse(data.toStruct(version), version);
            Assert.assertEquals(this.expectedErrorCounts, (Object)response.errorCounts());
            if (version >= 3) {
                Assert.assertEquals((long)10L, (long)response.throttleTimeMs());
            } else {
                Assert.assertEquals((long)0L, (long)response.throttleTimeMs());
            }
            Assert.assertEquals((Object)(version >= 4 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

