/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.TimeTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class MockTimeTest
extends TimeTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testAdvanceClock() {
        MockTime time = new MockTime(0L, 100L, 200L);
        Assert.assertEquals((long)100L, (long)time.milliseconds());
        Assert.assertEquals((long)200L, (long)time.nanoseconds());
        time.sleep(1L);
        Assert.assertEquals((long)101L, (long)time.milliseconds());
        Assert.assertEquals((long)1000200L, (long)time.nanoseconds());
    }

    @Test
    public void testAutoTickMs() {
        MockTime time = new MockTime(1L, 100L, 200L);
        Assert.assertEquals((long)101L, (long)time.milliseconds());
        Assert.assertEquals((long)2000200L, (long)time.nanoseconds());
        Assert.assertEquals((long)103L, (long)time.milliseconds());
        Assert.assertEquals((long)104L, (long)time.milliseconds());
    }

    @Override
    protected Time createTime() {
        return new MockTime();
    }
}

