/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class FetchRequestData
implements ApiMessage {
    private int replicaId;
    private int maxWait;
    private int minBytes;
    private int maxBytes;
    private byte isolationLevel;
    private int sessionId;
    private int epoch;
    private List<FetchableTopic> topics;
    private List<ForgottenTopic> forgotten;
    private String rackId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema[] SCHEMAS;

    public FetchRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FetchRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public FetchRequestData() {
        this.replicaId = 0;
        this.maxWait = 0;
        this.minBytes = 0;
        this.maxBytes = Integer.MAX_VALUE;
        this.isolationLevel = 0;
        this.sessionId = 0;
        this.epoch = -1;
        this.topics = new ArrayList<FetchableTopic>();
        this.forgotten = new ArrayList<ForgottenTopic>();
        this.rackId = "";
    }

    @Override
    public short apiKey() {
        return 1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 11;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        this.replicaId = _readable.readInt();
        this.maxWait = _readable.readInt();
        this.minBytes = _readable.readInt();
        this.maxBytes = _version >= 3 ? _readable.readInt() : Integer.MAX_VALUE;
        this.isolationLevel = _version >= 4 ? _readable.readByte() : (byte)0;
        this.sessionId = _version >= 7 ? _readable.readInt() : 0;
        this.epoch = _version >= 7 ? _readable.readInt() : -1;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<FetchableTopic> newCollection = new ArrayList<FetchableTopic>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new FetchableTopic(_readable, _version));
        }
        this.topics = newCollection;
        if (_version >= 7) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field forgotten was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((FetchableTopic)((Object)new ForgottenTopic(_readable, _version)));
            }
            this.forgotten = newCollection;
        } else {
            this.forgotten = new ArrayList<ForgottenTopic>();
        }
        if (_version >= 11) {
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field rackId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        } else {
            this.rackId = "";
        }
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        RawTaggedFieldWriter _rawWriter;
        int _numTaggedFields = 0;
        _writable.writeInt(this.replicaId);
        _writable.writeInt(this.maxWait);
        _writable.writeInt(this.minBytes);
        if (_version >= 3) {
            _writable.writeInt(this.maxBytes);
        }
        if (_version >= 4) {
            _writable.writeByte(this.isolationLevel);
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.sessionId);
        } else if (this.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.epoch);
        } else if (this.epoch != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default epoch at version " + _version);
        }
        _writable.writeInt(this.topics.size());
        for (FetchableTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.forgotten.size());
            for (ForgottenTopic forgottenElement : this.forgotten) {
                forgottenElement.write(_writable, _cache, _version);
            }
        } else if (!this.forgotten.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default forgotten at version " + _version);
        }
        if (_version >= 11) {
            byte[] _stringBytes = _cache.getSerializedValue(this.rackId);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.replicaId = struct.getInt("replica_id");
        this.maxWait = struct.getInt("max_wait");
        this.minBytes = struct.getInt("min_bytes");
        this.maxBytes = _version >= 3 ? struct.getInt("max_bytes") : Integer.MAX_VALUE;
        this.isolationLevel = _version >= 4 ? struct.getByte("isolation_level") : (byte)0;
        this.sessionId = _version >= 7 ? struct.getInt("session_id") : 0;
        this.epoch = _version >= 7 ? struct.getInt("epoch") : -1;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<FetchableTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new FetchableTopic((Struct)nestedObject, _version));
        }
        if (_version >= 7) {
            _nestedObjects = struct.getArray("forgotten");
            this.forgotten = new ArrayList<ForgottenTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.forgotten.add(new ForgottenTopic((Struct)nestedObject, _version));
            }
        } else {
            this.forgotten = new ArrayList<ForgottenTopic>();
        }
        this.rackId = _version >= 11 ? struct.getString("rack_id") : "";
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("replica_id", (Object)this.replicaId);
        struct.set("max_wait", (Object)this.maxWait);
        struct.set("min_bytes", (Object)this.minBytes);
        if (_version >= 3) {
            struct.set("max_bytes", (Object)this.maxBytes);
        }
        if (_version >= 4) {
            struct.set("isolation_level", (Object)this.isolationLevel);
        }
        if (_version >= 7) {
            struct.set("session_id", (Object)this.sessionId);
        }
        if (_version >= 7) {
            struct.set("epoch", (Object)this.epoch);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (FetchableTopic fetchableTopic : this.topics) {
            _nestedObjects[i++] = fetchableTopic.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        if (_version >= 7) {
            _nestedObjects = new Struct[this.forgotten.size()];
            i = 0;
            for (ForgottenTopic forgottenTopic : this.forgotten) {
                _nestedObjects[i++] = forgottenTopic.toStruct(_version);
            }
            struct.set("forgotten", (Object)_nestedObjects);
        }
        if (_version >= 11) {
            struct.set("rack_id", (Object)this.rackId);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 4;
        _size += 4;
        if (_version >= 3) {
            _size += 4;
        }
        if (_version >= 4) {
            ++_size;
        }
        if (_version >= 7) {
            _size += 4;
        }
        if (_version >= 7) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (FetchableTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 7) {
            _arraySize = 0;
            _arraySize += 4;
            for (ForgottenTopic forgottenElement : this.forgotten) {
                _arraySize += forgottenElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 11) {
            byte[] _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rackId, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchRequestData)) {
            return false;
        }
        FetchRequestData other = (FetchRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.maxWait != other.maxWait) {
            return false;
        }
        if (this.minBytes != other.minBytes) {
            return false;
        }
        if (this.maxBytes != other.maxBytes) {
            return false;
        }
        if (this.isolationLevel != other.isolationLevel) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        if (this.epoch != other.epoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.forgotten == null ? other.forgotten != null : !this.forgotten.equals(other.forgotten)) {
            return false;
        }
        return !(this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + this.maxWait;
        hashCode = 31 * hashCode + this.minBytes;
        hashCode = 31 * hashCode + this.maxBytes;
        hashCode = 31 * hashCode + this.isolationLevel;
        hashCode = 31 * hashCode + this.sessionId;
        hashCode = 31 * hashCode + this.epoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.forgotten == null ? 0 : this.forgotten.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "FetchRequestData(replicaId=" + this.replicaId + ", maxWait=" + this.maxWait + ", minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", isolationLevel=" + this.isolationLevel + ", sessionId=" + this.sessionId + ", epoch=" + this.epoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", forgotten=" + MessageUtil.deepToString(this.forgotten.iterator()) + ", rackId=" + (this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public byte isolationLevel() {
        return this.isolationLevel;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int epoch() {
        return this.epoch;
    }

    public List<FetchableTopic> topics() {
        return this.topics;
    }

    public List<ForgottenTopic> forgotten() {
        return this.forgotten;
    }

    public String rackId() {
        return this.rackId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public FetchRequestData setMaxWait(int v) {
        this.maxWait = v;
        return this;
    }

    public FetchRequestData setMinBytes(int v) {
        this.minBytes = v;
        return this;
    }

    public FetchRequestData setMaxBytes(int v) {
        this.maxBytes = v;
        return this;
    }

    public FetchRequestData setIsolationLevel(byte v) {
        this.isolationLevel = v;
        return this;
    }

    public FetchRequestData setSessionId(int v) {
        this.sessionId = v;
        return this;
    }

    public FetchRequestData setEpoch(int v) {
        this.epoch = v;
        return this;
    }

    public FetchRequestData setTopics(List<FetchableTopic> v) {
        this.topics = v;
        return this;
    }

    public FetchRequestData setForgotten(List<ForgottenTopic> v) {
        this.forgotten = v;
        return this;
    }

    public FetchRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_0), "The topics to fetch.")));
        SCHEMA_3 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_0), "The topics to fetch."));
        SCHEMA_4 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_0), "The topics to fetch."));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_5), "The topics to fetch."));
        SCHEMA_8 = SCHEMA_7 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("epoch", Type.INT32, "The epoch of the partition leader as known to the follower replica or a consumer."), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_5), "The topics to fetch."), new Field("forgotten", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."));
        SCHEMA_10 = SCHEMA_9 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("epoch", Type.INT32, "The epoch of the partition leader as known to the follower replica or a consumer."), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_9), "The topics to fetch."), new Field("forgotten", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."));
        SCHEMA_11 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("epoch", Type.INT32, "The epoch of the partition leader as known to the follower replica or a consumer."), new Field("topics", new ArrayOf(FetchableTopic.SCHEMA_9), "The topics to fetch."), new Field("forgotten", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."), new Field("rack_id", Type.STRING, "Rack ID of the consumer making this request"));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
    }

    public static class ForgottenTopic
    implements Message {
        private String name;
        private List<Integer> forgottenPartitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public ForgottenTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ForgottenTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public ForgottenTopic() {
            this.name = "";
            this.forgottenPartitionIndexes = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ForgottenTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field forgottenPartitionIndexes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.forgottenPartitionIndexes = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ForgottenTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.forgottenPartitionIndexes.size());
            _stringBytes = this.forgottenPartitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer forgottenPartitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(forgottenPartitionIndexesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ForgottenTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("forgotten_partition_indexes");
            this.forgottenPartitionIndexes = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.forgottenPartitionIndexes.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ForgottenTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Integer[] _nestedObjects = new Integer[this.forgottenPartitionIndexes.size()];
            int i = 0;
            for (Integer element : this.forgottenPartitionIndexes) {
                _nestedObjects[i++] = element;
            }
            struct.set("forgotten_partition_indexes", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ForgottenTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            _size += (_arraySize += this.forgottenPartitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ForgottenTopic)) {
                return false;
            }
            ForgottenTopic other = (ForgottenTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.forgottenPartitionIndexes == null ? other.forgottenPartitionIndexes != null : !this.forgottenPartitionIndexes.equals(other.forgottenPartitionIndexes));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.forgottenPartitionIndexes == null ? 0 : this.forgottenPartitionIndexes.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ForgottenTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", forgottenPartitionIndexes=" + MessageUtil.deepToString(this.forgottenPartitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> forgottenPartitionIndexes() {
            return this.forgottenPartitionIndexes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ForgottenTopic setName(String v) {
            this.name = v;
            return this;
        }

        public ForgottenTopic setForgottenPartitionIndexes(List<Integer> v) {
            this.forgottenPartitionIndexes = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = new Schema(new Field("name", Type.STRING, "The partition name."), new Field("forgotten_partition_indexes", new ArrayOf(Type.INT32), "The partitions indexes to forget.")))));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class FetchPartition
    implements Message {
        private int partitionIndex;
        private int currentLeaderEpoch;
        private long fetchOffset;
        private long logStartOffset;
        private int maxBytes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public FetchPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchPartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public FetchPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = -1;
            this.fetchOffset = 0L;
            this.logStartOffset = -1L;
            this.maxBytes = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.currentLeaderEpoch = _version >= 9 ? _readable.readInt() : -1;
            this.fetchOffset = _readable.readLong();
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            this.maxBytes = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchPartition");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 9) {
                _writable.writeInt(this.currentLeaderEpoch);
            }
            _writable.writeLong(this.fetchOffset);
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            } else if (this.logStartOffset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default logStartOffset at version " + _version);
            }
            _writable.writeInt(this.maxBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = _version >= 9 ? struct.getInt("current_leader_epoch") : -1;
            this.fetchOffset = struct.getLong("fetch_offset");
            this.logStartOffset = _version >= 5 ? struct.getLong("log_start_offset") : -1L;
            this.maxBytes = struct.getInt("max_bytes");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (_version >= 9) {
                struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            }
            struct.set("fetch_offset", (Object)this.fetchOffset);
            if (_version >= 5) {
                struct.set("log_start_offset", (Object)this.logStartOffset);
            }
            struct.set("max_bytes", (Object)this.maxBytes);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchPartition");
            }
            _size += 4;
            if (_version >= 9) {
                _size += 4;
            }
            _size += 8;
            if (_version >= 5) {
                _size += 8;
            }
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchPartition)) {
                return false;
            }
            FetchPartition other = (FetchPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.fetchOffset != other.fetchOffset) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            return this.maxBytes == other.maxBytes;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.fetchOffset >> 32) ^ (int)this.fetchOffset);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + this.maxBytes;
            return hashCode;
        }

        public String toString() {
            return "FetchPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", fetchOffset=" + this.fetchOffset + ", logStartOffset=" + this.logStartOffset + ", maxBytes=" + this.maxBytes + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long fetchOffset() {
            return this.fetchOffset;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public int maxBytes() {
            return this.maxBytes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public FetchPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public FetchPartition setFetchOffset(long v) {
            this.fetchOffset = v;
            return this;
        }

        public FetchPartition setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public FetchPartition setMaxBytes(int v) {
            this.maxBytes = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored.")))));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.  The field is only used when the request is sent by the follower."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored."))));
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.  The field is only used when the request is sent by the follower."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class FetchableTopic
    implements Message {
        private String name;
        private List<FetchPartition> fetchPartitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public FetchableTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchableTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public FetchableTopic() {
            this.name = "";
            this.fetchPartitions = new ArrayList<FetchPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchableTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field fetchPartitions was serialized as null");
            }
            ArrayList<FetchPartition> newCollection = new ArrayList<FetchPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchPartition(_readable, _version));
            }
            this.fetchPartitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchableTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.fetchPartitions.size());
            _stringBytes = this.fetchPartitions.iterator();
            while (_stringBytes.hasNext()) {
                FetchPartition fetchPartitionsElement = (FetchPartition)_stringBytes.next();
                fetchPartitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchableTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("fetch_partitions");
            this.fetchPartitions = new ArrayList<FetchPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.fetchPartitions.add(new FetchPartition((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchableTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.fetchPartitions.size()];
            int i = 0;
            for (FetchPartition element : this.fetchPartitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("fetch_partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchableTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (FetchPartition fetchPartitionsElement : this.fetchPartitions) {
                _arraySize += fetchPartitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchableTopic)) {
                return false;
            }
            FetchableTopic other = (FetchableTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.fetchPartitions == null ? other.fetchPartitions != null : !this.fetchPartitions.equals(other.fetchPartitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.fetchPartitions == null ? 0 : this.fetchPartitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "FetchableTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", fetchPartitions=" + MessageUtil.deepToString(this.fetchPartitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<FetchPartition> fetchPartitions() {
            return this.fetchPartitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchableTopic setName(String v) {
            this.name = v;
            return this;
        }

        public FetchableTopic setFetchPartitions(List<FetchPartition> v) {
            this.fetchPartitions = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The name of the topic to fetch."), new Field("fetch_partitions", new ArrayOf(FetchPartition.SCHEMA_0), "The partitions to fetch.")))));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The name of the topic to fetch."), new Field("fetch_partitions", new ArrayOf(FetchPartition.SCHEMA_5), "The partitions to fetch."))));
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("name", Type.STRING, "The name of the topic to fetch."), new Field("fetch_partitions", new ArrayOf(FetchPartition.SCHEMA_9), "The partitions to fetch.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }
}

