/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class MetadataResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private MetadataResponseBrokerCollection brokers;
    private String clusterId;
    private int controllerId;
    private MetadataResponseTopicCollection topics;
    private int clusterAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_0), "Each broker in the response."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_0), "Each topic in the response.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_1), "Each topic in the response.")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", (Type)Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_1), "Each topic in the response.")});
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema[] SCHEMAS;

    public MetadataResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public MetadataResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public MetadataResponseData() {
        this.throttleTimeMs = 0;
        this.brokers = new MetadataResponseBrokerCollection(0);
        this.clusterId = null;
        this.controllerId = -1;
        this.topics = new MetadataResponseTopicCollection(0);
        this.clusterAuthorizedOperations = Integer.MIN_VALUE;
    }

    public short apiKey() {
        return 3;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 9;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ImplicitLinkedHashMultiCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 3 ? _readable.readInt() : 0;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            newCollection = new MetadataResponseBrokerCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((ImplicitLinkedHashCollection.Element)new MetadataResponseBroker(_readable, _version));
            }
            this.brokers = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            newCollection = new MetadataResponseBrokerCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((ImplicitLinkedHashCollection.Element)new MetadataResponseBroker(_readable, _version));
            }
            this.brokers = newCollection;
        }
        if (_version >= 2) {
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.clusterId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clusterId had invalid length " + length);
                }
                this.clusterId = _readable.readString(length);
            }
        } else {
            this.clusterId = null;
        }
        this.controllerId = _version >= 1 ? _readable.readInt() : -1;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new MetadataResponseTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((ImplicitLinkedHashCollection.Element)new MetadataResponseTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new MetadataResponseTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((ImplicitLinkedHashCollection.Element)new MetadataResponseTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.clusterAuthorizedOperations = _version >= 8 ? _readable.readInt() : Integer.MIN_VALUE;
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        MetadataResponseTopic topicsElement;
        Object _stringBytes;
        MetadataResponseBroker brokersElement;
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _writable.writeInt(this.throttleTimeMs);
        } else if (this.throttleTimeMs != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default throttleTimeMs at version " + _version);
        }
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.brokers.size() + 1);
            iterator = this.brokers.iterator();
            while (iterator.hasNext()) {
                brokersElement = (MetadataResponseBroker)iterator.next();
                brokersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.brokers.size());
            iterator = this.brokers.iterator();
            while (iterator.hasNext()) {
                brokersElement = (MetadataResponseBroker)iterator.next();
                brokersElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 2) {
            if (this.clusterId == null) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.clusterId);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.controllerId);
        }
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (MetadataResponseTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (MetadataResponseTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 8) {
            _writable.writeInt(this.clusterAuthorizedOperations);
        } else if (this.clusterAuthorizedOperations != Integer.MIN_VALUE) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterAuthorizedOperations at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 3 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("brokers");
        this.brokers = new MetadataResponseBrokerCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.brokers.add(new MetadataResponseBroker((Struct)nestedObject, _version));
        }
        this.clusterId = _version >= 2 ? struct.getString("cluster_id") : null;
        this.controllerId = _version >= 1 ? struct.getInt("controller_id") : -1;
        _nestedObjects = struct.getArray("topics");
        this.topics = new MetadataResponseTopicCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new MetadataResponseTopic((Struct)nestedObject, _version));
        }
        this.clusterAuthorizedOperations = _version >= 8 ? struct.getInt("cluster_authorized_operations") : Integer.MIN_VALUE;
        if (_version >= 9 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        Object element;
        TreeMap _taggedFields = null;
        if (_version >= 9) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 3) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.brokers.size()];
        int i = 0;
        Iterator iterator = this.brokers.iterator();
        while (iterator.hasNext()) {
            element = (MetadataResponseBroker)iterator.next();
            _nestedObjects[i++] = ((MetadataResponseBroker)element).toStruct(_version);
        }
        struct.set("brokers", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("cluster_id", (Object)this.clusterId);
        }
        if (_version >= 1) {
            struct.set("controller_id", (Object)this.controllerId);
        }
        _nestedObjects = new Struct[this.topics.size()];
        i = 0;
        iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            element = (MetadataResponseTopic)iterator.next();
            _nestedObjects[i++] = ((MetadataResponseTopic)element).toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        if (_version >= 8) {
            struct.set("cluster_authorized_operations", (Object)this.clusterAuthorizedOperations);
        }
        if (_version >= 9) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.brokers.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.brokers.iterator();
        while (iterator.hasNext()) {
            MetadataResponseBroker brokersElement = (MetadataResponseBroker)iterator.next();
            _arraySize += brokersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 2) {
            if (this.clusterId == null) {
                _size = _version >= 9 ? ++_size : (_size += 2);
            } else {
                byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.clusterId, _stringBytes);
                _size = _version >= 9 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            }
        }
        if (_version >= 1) {
            _size += 4;
        }
        _arraySize = 0;
        _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
        iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            MetadataResponseTopic topicsElement = (MetadataResponseTopic)iterator.next();
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 8) {
            _size += 4;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 9) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataResponseData)) {
            return false;
        }
        MetadataResponseData other = (MetadataResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.brokers == null ? other.brokers != null : !this.brokers.equals((Object)other.brokers)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics)) {
            return false;
        }
        return this.clusterAuthorizedOperations == other.clusterAuthorizedOperations;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.clusterAuthorizedOperations;
        return hashCode;
    }

    public String toString() {
        return "MetadataResponseData(throttleTimeMs=" + this.throttleTimeMs + ", brokers=" + MessageUtil.deepToString((Iterator)this.brokers.iterator()) + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", controllerId=" + this.controllerId + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ", clusterAuthorizedOperations=" + this.clusterAuthorizedOperations + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public MetadataResponseBrokerCollection brokers() {
        return this.brokers;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public MetadataResponseTopicCollection topics() {
        return this.topics;
    }

    public int clusterAuthorizedOperations() {
        return this.clusterAuthorizedOperations;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MetadataResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public MetadataResponseData setBrokers(MetadataResponseBrokerCollection v) {
        this.brokers = v;
        return this;
    }

    public MetadataResponseData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public MetadataResponseData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public MetadataResponseData setTopics(MetadataResponseTopicCollection v) {
        this.topics = v;
        return this;
    }

    public MetadataResponseData setClusterAuthorizedOperations(int v) {
        this.clusterAuthorizedOperations = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", (Type)Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_1), "Each topic in the response.")});
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", (Type)Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_5), "Each topic in the response.")});
        SCHEMA_7 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", (Type)Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_7), "Each topic in the response.")});
        SCHEMA_8 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", (Type)new ArrayOf((Type)MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", (Type)Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new ArrayOf((Type)MetadataResponseTopic.SCHEMA_8), "Each topic in the response."), new Field("cluster_authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this cluster.")});
        SCHEMA_9 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", (Type)new CompactArrayOf((Type)MetadataResponseBroker.SCHEMA_9), "Each broker in the response."), new Field("cluster_id", (Type)Type.COMPACT_NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("topics", (Type)new CompactArrayOf((Type)MetadataResponseTopic.SCHEMA_9), "Each topic in the response."), new Field("cluster_authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this cluster."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
    }

    public static class MetadataResponseTopicCollection
    extends ImplicitLinkedHashMultiCollection<MetadataResponseTopic> {
        public MetadataResponseTopicCollection() {
        }

        public MetadataResponseTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseTopicCollection(Iterator<MetadataResponseTopic> iterator) {
            super(iterator);
        }

        public MetadataResponseTopic find(String name) {
            MetadataResponseTopic key = new MetadataResponseTopic();
            key.setName(name);
            return (MetadataResponseTopic)this.find(key);
        }

        public List<MetadataResponseTopic> findAll(String name) {
            MetadataResponseTopic key = new MetadataResponseTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class MetadataResponsePartition
    implements Message {
        private short errorCode;
        private int partitionIndex;
        private int leaderId;
        private int leaderEpoch;
        private List<Integer> replicaNodes;
        private List<Integer> isrNodes;
        private List<Integer> offlineReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;

        public MetadataResponsePartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MetadataResponsePartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MetadataResponsePartition() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderId = 0;
            this.leaderEpoch = -1;
            this.replicaNodes = new ArrayList<Integer>();
            this.isrNodes = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 9;
        }

        public void read(Readable _readable, short _version) {
            int i;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponsePartition");
            }
            this.errorCode = _readable.readShort();
            this.partitionIndex = _readable.readInt();
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _version >= 7 ? _readable.readInt() : -1;
            int arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaNodes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicaNodes = newCollection;
            arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isrNodes was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isrNodes = newCollection;
            if (_version >= 5) {
                arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field offlineReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.offlineReplicas = newCollection;
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponsePartition");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderId);
            if (_version >= 7) {
                _writable.writeInt(this.leaderEpoch);
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.replicaNodes.size() + 1);
            } else {
                _writable.writeInt(this.replicaNodes.size());
            }
            for (Integer replicaNodesElement : this.replicaNodes) {
                _writable.writeInt(replicaNodesElement.intValue());
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.isrNodes.size() + 1);
            } else {
                _writable.writeInt(this.isrNodes.size());
            }
            for (Integer isrNodesElement : this.isrNodes) {
                _writable.writeInt(isrNodesElement.intValue());
            }
            if (_version >= 5) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(this.offlineReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.offlineReplicas.size());
                }
                for (Integer offlineReplicasElement : this.offlineReplicas) {
                    _writable.writeInt(offlineReplicasElement.intValue());
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponsePartition");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.partitionIndex = struct.getInt("partition_index");
            this.leaderId = struct.getInt("leader_id");
            this.leaderEpoch = _version >= 7 ? struct.getInt("leader_epoch") : -1;
            Object[] _nestedObjects = struct.getArray("replica_nodes");
            this.replicaNodes = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.replicaNodes.add((Integer)nestedObject);
            }
            _nestedObjects = struct.getArray("isr_nodes");
            this.isrNodes = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.isrNodes.add((Integer)nestedObject);
            }
            if (_version >= 5) {
                _nestedObjects = struct.getArray("offline_replicas");
                this.offlineReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.offlineReplicas.add((Integer)nestedObject);
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
            if (_version >= 9 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponsePartition");
            }
            TreeMap _taggedFields = null;
            if (_version >= 9) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("leader_id", (Object)this.leaderId);
            if (_version >= 7) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            }
            Integer[] _nestedObjects = new Integer[this.replicaNodes.size()];
            int i = 0;
            for (Integer element : this.replicaNodes) {
                _nestedObjects[i++] = element;
            }
            struct.set("replica_nodes", (Object)_nestedObjects);
            _nestedObjects = new Integer[this.isrNodes.size()];
            i = 0;
            for (Integer element : this.isrNodes) {
                _nestedObjects[i++] = element;
            }
            struct.set("isr_nodes", (Object)_nestedObjects);
            if (_version >= 5) {
                _nestedObjects = new Integer[this.offlineReplicas.size()];
                i = 0;
                for (Integer element : this.offlineReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("offline_replicas", (Object)_nestedObjects);
            }
            if (_version >= 9) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponsePartition");
            }
            _size += 2;
            _size += 4;
            _size += 4;
            if (_version >= 7) {
                _size += 4;
            }
            int _arraySize = 0;
            _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.replicaNodes.size() + 1))) : (_arraySize += 4);
            _size += (_arraySize += this.replicaNodes.size() * 4);
            _arraySize = 0;
            _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.isrNodes.size() + 1))) : (_arraySize += 4);
            _size += (_arraySize += this.isrNodes.size() * 4);
            if (_version >= 5) {
                _arraySize = 0;
                _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.offlineReplicas.size() + 1))) : (_arraySize += 4);
                _size += (_arraySize += this.offlineReplicas.size() * 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 9) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponsePartition)) {
                return false;
            }
            MetadataResponsePartition other = (MetadataResponsePartition)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.replicaNodes == null ? other.replicaNodes != null : !this.replicaNodes.equals(other.replicaNodes)) {
                return false;
            }
            if (this.isrNodes == null ? other.isrNodes != null : !this.isrNodes.equals(other.isrNodes)) {
                return false;
            }
            return !(this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.replicaNodes == null ? 0 : this.replicaNodes.hashCode());
            hashCode = 31 * hashCode + (this.isrNodes == null ? 0 : this.isrNodes.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataResponsePartition(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", replicaNodes=" + MessageUtil.deepToString(this.replicaNodes.iterator()) + ", isrNodes=" + MessageUtil.deepToString(this.isrNodes.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> replicaNodes() {
            return this.replicaNodes;
        }

        public List<Integer> isrNodes() {
            return this.isrNodes;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public MetadataResponsePartition setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public MetadataResponsePartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public MetadataResponsePartition setReplicaNodes(List<Integer> v) {
            this.replicaNodes = v;
            return this;
        }

        public MetadataResponsePartition setIsrNodes(List<Integer> v) {
            this.isrNodes = v;
            return this;
        }

        public MetadataResponsePartition setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("leader_id", (Type)Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of nodes that are in sync with the leader for this partition.")}))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("leader_id", (Type)Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", (Type)new ArrayOf((Type)Type.INT32), "The set of offline replicas of this partition.")});
            SCHEMA_8 = SCHEMA_7 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("leader_id", (Type)Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", (Type)Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", (Type)new ArrayOf((Type)Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", (Type)new ArrayOf((Type)Type.INT32), "The set of offline replicas of this partition.")});
            SCHEMA_9 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("leader_id", (Type)Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", (Type)Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", (Type)new CompactArrayOf((Type)Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", (Type)new CompactArrayOf((Type)Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The set of offline replicas of this partition."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }

    public static class MetadataResponseTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private short errorCode;
        private String name;
        private boolean isInternal;
        private List<MetadataResponsePartition> partitions;
        private int topicAuthorizedOperations;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)MetadataResponsePartition.SCHEMA_0), "Each partition in the topic.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;

        public MetadataResponseTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MetadataResponseTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MetadataResponseTopic() {
            this.errorCode = 0;
            this.name = "";
            this.isInternal = false;
            this.partitions = new ArrayList<MetadataResponsePartition>();
            this.topicAuthorizedOperations = Integer.MIN_VALUE;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 9;
        }

        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<MetadataResponsePartition> newCollection;
            int arrayLength;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseTopic");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.isInternal = _version >= 1 ? _readable.readByte() != 0 : false;
            if (_version >= 9) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataResponsePartition(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<MetadataResponsePartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataResponsePartition(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this.topicAuthorizedOperations = _version >= 8 ? _readable.readInt() : Integer.MIN_VALUE;
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponseTopic");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.isInternal ? (byte)1 : 0);
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    MetadataResponsePartition partitionsElement = (MetadataResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    MetadataResponsePartition partitionsElement = (MetadataResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            if (_version >= 8) {
                _writable.writeInt(this.topicAuthorizedOperations);
            } else if (this.topicAuthorizedOperations != Integer.MIN_VALUE) {
                throw new UnsupportedVersionException("Attempted to write a non-default topicAuthorizedOperations at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.name = struct.getString("name");
            this.isInternal = _version >= 1 ? struct.getBoolean("is_internal") : false;
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<MetadataResponsePartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new MetadataResponsePartition((Struct)nestedObject, _version));
            }
            this.topicAuthorizedOperations = _version >= 8 ? struct.getInt("topic_authorized_operations") : Integer.MIN_VALUE;
            if (_version >= 9 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponseTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 9) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("name", (Object)this.name);
            if (_version >= 1) {
                struct.set("is_internal", (Object)this.isInternal);
            }
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (MetadataResponsePartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            if (_version >= 8) {
                struct.set("topic_authorized_operations", (Object)this.topicAuthorizedOperations);
            }
            if (_version >= 9) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponseTopic");
            }
            _size += 2;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 9 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            if (_version >= 1) {
                ++_size;
            }
            int _arraySize = 0;
            _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1))) : (_arraySize += 4);
            for (MetadataResponsePartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (_version >= 8) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 9) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseTopic)) {
                return false;
            }
            MetadataResponseTopic other = (MetadataResponseTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataResponseTopic(errorCode=" + this.errorCode + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", isInternal=" + (this.isInternal ? "true" : "false") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ", topicAuthorizedOperations=" + this.topicAuthorizedOperations + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String name() {
            return this.name;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<MetadataResponsePartition> partitions() {
            return this.partitions;
        }

        public int topicAuthorizedOperations() {
            return this.topicAuthorizedOperations;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponseTopic setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public MetadataResponseTopic setIsInternal(boolean v) {
            this.isInternal = v;
            return this;
        }

        public MetadataResponseTopic setPartitions(List<MetadataResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        public MetadataResponseTopic setTopicAuthorizedOperations(int v) {
            this.topicAuthorizedOperations = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.STRING, "The topic name."), new Field("is_internal", (Type)Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", (Type)new ArrayOf((Type)MetadataResponsePartition.SCHEMA_0), "Each partition in the topic.")})));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.STRING, "The topic name."), new Field("is_internal", (Type)Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", (Type)new ArrayOf((Type)MetadataResponsePartition.SCHEMA_5), "Each partition in the topic.")});
            SCHEMA_7 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.STRING, "The topic name."), new Field("is_internal", (Type)Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", (Type)new ArrayOf((Type)MetadataResponsePartition.SCHEMA_7), "Each partition in the topic.")});
            SCHEMA_8 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.STRING, "The topic name."), new Field("is_internal", (Type)Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", (Type)new ArrayOf((Type)MetadataResponsePartition.SCHEMA_7), "Each partition in the topic."), new Field("topic_authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this topic.")});
            SCHEMA_9 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("is_internal", (Type)Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", (Type)new CompactArrayOf((Type)MetadataResponsePartition.SCHEMA_9), "Each partition in the topic."), new Field("topic_authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this topic."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }

    public static class MetadataResponseBrokerCollection
    extends ImplicitLinkedHashMultiCollection<MetadataResponseBroker> {
        public MetadataResponseBrokerCollection() {
        }

        public MetadataResponseBrokerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseBrokerCollection(Iterator<MetadataResponseBroker> iterator) {
            super(iterator);
        }

        public MetadataResponseBroker find(int nodeId) {
            MetadataResponseBroker key = new MetadataResponseBroker();
            key.setNodeId(nodeId);
            return (MetadataResponseBroker)this.find(key);
        }

        public List<MetadataResponseBroker> findAll(int nodeId) {
            MetadataResponseBroker key = new MetadataResponseBroker();
            key.setNodeId(nodeId);
            return this.findAll(key);
        }
    }

    public static class MetadataResponseBroker
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private int nodeId;
        private String host;
        private int port;
        private String rack;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("node_id", (Type)Type.INT32, "The broker ID."), new Field("host", (Type)Type.STRING, "The broker hostname."), new Field("port", (Type)Type.INT32, "The broker port.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;

        public MetadataResponseBroker(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MetadataResponseBroker(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MetadataResponseBroker() {
            this.nodeId = 0;
            this.host = "";
            this.port = 0;
            this.rack = null;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 9;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseBroker");
            }
            this.nodeId = _readable.readInt();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readInt();
            if (_version >= 1) {
                length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.rack = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field rack had invalid length " + length);
                    }
                    this.rack = _readable.readString(length);
                }
            } else {
                this.rack = null;
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponseBroker");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.nodeId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.host);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            if (_version >= 1) {
                if (this.rack == null) {
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue((Object)this.rack);
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseBroker");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.nodeId = struct.getInt("node_id");
            this.host = struct.getString("host");
            this.port = struct.getInt("port");
            this.rack = _version >= 1 ? struct.getString("rack") : null;
            if (_version >= 9 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataResponseBroker");
            }
            TreeMap _taggedFields = null;
            if (_version >= 9) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("node_id", (Object)this.nodeId);
            struct.set("host", (Object)this.host);
            struct.set("port", (Object)this.port);
            if (_version >= 1) {
                struct.set("rack", (Object)this.rack);
            }
            if (_version >= 9) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponseBroker");
            }
            _size += 4;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size = _version >= 9 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (_version >= 1) {
                if (this.rack == null) {
                    _size = _version >= 9 ? ++_size : (_size += 2);
                } else {
                    _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'rack' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue((Object)this.rack, _stringBytes);
                    _size = _version >= 9 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 9) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseBroker)) {
                return false;
            }
            MetadataResponseBroker other = (MetadataResponseBroker)obj;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.nodeId;
            return hashCode;
        }

        public String toString() {
            return "MetadataResponseBroker(nodeId=" + this.nodeId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ")";
        }

        public int nodeId() {
            return this.nodeId;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String rack() {
            return this.rack;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponseBroker setNodeId(int v) {
            this.nodeId = v;
            return this;
        }

        public MetadataResponseBroker setHost(String v) {
            this.host = v;
            return this;
        }

        public MetadataResponseBroker setPort(int v) {
            this.port = v;
            return this;
        }

        public MetadataResponseBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("node_id", (Type)Type.INT32, "The broker ID."), new Field("host", (Type)Type.STRING, "The broker hostname."), new Field("port", (Type)Type.INT32, "The broker port."), new Field("rack", (Type)Type.NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack.")})))))));
            SCHEMA_9 = new Schema(new Field[]{new Field("node_id", (Type)Type.INT32, "The broker ID."), new Field("host", (Type)Type.COMPACT_STRING, "The broker hostname."), new Field("port", (Type)Type.INT32, "The broker port."), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }
}

