/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetCommitRequestTest {
    protected static String groupId = "groupId";
    protected static String topicOne = "topicOne";
    protected static String topicTwo = "topicTwo";
    protected static int partitionOne = 1;
    protected static int partitionTwo = 2;
    protected static long offset = 100L;
    protected static short leaderEpoch = (short)20;
    protected static String metadata = "metadata";
    protected static int throttleTimeMs = 10;
    private static OffsetCommitRequestData data;
    private static List<OffsetCommitRequestData.OffsetCommitRequestTopic> topics;

    @Before
    public void setUp() {
        topics = Arrays.asList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicOne).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partitionOne).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata))), new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicTwo).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partitionTwo).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata))));
        data = new OffsetCommitRequestData().setGroupId(groupId).setTopics(topics);
    }

    @Test
    public void testConstructor() {
        HashMap<TopicPartition, Long> expectedOffsets = new HashMap<TopicPartition, Long>();
        expectedOffsets.put(new TopicPartition(topicOne, partitionOne), offset);
        expectedOffsets.put(new TopicPartition(topicTwo, partitionTwo), offset);
        OffsetCommitRequest.Builder builder = new OffsetCommitRequest.Builder(data);
        for (short version = 0; version <= ApiKeys.TXN_OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            OffsetCommitRequest request = builder.build(version);
            Assert.assertEquals(expectedOffsets, (Object)request.offsets());
            OffsetCommitResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assert.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 2), (Object)response.errorCounts());
            if (version >= 3) {
                Assert.assertEquals((long)throttleTimeMs, (long)response.throttleTimeMs());
                continue;
            }
            Assert.assertEquals((long)0L, (long)response.throttleTimeMs());
        }
    }

    @Test
    public void testGetErrorResponseTopics() {
        List<OffsetCommitResponseData.OffsetCommitResponseTopic> expectedTopics = Arrays.asList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicOne).setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setPartitionIndex(partitionOne))), new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicTwo).setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setPartitionIndex(partitionTwo))));
        Assert.assertEquals(expectedTopics, (Object)OffsetCommitRequest.getErrorResponseTopics(topics, (Errors)Errors.UNKNOWN_MEMBER_ID));
    }

    @Test
    public void testVersionSupportForGroupInstanceId() {
        OffsetCommitRequest.Builder builder = new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId("groupId").setMemberId("consumerId").setGroupInstanceId("groupInstanceId"));
        for (short version = 0; version <= ApiKeys.OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            if (version >= 7) {
                builder.build(version);
                continue;
            }
            short finalVersion = version;
            Assert.assertThrows(UnsupportedVersionException.class, () -> builder.build(finalVersion));
        }
    }
}

