/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitRequestTest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TxnOffsetCommitRequestTest
extends OffsetCommitRequestTest {
    private static String transactionalId = "transactionalId";
    private static int producerId = 10;
    private static short producerEpoch = 1;
    private static TxnOffsetCommitRequestData data;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        data = new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(Arrays.asList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicOne).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionOne).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata))), new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicTwo).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionTwo).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata)))));
    }

    @Override
    @Test
    public void testConstructor() {
        HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> expectedOffsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        expectedOffsets.put(new TopicPartition(topicOne, partitionOne), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        expectedOffsets.put(new TopicPartition(topicTwo, partitionTwo), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        TxnOffsetCommitRequest.Builder builder = new TxnOffsetCommitRequest.Builder(data);
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(new TopicPartition(topicOne, partitionOne), Errors.NOT_COORDINATOR);
        errorsMap.put(new TopicPartition(topicTwo, partitionTwo), Errors.NOT_COORDINATOR);
        for (short version = 0; version <= ApiKeys.TXN_OFFSET_COMMIT.latestVersion(); version = (short)(version + 1)) {
            TxnOffsetCommitRequest request = builder.build(version);
            Assert.assertEquals(expectedOffsets, (Object)request.offsets());
            Assert.assertEquals(data.topics(), (Object)TxnOffsetCommitRequest.getTopics((Map)request.offsets()));
            TxnOffsetCommitResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assert.assertEquals(errorsMap, (Object)response.errors());
            Assert.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 2), (Object)response.errorCounts());
            Assert.assertEquals((long)throttleTimeMs, (long)response.throttleTimeMs());
        }
    }
}

