/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ApiVersionsResponseData
implements ApiMessage {
    private short errorCode;
    private ApiVersionsResponseKeyCollection apiKeys;
    private int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new ArrayOf((Type)ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public ApiVersionsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ApiVersionsResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public ApiVersionsResponseData() {
        this.errorCode = 0;
        this.apiKeys = new ApiVersionsResponseKeyCollection(0);
        this.throttleTimeMs = 0;
    }

    public short apiKey() {
        return 18;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ApiVersionsResponseKeyCollection newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            newCollection = new ApiVersionsResponseKeyCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersionsResponseKey(_readable, _version));
            }
            this.apiKeys = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            newCollection = new ApiVersionsResponseKeyCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersionsResponseKey(_readable, _version));
            }
            this.apiKeys = newCollection;
        }
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.apiKeys.size() + 1);
            iterator = this.apiKeys.iterator();
            while (iterator.hasNext()) {
                ApiVersionsResponseKey apiKeysElement = (ApiVersionsResponseKey)iterator.next();
                apiKeysElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.apiKeys.size());
            iterator = this.apiKeys.iterator();
            while (iterator.hasNext()) {
                ApiVersionsResponseKey apiKeysElement = (ApiVersionsResponseKey)iterator.next();
                apiKeysElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("api_keys");
        this.apiKeys = new ApiVersionsResponseKeyCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.apiKeys.add(new ApiVersionsResponseKey((Struct)nestedObject, _version));
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        if (_version >= 3 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 3) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.apiKeys.size()];
        int i = 0;
        Iterator iterator = this.apiKeys.iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseKey element = (ApiVersionsResponseKey)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("api_keys", (Object)_nestedObjects);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        if (_version >= 3) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize = _version >= 3 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.apiKeys.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.apiKeys.iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseKey apiKeysElement = (ApiVersionsResponseKey)iterator.next();
            _arraySize += apiKeysElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 1) {
            _size += 4;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 3) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiVersionsResponseData)) {
            return false;
        }
        ApiVersionsResponseData other = (ApiVersionsResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.apiKeys == null ? other.apiKeys != null : !this.apiKeys.equals((Object)other.apiKeys)) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.apiKeys == null ? 0 : this.apiKeys.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "ApiVersionsResponseData(errorCode=" + this.errorCode + ", apiKeys=" + MessageUtil.deepToString((Iterator)this.apiKeys.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public ApiVersionsResponseKeyCollection apiKeys() {
        return this.apiKeys;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ApiVersionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ApiVersionsResponseData setApiKeys(ApiVersionsResponseKeyCollection v) {
        this.apiKeys = v;
        return this;
    }

    public ApiVersionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new ArrayOf((Type)ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
        SCHEMA_3 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new CompactArrayOf((Type)ApiVersionsResponseKey.SCHEMA_3), "The APIs supported by the broker."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class ApiVersionsResponseKeyCollection
    extends ImplicitLinkedHashMultiCollection<ApiVersionsResponseKey> {
        public ApiVersionsResponseKeyCollection() {
        }

        public ApiVersionsResponseKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ApiVersionsResponseKeyCollection(Iterator<ApiVersionsResponseKey> iterator) {
            super(iterator);
        }

        public ApiVersionsResponseKey find(short apiKey) {
            ApiVersionsResponseKey _key = new ApiVersionsResponseKey();
            _key.setApiKey(apiKey);
            return (ApiVersionsResponseKey)this.find(_key);
        }

        public List<ApiVersionsResponseKey> findAll(short apiKey) {
            ApiVersionsResponseKey _key = new ApiVersionsResponseKey();
            _key.setApiKey(apiKey);
            return this.findAll(_key);
        }
    }

    public static class ApiVersionsResponseKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private short apiKey;
        private short minVersion;
        private short maxVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public ApiVersionsResponseKey(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public ApiVersionsResponseKey(Struct struct, short _version) {
            this.fromStruct(struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public ApiVersionsResponseKey() {
            this.apiKey = 0;
            this.minVersion = 0;
            this.maxVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ApiVersionsResponseKey");
            }
            this.apiKey = _readable.readShort();
            this.minVersion = _readable.readShort();
            this.maxVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ApiVersionsResponseKey");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.apiKey);
            _writable.writeShort(this.minVersion);
            _writable.writeShort(this.maxVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ApiVersionsResponseKey");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.apiKey = struct.getShort("api_key");
            this.minVersion = struct.getShort("min_version");
            this.maxVersion = struct.getShort("max_version");
            if (_version >= 3 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ApiVersionsResponseKey");
            }
            TreeMap _taggedFields = null;
            if (_version >= 3) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("api_key", (Object)this.apiKey);
            struct.set("min_version", (Object)this.minVersion);
            struct.set("max_version", (Object)this.maxVersion);
            if (_version >= 3) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ApiVersionsResponseKey");
            }
            _size += 2;
            _size += 2;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 3) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApiVersionsResponseKey)) {
                return false;
            }
            ApiVersionsResponseKey other = (ApiVersionsResponseKey)obj;
            return this.apiKey == other.apiKey;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.apiKey;
            return hashCode;
        }

        public String toString() {
            return "ApiVersionsResponseKey(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public short apiKey() {
            return this.apiKey;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ApiVersionsResponseKey setApiKey(short v) {
            this.apiKey = v;
            return this;
        }

        public ApiVersionsResponseKey setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public ApiVersionsResponseKey setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("api_key", (Type)Type.INT16, "The API index."), new Field("min_version", (Type)Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", (Type)Type.INT16, "The maximum supported version, inclusive.")}));
            SCHEMA_3 = new Schema(new Field[]{new Field("api_key", (Type)Type.INT16, "The API index."), new Field("min_version", (Type)Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", (Type)Type.INT16, "The maximum supported version, inclusive."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

