/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;

public class UtilsTest {
    @Test
    public void testMurmur2() {
        HashMap<byte[], Integer> cases = new HashMap<byte[], Integer>();
        cases.put("21".getBytes(), -973932308);
        cases.put("foobar".getBytes(), -790332482);
        cases.put("a-little-bit-long-string".getBytes(), -985981536);
        cases.put("a-little-bit-longer-string".getBytes(), -1486304829);
        cases.put("lkjh234lh9fiuh90y23oiuhsafujhadof229phr9h19h89h8".getBytes(), -58897971);
        cases.put(new byte[]{97, 98, 99}, 479470107);
        for (Map.Entry c : cases.entrySet()) {
            Assert.assertEquals((long)((Integer)c.getValue()).intValue(), (long)Utils.murmur2((byte[])((byte[])c.getKey())));
        }
    }

    @Test
    public void testGetHost() {
        Assert.assertEquals((Object)"127.0.0.1", (Object)Utils.getHost((String)"127.0.0.1:8000"));
        Assert.assertEquals((Object)"mydomain.com", (Object)Utils.getHost((String)"PLAINTEXT://mydomain.com:8080"));
        Assert.assertEquals((Object)"MyDomain.com", (Object)Utils.getHost((String)"PLAINTEXT://MyDomain.com:8080"));
        Assert.assertEquals((Object)"My_Domain.com", (Object)Utils.getHost((String)"PLAINTEXT://My_Domain.com:8080"));
        Assert.assertEquals((Object)"::1", (Object)Utils.getHost((String)"[::1]:1234"));
        Assert.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678"));
        Assert.assertEquals((Object)"2001:DB8:85A3:8D3:1319:8A2E:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678"));
        Assert.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)Utils.getHost((String)"PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:5678"));
    }

    @Test
    public void testHostPattern() {
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"127.0.0.1"));
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"mydomain.com"));
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"MyDomain.com"));
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"My_Domain.com"));
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"::1"));
        Assert.assertTrue((boolean)Utils.validHostPattern((String)"2001:db8:85a3:8d3:1319:8a2e:370"));
    }

    @Test
    public void testGetPort() {
        Assert.assertEquals((long)8000L, (long)Utils.getPort((String)"127.0.0.1:8000").intValue());
        Assert.assertEquals((long)8080L, (long)Utils.getPort((String)"mydomain.com:8080").intValue());
        Assert.assertEquals((long)8080L, (long)Utils.getPort((String)"MyDomain.com:8080").intValue());
        Assert.assertEquals((long)1234L, (long)Utils.getPort((String)"[::1]:1234").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[fe80::b1da:69ca:57f7:63d8%3]:5678").intValue());
    }

    @Test
    public void testFormatAddress() {
        Assert.assertEquals((Object)"127.0.0.1:8000", (Object)Utils.formatAddress((String)"127.0.0.1", (Integer)8000));
        Assert.assertEquals((Object)"mydomain.com:8080", (Object)Utils.formatAddress((String)"mydomain.com", (Integer)8080));
        Assert.assertEquals((Object)"[::1]:1234", (Object)Utils.formatAddress((String)"::1", (Integer)1234));
        Assert.assertEquals((Object)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678", (Object)Utils.formatAddress((String)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Integer)5678));
    }

    @Test
    public void testFormatBytes() {
        Assert.assertEquals((Object)"-1", (Object)Utils.formatBytes((long)-1L));
        Assert.assertEquals((Object)"1023 B", (Object)Utils.formatBytes((long)1023L));
        Assert.assertEquals((Object)"1 KB", (Object)Utils.formatBytes((long)1024L));
        Assert.assertEquals((Object)"1024 KB", (Object)Utils.formatBytes((long)1048575L));
        Assert.assertEquals((Object)"1 MB", (Object)Utils.formatBytes((long)0x100000L));
        Assert.assertEquals((Object)"1.1 MB", (Object)Utils.formatBytes((long)0x119999L));
        Assert.assertEquals((Object)"10 MB", (Object)Utils.formatBytes((long)0xA00000L));
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"", (Object)Utils.join(Collections.emptyList(), (String)","));
        Assert.assertEquals((Object)"1", (Object)Utils.join(Arrays.asList("1"), (String)","));
        Assert.assertEquals((Object)"1,2,3", (Object)Utils.join(Arrays.asList(1, 2, 3), (String)","));
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)10L, (long)Utils.abs((int)-10));
        Assert.assertEquals((long)10L, (long)Utils.abs((int)10));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
    }

    @Test
    public void writeToBuffer() throws IOException {
        byte[] input = new byte[]{0, 1, 2, 3, 4, 5};
        ByteBuffer source = ByteBuffer.wrap(input);
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocate(input.length));
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocateDirect(input.length));
        Assert.assertEquals((long)0L, (long)source.position());
        source.position(2);
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocate(input.length));
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocateDirect(input.length));
    }

    private void doTestWriteToByteBuffer(ByteBuffer source, ByteBuffer dest) throws IOException {
        int numBytes = source.remaining();
        int position = source.position();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(dest));
        Utils.writeTo((DataOutput)out, (ByteBuffer)source, (int)source.remaining());
        dest.flip();
        Assert.assertEquals((long)numBytes, (long)dest.remaining());
        Assert.assertEquals((long)position, (long)source.position());
        Assert.assertEquals((Object)source, (Object)dest);
    }

    @Test
    public void toArray() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        Assert.assertArrayEquals((byte[])input, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assert.assertEquals((long)0L, (long)buffer.position());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])Utils.toArray((ByteBuffer)buffer, (int)1, (int)2));
        Assert.assertEquals((long)0L, (long)buffer.position());
        buffer.position(2);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assert.assertEquals((long)2L, (long)buffer.position());
    }

    @Test
    public void toArrayDirectByteBuffer() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.allocateDirect(5);
        buffer.put(input);
        buffer.rewind();
        Assert.assertArrayEquals((byte[])input, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assert.assertEquals((long)0L, (long)buffer.position());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])Utils.toArray((ByteBuffer)buffer, (int)1, (int)2));
        Assert.assertEquals((long)0L, (long)buffer.position());
        buffer.position(2);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assert.assertEquals((long)2L, (long)buffer.position());
    }

    @Test
    public void utf8ByteArraySerde() {
        String utf8String = "A\u00ea\u00f1\u00fcC";
        byte[] utf8Bytes = utf8String.getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])utf8Bytes, (byte[])Utils.utf8((String)utf8String));
        Assert.assertEquals((long)utf8Bytes.length, (long)Utils.utf8Length((CharSequence)utf8String));
        Assert.assertEquals((Object)utf8String, (Object)Utils.utf8((byte[])utf8Bytes));
    }

    @Test
    public void utf8ByteBufferSerde() {
        this.doTestUtf8ByteBuffer(ByteBuffer.allocate(20));
        this.doTestUtf8ByteBuffer(ByteBuffer.allocateDirect(20));
    }

    private void doTestUtf8ByteBuffer(ByteBuffer utf8Buffer) {
        String utf8String = "A\u00ea\u00f1\u00fcC";
        byte[] utf8Bytes = utf8String.getBytes(StandardCharsets.UTF_8);
        utf8Buffer.position(4);
        utf8Buffer.put(utf8Bytes);
        utf8Buffer.position(4);
        Assert.assertEquals((Object)utf8String, (Object)Utils.utf8((ByteBuffer)utf8Buffer, (int)utf8Bytes.length));
        Assert.assertEquals((long)4L, (long)utf8Buffer.position());
        utf8Buffer.position(0);
        Assert.assertEquals((Object)utf8String, (Object)Utils.utf8((ByteBuffer)utf8Buffer, (int)4, (int)utf8Bytes.length));
        Assert.assertEquals((long)0L, (long)utf8Buffer.position());
    }

    private void subTest(ByteBuffer buffer) {
        Assert.assertEquals((long)65L, (long)Utils.readBytes((ByteBuffer)buffer, (int)0, (int)1)[0]);
        byte[] results = Utils.readBytes((ByteBuffer)buffer, (int)2, (int)3);
        Assert.assertEquals((long)121L, (long)results[0]);
        Assert.assertEquals((long)32L, (long)results[1]);
        Assert.assertEquals((long)83L, (long)results[2]);
        Assert.assertEquals((long)3L, (long)results.length);
        results = Utils.readBytes((ByteBuffer)buffer);
        Assert.assertEquals((long)65L, (long)results[0]);
        Assert.assertEquals((long)116L, (long)results[buffer.limit() - 1]);
        Assert.assertEquals((long)buffer.limit(), (long)results.length);
    }

    @Test
    public void testReadBytes() {
        byte[] myvar = "Any String you want".getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(myvar.length);
        buffer.put(myvar);
        buffer.rewind();
        this.subTest(buffer);
        buffer = ByteBuffer.wrap(myvar).asReadOnlyBuffer();
        this.subTest(buffer);
    }

    @Test
    public void testFileAsStringSimpleFile() throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            String testContent = "Test Content";
            Files.write(tempFile.toPath(), testContent.getBytes(), new OpenOption[0]);
            Assert.assertEquals((Object)testContent, (Object)Utils.readFileAsString((String)tempFile.getPath()));
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileAsStringNamedPipe() throws Exception {
        Random random = new Random();
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        String tmpDir = System.getProperty("java.io.tmpdir");
        String fifoName = "fifo-" + n + ".tmp";
        File fifo = new File(tmpDir, fifoName);
        Thread producerThread = null;
        try {
            Process mkFifoCommand = new ProcessBuilder("mkfifo", fifo.getCanonicalPath()).start();
            mkFifoCommand.waitFor();
            String testFileContent = "This is test";
            producerThread = new Thread(() -> {
                try {
                    Files.write(fifo.toPath(), "This is test".getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    Assert.fail((String)("Error when producing to fifo : " + e.getMessage()));
                }
            }, "FIFO-Producer");
            producerThread.start();
            Assert.assertEquals((Object)"This is test", (Object)Utils.readFileAsString((String)fifo.getCanonicalPath()));
        }
        finally {
            Files.deleteIfExists(fifo.toPath());
            if (producerThread != null) {
                producerThread.join(30000L);
                Assert.assertFalse((boolean)producerThread.isAlive());
            }
        }
    }

    @Test
    public void testMin() {
        Assert.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[0]));
        Assert.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[]{2L, 3L}));
        Assert.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{1L, 3L}));
        Assert.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{3L, 1L}));
    }

    @Test
    public void testCloseAll() {
        Closeable[] closeablesWithoutException = TestCloseable.createCloseables(false, false, false);
        try {
            Utils.closeAll((Closeable[])closeablesWithoutException);
            TestCloseable.checkClosed((TestCloseable[])closeablesWithoutException);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e));
        }
        Closeable[] closeablesWithException = TestCloseable.createCloseables(true, true, true);
        try {
            Utils.closeAll((Closeable[])closeablesWithException);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])closeablesWithException);
            TestCloseable.checkException(e, (TestCloseable[])closeablesWithException);
        }
        Closeable[] singleExceptionCloseables = TestCloseable.createCloseables(false, true, false);
        try {
            Utils.closeAll((Closeable[])singleExceptionCloseables);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])singleExceptionCloseables);
            TestCloseable.checkException(e, new TestCloseable[]{singleExceptionCloseables[1]});
        }
        Closeable[] mixedCloseables = TestCloseable.createCloseables(false, true, false, true, true);
        try {
            Utils.closeAll((Closeable[])mixedCloseables);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])mixedCloseables);
            TestCloseable.checkException(e, new TestCloseable[]{mixedCloseables[1], mixedCloseables[3], mixedCloseables[4]});
        }
    }

    @Test
    public void testReadFullyOrFailWithRealFile() throws IOException {
        try (FileChannel channel = FileChannel.open(TestUtils.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            String msg = "hello, world";
            channel.write(ByteBuffer.wrap(msg.getBytes()), 0L);
            channel.force(true);
            Assert.assertEquals((String)"Message should be written to the file channel", (long)channel.size(), (long)msg.length());
            ByteBuffer perfectBuffer = ByteBuffer.allocate(msg.length());
            ByteBuffer smallBuffer = ByteBuffer.allocate(5);
            ByteBuffer largeBuffer = ByteBuffer.allocate(msg.length() + 1);
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)perfectBuffer, (long)0L, (String)"perfect");
            Assert.assertFalse((String)"Buffer should be filled up", (boolean)perfectBuffer.hasRemaining());
            Assert.assertEquals((String)"Buffer should be populated correctly", (Object)msg, (Object)new String(perfectBuffer.array()));
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)smallBuffer, (long)0L, (String)"small");
            Assert.assertFalse((String)"Buffer should be filled", (boolean)smallBuffer.hasRemaining());
            Assert.assertEquals((String)"Buffer should be populated correctly", (Object)"hello", (Object)new String(smallBuffer.array()));
            smallBuffer.clear();
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)smallBuffer, (long)7L, (String)"small");
            Assert.assertFalse((String)"Buffer should be filled", (boolean)smallBuffer.hasRemaining());
            Assert.assertEquals((String)"Buffer should be populated correctly", (Object)"world", (Object)new String(smallBuffer.array()));
            try {
                Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)largeBuffer, (long)0L, (String)"large");
                Assert.fail((String)"Expected EOFException to be raised");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadFullyOrFailWithPartialFileChannelReads() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        ByteBuffer buffer = ByteBuffer.allocate(100);
        String expectedBufferContent = this.fileChannelMockExpectReadWithRandomBytes(channelMock, 100);
        Utils.readFullyOrFail((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L, (String)"test");
        Assert.assertEquals((String)"The buffer should be populated correctly", (Object)expectedBufferContent, (Object)new String(buffer.array()));
        Assert.assertFalse((String)"The buffer should be filled", (boolean)buffer.hasRemaining());
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testReadFullyWithPartialFileChannelReads() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        String expectedBufferContent = this.fileChannelMockExpectReadWithRandomBytes(channelMock, 100);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        Utils.readFully((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L);
        Assert.assertEquals((String)"The buffer should be populated correctly.", (Object)expectedBufferContent, (Object)new String(buffer.array()));
        Assert.assertFalse((String)"The buffer should be filled", (boolean)buffer.hasRemaining());
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testReadFullyIfEofIsReached() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        String fileChannelContent = "abcdefghkl";
        ByteBuffer buffer = ByteBuffer.allocate(100);
        Mockito.when((Object)channelMock.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).then(invocation -> {
            ByteBuffer bufferArg = (ByteBuffer)invocation.getArgument(0);
            bufferArg.put("abcdefghkl".getBytes());
            return -1;
        });
        Utils.readFully((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L);
        Assert.assertEquals((Object)"abcdefghkl", (Object)new String(buffer.array(), 0, buffer.position()));
        Assert.assertEquals((long)"abcdefghkl".length(), (long)buffer.position());
        Assert.assertTrue((boolean)buffer.hasRemaining());
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadProps() throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            String testContent = "a=1\nb=2\n#a comment\n\nc=3\nd=";
            Files.write(tempFile.toPath(), testContent.getBytes(), new OpenOption[0]);
            Properties props = Utils.loadProps((String)tempFile.getPath());
            Assert.assertEquals((long)4L, (long)props.size());
            Assert.assertEquals((Object)"1", (Object)props.get("a"));
            Assert.assertEquals((Object)"2", (Object)props.get("b"));
            Assert.assertEquals((Object)"3", (Object)props.get("c"));
            Assert.assertEquals((Object)"", (Object)props.get("d"));
            Properties restrictedProps = Utils.loadProps((String)tempFile.getPath(), Arrays.asList("b", "d", "e"));
            Assert.assertEquals((long)2L, (long)restrictedProps.size());
            Assert.assertEquals((Object)"2", (Object)restrictedProps.get("b"));
            Assert.assertEquals((Object)"", (Object)restrictedProps.get("d"));
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    private String fileChannelMockExpectReadWithRandomBytes(FileChannel channelMock, int bufferSize) throws IOException {
        int bytesRead;
        int step = 20;
        Random random = new Random();
        OngoingStubbing when = Mockito.when((Object)channelMock.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
        StringBuilder expectedBufferContent = new StringBuilder();
        for (int remainingBytes = bufferSize; remainingBytes > 0; remainingBytes -= bytesRead) {
            bytesRead = remainingBytes < 20 ? remainingBytes : random.nextInt(20);
            String stringRead = IntStream.range(0, bytesRead).mapToObj(i -> "a").collect(Collectors.joining());
            expectedBufferContent.append(stringRead);
            when = when.then(invocation -> {
                ByteBuffer buffer = (ByteBuffer)invocation.getArgument(0);
                buffer.put(stringRead.getBytes());
                return bytesRead;
            });
        }
        return expectedBufferContent.toString();
    }

    @Test(timeout=120000L)
    public void testRecursiveDelete() throws IOException {
        Utils.delete(null);
        File tempFile = TestUtils.tempFile();
        Utils.delete((File)tempFile);
        Assert.assertFalse((boolean)Files.exists(tempFile.toPath(), new LinkOption[0]));
        File tempDir = TestUtils.tempDirectory();
        File tempDir2 = TestUtils.tempDirectory(tempDir.toPath(), "a");
        TestUtils.tempDirectory(tempDir.toPath(), "b");
        TestUtils.tempDirectory(tempDir2.toPath(), "c");
        Utils.delete((File)tempDir);
        Assert.assertFalse((boolean)Files.exists(tempDir.toPath(), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(tempDir2.toPath(), new LinkOption[0]));
        Utils.delete((File)tempDir);
        Assert.assertFalse((boolean)Files.exists(tempDir.toPath(), new LinkOption[0]));
    }

    @Test
    public void testConvertTo32BitField() {
        Set bytes = Utils.mkSet((Object[])new Byte[]{(byte)0, (byte)1, (byte)5, (byte)10, (byte)31});
        int bitField = Utils.to32BitField((Set)bytes);
        Assert.assertEquals((Object)bytes, (Object)Utils.from32BitField((int)bitField));
        bytes = new HashSet();
        bitField = Utils.to32BitField(bytes);
        Assert.assertEquals(bytes, (Object)Utils.from32BitField((int)bitField));
        bytes = Utils.mkSet((Object[])new Byte[]{(byte)0, (byte)11, (byte)32});
        try {
            Utils.to32BitField(bytes);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class TestCloseable
    implements Closeable {
        private final int id;
        private final IOException closeException;
        private boolean closed;

        TestCloseable(int id, boolean exceptionOnClose) {
            this.id = id;
            this.closeException = exceptionOnClose ? new IOException("Test close exception " + id) : null;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.closeException != null) {
                throw this.closeException;
            }
        }

        static TestCloseable[] createCloseables(boolean ... exceptionOnClose) {
            TestCloseable[] closeables = new TestCloseable[exceptionOnClose.length];
            for (int i = 0; i < closeables.length; ++i) {
                closeables[i] = new TestCloseable(i, exceptionOnClose[i]);
            }
            return closeables;
        }

        static void checkClosed(TestCloseable ... closeables) {
            for (TestCloseable closeable : closeables) {
                Assert.assertTrue((String)("Close not invoked for " + closeable.id), (boolean)closeable.closed);
            }
        }

        static void checkException(IOException e, TestCloseable ... closeablesWithException) {
            Assert.assertEquals((Object)closeablesWithException[0].closeException, (Object)e);
            Throwable[] suppressed = e.getSuppressed();
            Assert.assertEquals((long)(closeablesWithException.length - 1), (long)suppressed.length);
            for (int i = 1; i < closeablesWithException.length; ++i) {
                Assert.assertEquals((Object)closeablesWithException[i].closeException, (Object)suppressed[i - 1]);
            }
        }
    }
}

