/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.utils.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class StickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new StickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscription(List<String> topics, List<TopicPartition> partitions) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(-1))));
    }

    @Test
    public void testAssignmentWithMultipleGenerations1() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 6);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(consumer1);
        List r1partitions2 = (List)assignment.get(consumer2);
        List r1partitions3 = (List)assignment.get(consumer3);
        Assert.assertTrue((r1partitions1.size() == 2 && r1partitions2.size() == 2 && r1partitions3.size() == 2 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(consumer1, this.buildSubscription(StickyAssignorTest.topics(this.topic), r1partitions1));
        this.subscriptions.put(consumer2, this.buildSubscription(StickyAssignorTest.topics(this.topic), r1partitions2));
        this.subscriptions.remove(consumer3);
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r2partitions1 = (List)assignment.get(consumer1);
        List r2partitions2 = (List)assignment.get(consumer2);
        Assert.assertTrue((r2partitions1.size() == 3 && r2partitions2.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r2partitions1.containsAll(r1partitions1));
        Assert.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
        Assert.assertFalse((boolean)Collections.disjoint(r2partitions2, r1partitions3));
        this.subscriptions.remove(consumer1);
        this.subscriptions.put(consumer2, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r2partitions2, 2));
        this.subscriptions.put(consumer3, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r1partitions3, 1));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r3partitions2 = (List)assignment.get(consumer2);
        List r3partitions3 = (List)assignment.get(consumer3);
        Assert.assertTrue((r3partitions2.size() == 3 && r3partitions3.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Collections.disjoint(r3partitions2, r3partitions3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testAssignmentWithMultipleGenerations2() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 6);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(consumer1);
        List r1partitions2 = (List)assignment.get(consumer2);
        List r1partitions3 = (List)assignment.get(consumer3);
        Assert.assertTrue((r1partitions1.size() == 2 && r1partitions2.size() == 2 && r1partitions3.size() == 2 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(consumer1);
        this.subscriptions.put(consumer2, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r1partitions2, 1));
        this.subscriptions.remove(consumer3);
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r2partitions2 = (List)assignment.get(consumer2);
        Assert.assertEquals((long)6L, (long)r2partitions2.size());
        Assert.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
        this.subscriptions.put(consumer1, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r1partitions1, 1));
        this.subscriptions.put(consumer2, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r2partitions2, 2));
        this.subscriptions.put(consumer3, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), r1partitions3, 1));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r3partitions1 = (List)assignment.get(consumer1);
        List r3partitions2 = (List)assignment.get(consumer2);
        List r3partitions3 = (List)assignment.get(consumer3);
        Assert.assertTrue((r3partitions1.size() == 2 && r3partitions2.size() == 2 && r3partitions3.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)r1partitions1, (Object)r3partitions1);
        Assert.assertEquals((Object)r1partitions2, (Object)r3partitions2);
        Assert.assertEquals((Object)r1partitions3, (Object)r3partitions3);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testAssignmentWithConflictingPreviousGenerations() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 6);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        TopicPartition tp3 = new TopicPartition(this.topic, 3);
        TopicPartition tp4 = new TopicPartition(this.topic, 4);
        TopicPartition tp5 = new TopicPartition(this.topic, 5);
        List<TopicPartition> c1partitions0 = StickyAssignorTest.partitions(tp0, tp1, tp4);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp0, tp1, tp2);
        List<TopicPartition> c3partitions0 = StickyAssignorTest.partitions(tp3, tp4, tp5);
        this.subscriptions.put(consumer1, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), c1partitions0, 1));
        this.subscriptions.put(consumer2, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), c2partitions0, 2));
        this.subscriptions.put(consumer3, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), c3partitions0, 2));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(consumer1);
        List c2partitions = (List)assignment.get(consumer2);
        List c3partitions = (List)assignment.get(consumer3);
        Assert.assertTrue((c1partitions.size() == 2 && c2partitions.size() == 2 && c3partitions.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        Assert.assertTrue((boolean)c3partitions0.containsAll(c3partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testSchemaBackwardCompatibility() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        List<TopicPartition> c1partitions0 = StickyAssignorTest.partitions(tp0, tp2);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp1);
        this.subscriptions.put(consumer1, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), c1partitions0, 1));
        this.subscriptions.put(consumer2, StickyAssignorTest.buildSubscriptionWithOldSchema(StickyAssignorTest.topics(this.topic), c2partitions0));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(consumer1);
        List c2partitions = (List)assignment.get(consumer2);
        List c3partitions = (List)assignment.get(consumer3);
        Assert.assertTrue((c1partitions.size() == 1 && c2partitions.size() == 1 && c3partitions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c1partitions0.containsAll(c1partitions));
        Assert.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assert.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assert.assertTrue((boolean)this.assignor.isSticky());
    }

    private ConsumerPartitionAssignor.Subscription buildSubscriptionWithGeneration(List<String> topics, List<TopicPartition> partitions, int generation) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generation))));
    }

    private static ConsumerPartitionAssignor.Subscription buildSubscriptionWithOldSchema(List<String> topics, List<TopicPartition> partitions) {
        Struct struct = new Struct(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0);
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry topicEntry : CollectionUtils.groupPartitionsByTopic(partitions).entrySet()) {
            Struct topicAssignment = new Struct(StickyAssignor.TOPIC_ASSIGNMENT);
            topicAssignment.set("topic", topicEntry.getKey());
            topicAssignment.set("partitions", (Object)((List)topicEntry.getValue()).toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set("previous_assignment", (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.sizeOf((Object)struct));
        StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.write(buffer, (Object)struct);
        buffer.flip();
        return new ConsumerPartitionAssignor.Subscription(topics, buffer);
    }
}

