/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final String topic2 = "test2";
    private final TopicPartition t2p0 = new TopicPartition("test2", 0);
    private final String topic3 = "test3";
    private final TopicPartition t3p0 = new TopicPartition("test3", 0);
    private final int sessionTimeoutMs = 10000;
    private final int heartbeatIntervalMs = 1000;
    private final int autoCommitIntervalMs = 500;
    private final String groupId = "mock-group";
    private final String memberId = "memberId";
    private final String leaderId = "leaderId";
    private final Optional<String> groupInstanceId = Optional.of("mock-instance");
    private final String partitionRevoked = "Hit partition revoke ";
    private final String partitionAssigned = "Hit partition assign ";
    private final String partitionLost = "Hit partition lost ";
    private final Collection<TopicPartition> singleTopicPartition = Collections.singleton(new TopicPartition("test", 0));

    @Test
    public void testMetricsReporterAutoGeneratedClientId() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        MockMetricsReporter mockMetricsReporter = (MockMetricsReporter)consumer.metrics.reporters().get(0);
        Assert.assertEquals((Object)consumer.getClientId(), (Object)mockMetricsReporter.clientId);
        consumer.close();
    }

    @Test
    public void testConstructorClose() {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "invalid-23-8409-adsfsdj");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
            Assert.fail((String)"should have caught an exception and returned");
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
        }
    }

    @Test
    public void testOsDefaultSocketBufferSizes() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.close();
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketSendBufferSize() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketReceiveBufferSize() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("receive.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void shouldIgnoreGroupInstanceIdForEmptyGroupId() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("group.instance.id", "instance_id");
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.close();
    }

    @Test
    public void testSubscription() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.subscribe(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopicCollection() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.subscribe((Collection)null);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopic() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.subscribe(Collections.singletonList(null));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnEmptyTopic() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            String emptyTopic = "  ";
            consumer.subscribe(Collections.singletonList(emptyTopic));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullPattern() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.subscribe((Pattern)null);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnEmptyPattern() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.subscribe(Pattern.compile(""));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testSubscriptionWithEmptyPartitionAssignment() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("partition.assignment.strategy", "");
        props.setProperty("group.id", "mock-group");
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer(props);){
            consumer.subscribe(Collections.singletonList("test"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSeekNegative() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.assign(Collections.singleton(new TopicPartition("nonExistTopic", 0)));
            consumer.seek(new TopicPartition("nonExistTopic", 0), -1L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicPartition() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.assign(null);
        }
    }

    @Test
    public void testAssignOnEmptyTopicPartition() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.assign(Collections.emptyList());
            Assert.assertTrue((boolean)consumer.subscription().isEmpty());
            Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicInPartition() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.assign(Collections.singleton(new TopicPartition(null, 0)));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnEmptyTopicInPartition() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.assign(Collections.singleton(new TopicPartition("  ", 0)));
        }
    }

    @Test
    public void testInterceptorConstructorClose() {
        try {
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)0L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            consumer.close();
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            Assert.assertNull((Object)MockConsumerInterceptor.CLUSTER_META.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    @Test
    public void testPause() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.pause(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.paused());
        consumer.resume(Collections.singleton(this.tp0));
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.close();
    }

    @Test
    public void testConsumerJmxPrefix() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        config.put("client.id", "client-1");
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        MetricName testMetricName = consumer.metrics.metricName("test-metric", "grp1", "test metric");
        consumer.metrics.addMetric(testMetricName, (Measurable)new Avg());
        Assert.assertNotNull((Object)server.getObjectInstance(new ObjectName("kafka.consumer:type=grp1,client-id=client-1")));
        consumer.close();
    }

    private KafkaConsumer<byte[], byte[]> newConsumer(String groupId) {
        return this.newConsumer(groupId, Optional.empty());
    }

    private KafkaConsumer<byte[], byte[]> newConsumer(String groupId, Optional<Boolean> enableAutoCommit) {
        Properties props = new Properties();
        props.setProperty("client.id", "my.consumer");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        if (groupId != null) {
            props.setProperty("group.id", groupId);
        }
        enableAutoCommit.ifPresent(autoCommit -> props.setProperty("enable.auto.commit", autoCommit.toString()));
        return this.newConsumer(props);
    }

    private KafkaConsumer<byte[], byte[]> newConsumer(Properties props) {
        return new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void verifyHeartbeatSent() throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 0), node);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.NONE);
        time.sleep(1000L);
        Thread.sleep(1000L);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        Assert.assertTrue((boolean)heartbeatReceived.get());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void verifyHeartbeatSentWhenFetchedDataReady() throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.NONE);
        time.sleep(1000L);
        Thread.sleep(1000L);
        consumer.poll(Duration.ZERO);
        Assert.assertTrue((boolean)heartbeatReceived.get());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void verifyPollTimesOutDuringMetadataUpdate() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.poll(Duration.ZERO);
        Queue<ClientRequest> requests = client.requests();
        Assert.assertEquals((long)0L, (long)requests.size());
    }

    @Test
    public void verifyDeprecatedPollDoesNotTimeOutDuringMetadataUpdate() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.poll(0L);
        Queue<ClientRequest> requests = client.requests();
        Assert.assertEquals((long)1L, (long)requests.size());
        Class<?> aClass = requests.peek().requestBuilder().getClass();
        Assert.assertEquals(FetchRequest.Builder.class, aClass);
    }

    @Test
    public void verifyNoCoordinatorLookupForManualAssignmentWithSeek() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.assign(Collections.singleton(this.tp0));
        consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        Assert.assertEquals((long)5L, (long)records.count());
        Assert.assertEquals((long)55L, (long)consumer.position(this.tp0));
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testFetchProgressWithMissingPartitionPosition() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        KafkaConsumer<String, String> consumer = this.newConsumerNoAutoCommit(time, client, subscription, metadata);
        consumer.assign(Arrays.asList(this.tp0, this.tp1));
        consumer.seekToEnd(Collections.singleton(this.tp0));
        consumer.seekToBeginning(Collections.singleton(this.tp1));
        client.prepareResponse(body -> {
            ListOffsetRequest request = (ListOffsetRequest)body;
            Map timestamps = request.partitionTimestamps();
            return ((ListOffsetRequest.PartitionData)timestamps.get((Object)this.tp0)).timestamp == -1L && ((ListOffsetRequest.PartitionData)timestamps.get((Object)this.tp1)).timestamp == -2L;
        }, (AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L), Collections.singletonMap(this.tp1, Errors.NOT_LEADER_OR_FOLLOWER)));
        client.prepareResponse(body -> {
            FetchRequest request = (FetchRequest)body;
            return request.fetchData().keySet().equals(Collections.singleton(this.tp0)) && ((FetchRequest.PartitionData)request.fetchData().get((Object)this.tp0)).fetchOffset == 50L;
        }, (AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        Assert.assertEquals((long)5L, (long)records.count());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)records.partitions());
    }

    private void initMetadata(MockClient mockClient, Map<String, Integer> partitionCounts) {
        MetadataResponse initialMetadata = TestUtils.metadataUpdateWith(1, partitionCounts);
        mockClient.updateMetadata(initialMetadata);
    }

    @Test(expected=NoOffsetForPartitionException.class)
    public void testMissingOffsetNoResetPolicy() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, "mock-group", this.groupInstanceId, false);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, -1L), Errors.NONE), coordinator);
        consumer.poll(Duration.ZERO);
    }

    @Test
    public void testResetToCommittedOffset() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, "mock-group", this.groupInstanceId, false);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 539L), Errors.NONE), coordinator);
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)539L, (long)consumer.position(this.tp0));
    }

    @Test
    public void testResetUsingAutoResetPolicy() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.LATEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, "mock-group", this.groupInstanceId, false);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, -1L), Errors.NONE), coordinator);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L)));
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)50L, (long)consumer.position(this.tp0));
    }

    @Test
    public void testOffsetIsValidAfterSeek() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.LATEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, "mock-group", Optional.empty(), false);
        consumer.assign(Collections.singletonList(this.tp0));
        consumer.seek(this.tp0, 20L);
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)subscription.validPosition((TopicPartition)this.tp0).offset, (long)20L);
    }

    @Test
    public void testCommitsFetchedDuringAssign() {
        long offset1 = 10000L;
        long offset2 = 20000L;
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        Assert.assertEquals((long)offset1, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        consumer.assign(Arrays.asList(this.tp0, this.tp1));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, offset1);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)offset1, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, offset2);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)offset2, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp1)).get(this.tp1)).offset());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testFetchStableOffsetThrowInCommitted() {
        Assert.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer().committed(Collections.singleton(this.tp0)));
    }

    @Test
    public void testFetchStableOffsetThrowInPoll() {
        Assert.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer().poll(Duration.ZERO));
    }

    @Test
    public void testFetchStableOffsetThrowInPosition() {
        Assert.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer().position(this.tp0));
    }

    private KafkaConsumer<String, String> setupThrowableConsumer() {
        long offset1 = 10000L;
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        client.setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.OFFSET_FETCH.id, (short)0, (short)6));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, "mock-group", this.groupInstanceId, true);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        return consumer;
    }

    @Test
    public void testNoCommittedOffsets() {
        long offset1 = 10000L;
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.assign(Arrays.asList(this.tp0, this.tp1));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.tp0, (Object)offset1), Utils.mkEntry((Object)this.tp1, (Object)-1L)}), Errors.NONE), coordinator);
        Map committed = consumer.committed(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        Assert.assertEquals((long)2L, (long)committed.size());
        Assert.assertEquals((long)offset1, (long)((OffsetAndMetadata)committed.get(this.tp0)).offset());
        Assert.assertNull(committed.get(this.tp1));
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testAutoCommitSentBeforePositionUpdate() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        time.sleep(500L);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 0L);
        consumer.poll(Duration.ZERO);
        Assert.assertTrue((boolean)commitReceived.get());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testRegexSubscription() {
        String unmatchedTopic = "unmatched";
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("test", 1);
        partitionCounts.put(unmatchedTopic, 1);
        this.initMetadata(client, partitionCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        this.prepareRebalance(client, node, Collections.singleton("test"), (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(TestUtils.metadataUpdateWith(1, partitionCounts));
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testChangingRegexSubscription() {
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        String otherTopic = "other";
        TopicPartition otherTopicPartition = new TopicPartition(otherTopic, 0);
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("test", 1);
        partitionCounts.put(otherTopic, 1);
        this.initMetadata(client, partitionCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        Node coordinator = this.prepareRebalance(client, node, Collections.singleton("test"), (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        consumer.subscribe(Pattern.compile(otherTopic), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(TestUtils.metadataUpdateWith(1, partitionCounts));
        this.prepareRebalance(client, node, Collections.singleton(otherTopic), (ConsumerPartitionAssignor)assignor, Collections.singletonList(otherTopicPartition), coordinator);
        consumer.poll(Duration.ZERO);
        Assert.assertEquals(Collections.singleton(otherTopic), (Object)consumer.subscription());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testWakeupWithFetchDataAvailable() throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        consumer.wakeup();
        Assert.assertThrows(WakeupException.class, () -> consumer.poll(Duration.ZERO));
        Assert.assertEquals((long)0L, (long)consumer.position(this.tp0));
        ConsumerRecords records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)5L, (long)records.count());
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(() -> time.sleep(10000L), 0L, 10L, TimeUnit.MILLISECONDS);
        consumer.close();
        exec.shutdownNow();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollThrowsInterruptExceptionIfInterrupted() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        try {
            Thread.currentThread().interrupt();
            Assert.assertThrows(InterruptException.class, () -> consumer.poll(Duration.ZERO));
        }
        finally {
            Thread.interrupted();
            consumer.close(Duration.ofMillis(0L));
        }
    }

    @Test
    public void fetchResponseWithUnexpectedPartitionIsIgnored() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        ConsumerRecords records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)0L, (long)records.count());
        consumer.close(Duration.ofMillis(0L));
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitEnabled() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        tpCounts.put("test3", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertEquals((long)2L, (long)consumer.subscription().size());
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)2L, (long)consumer.subscription().size());
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)consumer.assignment().size());
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        fetches1.put(this.tp0, new FetchInfo(1L, 0));
        fetches1.put(this.t2p0, new FetchInfo(10L, 0));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        Assert.assertEquals((long)11L, (long)records.count());
        Assert.assertEquals((long)1L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)10L, (long)consumer.position(this.t2p0));
        consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(consumer));
        Assert.assertEquals((long)2L, (long)consumer.subscription().size());
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)consumer.assignment().size());
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.tp0, 1L);
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t3p0), coordinator);
        HashMap<TopicPartition, FetchInfo> fetches2 = new HashMap<TopicPartition, FetchInfo>();
        fetches2.put(this.tp0, new FetchInfo(1L, 1));
        fetches2.put(this.t3p0, new FetchInfo(0L, 100));
        client.prepareResponse((AbstractResponse)this.fetchResponse(fetches2));
        records = consumer.poll(Duration.ofMillis(1L));
        Assert.assertEquals((long)101L, (long)records.count());
        Assert.assertEquals((long)2L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)100L, (long)consumer.position(this.t3p0));
        Assert.assertTrue((boolean)commitReceived.get());
        Assert.assertEquals((long)2L, (long)consumer.subscription().size());
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)consumer.assignment().size());
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t3p0) ? 1 : 0) != 0);
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitDisabled() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(consumer, this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.poll(Duration.ZERO);
        consumer.subscribe(Collections.singleton("test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertEquals(Collections.singleton("test2"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        for (ClientRequest req : client.requests()) {
            Assert.assertNotSame((Object)ApiKeys.OFFSET_COMMIT, (Object)req.requestBuilder().apiKey());
        }
        consumer.unsubscribe();
        Assert.assertEquals(Collections.emptySet(), (Object)consumer.subscription());
        Assert.assertEquals(Collections.emptySet(), (Object)consumer.assignment());
        for (ClientRequest req : client.requests()) {
            Assert.assertNotSame((Object)ApiKeys.OFFSET_COMMIT, (Object)req.requestBuilder().apiKey());
        }
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testUnsubscribeShouldTriggerPartitionsRevokedWithValidGeneration() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(consumer, this.getExceptionConsumerRebalanceListener());
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        RuntimeException assignmentException = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE)));
        Assert.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)assignmentException.getCause().getMessage());
        RuntimeException unsubscribeException = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> consumer.unsubscribe());
        Assert.assertEquals((Object)("Hit partition revoke " + this.singleTopicPartition), (Object)unsubscribeException.getCause().getMessage());
    }

    @Test
    public void testUnsubscribeShouldTriggerPartitionsLostWithNoGeneration() throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(consumer, this.getExceptionConsumerRebalanceListener());
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        RuntimeException assignException = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE)));
        Assert.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)assignException.getCause().getMessage());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.UNKNOWN_MEMBER_ID);
        time.sleep(1000L);
        TestUtils.waitForCondition(heartbeatReceived::get, "Heartbeat response did not occur within timeout.");
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        Assert.assertTrue((boolean)heartbeatReceived.get());
        RuntimeException unsubscribeException = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> consumer.unsubscribe());
        Assert.assertEquals((Object)("Hit partition lost " + this.singleTopicPartition), (Object)unsubscribeException.getCause().getMessage());
    }

    private void initializeSubscriptionWithSingleTopic(KafkaConsumer<String, String> consumer, ConsumerRebalanceListener consumerRebalanceListener) {
        consumer.subscribe(Collections.singleton("test"), consumerRebalanceListener);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.emptySet(), (Object)consumer.assignment());
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitEnabled() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Collections.singleton(this.tp0));
        consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        Assert.assertEquals((Object)consumer.assignment(), Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 11L);
        consumer.assign(Collections.singleton(this.t2p0));
        Assert.assertEquals((Object)consumer.assignment(), Collections.singleton(this.t2p0));
        Assert.assertTrue((boolean)commitReceived.get());
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitDisabled() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Collections.singleton(this.tp0));
        consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        Assert.assertEquals((Object)consumer.assignment(), Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        consumer.assign(Collections.singleton(this.t2p0));
        Assert.assertEquals((Object)consumer.assignment(), Collections.singleton(this.t2p0));
        for (ClientRequest req : client.requests()) {
            Assert.assertNotSame((Object)req.requestBuilder().apiKey(), (Object)ApiKeys.OFFSET_COMMIT);
        }
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testOffsetOfPausedPartitions() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        Set partitions = Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1});
        consumer.assign((Collection)partitions);
        Assert.assertEquals((Object)partitions, (Object)consumer.assignment());
        consumer.pause((Collection)partitions);
        consumer.seekToEnd((Collection)partitions);
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, 0L);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp1)).get(this.tp1)).offset());
        HashMap<TopicPartition, Long> offsetResponse = new HashMap<TopicPartition, Long>();
        offsetResponse.put(this.tp0, 3L);
        offsetResponse.put(this.tp1, 3L);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(offsetResponse));
        Assert.assertEquals((long)3L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)3L, (long)consumer.position(this.tp1));
        client.requests().clear();
        consumer.unsubscribe();
        consumer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void testPollWithNoSubscription() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.poll(Duration.ZERO);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptySubscription() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.subscribe(Collections.emptyList());
            consumer.poll(Duration.ZERO);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptyUserAssignment() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer("mock-group");){
            consumer.assign(Collections.emptySet());
            consumer.poll(Duration.ZERO);
        }
    }

    @Test
    public void testGracefulClose() throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()));
        this.consumerCloseTest(5000L, Arrays.asList(commitResponse, leaveGroupResponse), 0L, false);
    }

    @Test
    public void testCloseTimeout() throws Exception {
        this.consumerCloseTest(5000L, Collections.emptyList(), 5000L, false);
    }

    @Test
    public void testLeaveGroupTimeout() throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        this.consumerCloseTest(5000L, Collections.singletonList(commitResponse), 5000L, false);
    }

    @Test
    public void testCloseNoWait() throws Exception {
        this.consumerCloseTest(0L, Collections.emptyList(), 0L, false);
    }

    @Test
    public void testCloseInterrupt() throws Exception {
        this.consumerCloseTest(Long.MAX_VALUE, Collections.emptyList(), 0L, true);
    }

    @Test
    public void testCloseShouldBeIdempotent() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);
        consumer.close();
        consumer.close();
        consumer.close();
    }

    @Test
    public void testOperationsBySubscribingConsumerWithDefaultGroupId() {
        try {
            this.newConsumer(null, Optional.of(Boolean.TRUE));
            Assert.fail((String)"Expected an InvalidConfigurationException");
        }
        catch (KafkaException e) {
            Assert.assertEquals(InvalidConfigurationException.class, e.getCause().getClass());
        }
        try {
            this.newConsumer((String)null).subscribe(Collections.singleton("test"));
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            this.newConsumer((String)null).committed(Collections.singleton(this.tp0)).get(this.tp0);
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            this.newConsumer((String)null).commitAsync();
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            this.newConsumer((String)null).commitSync();
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
    }

    @Test
    public void testOperationsByAssigningConsumerWithDefaultGroupId() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);
        consumer.assign(Collections.singleton(this.tp0));
        try {
            consumer.committed(Collections.singleton(this.tp0)).get(this.tp0);
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            consumer.commitAsync();
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            consumer.commitSync();
            Assert.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
    }

    @Test
    public void testMetricConfigRecordingLevel() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9000");
        try (KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            Assert.assertEquals((Object)Sensor.RecordingLevel.INFO, (Object)consumer.metrics.config().recordLevel());
        }
        props.put("metrics.recording.level", "DEBUG");
        consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        var3_3 = null;
        try {
            Assert.assertEquals((Object)Sensor.RecordingLevel.DEBUG, (Object)consumer.metrics.config().recordLevel());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (consumer != null) {
                if (var3_3 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    consumer.close();
                }
            }
        }
    }

    @Test
    public void testShouldAttemptToRejoinGroupAfterSyncGroupFailed() throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse((ConsumerPartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        consumer.poll(Duration.ZERO);
        client.prepareResponseFrom(body -> true, (AbstractResponse)new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code())), coordinator);
        ByteBuffer byteBuffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("test")));
        JoinGroupResponse leaderResponse = new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(1).setProtocolName(assignor.name()).setLeader("memberId").setMemberId("memberId").setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId").setMetadata(byteBuffer.array()))));
        client.prepareResponseFrom((AbstractResponse)leaderResponse, coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator, true);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse((ConsumerPartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom(body -> body instanceof FetchRequest && ((FetchRequest)body).fetchData().containsKey(this.tp0), (AbstractResponse)this.fetchResponse(this.tp0, 1L, 1), node);
        time.sleep(1000L);
        Thread.sleep(1000L);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        ConsumerRecords records = consumer.poll(Duration.ZERO);
        Assert.assertFalse((boolean)records.isEmpty());
        consumer.close(Duration.ofMillis(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerCloseTest(long closeTimeoutMs, List<? extends AbstractResponse> responses, long waitMs, boolean interrupt) throws Exception {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, Optional.empty());
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        client.prepareMetadataUpdate(TestUtils.metadataUpdateWith(1, Collections.singletonMap("test", 1)));
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        consumer.poll(Duration.ZERO);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AtomicReference closeException = new AtomicReference();
        try {
            Future<?> future = executor.submit(() -> {
                consumer.commitAsync();
                try {
                    consumer.close(Duration.ofMillis(closeTimeoutMs));
                }
                catch (Exception e) {
                    closeException.set(e);
                }
            });
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                if (closeTimeoutMs != 0L) {
                    Assert.fail((String)"Close completed without waiting for commit or leave response");
                }
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            client.waitForRequests(2, 1000L);
            for (int i = 0; i < responses.size(); ++i) {
                client.waitForRequests(1, 1000L);
                client.respondFrom(responses.get(i), coordinator);
                if (i == responses.size() - 1) continue;
                try {
                    future.get(100L, TimeUnit.MILLISECONDS);
                    Assert.fail((String)"Close completed without waiting for response");
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
            if (waitMs > 0L) {
                time.sleep(waitMs);
            }
            if (interrupt) {
                Assert.assertTrue((String)"Close terminated prematurely", (boolean)future.cancel(true));
                TestUtils.waitForCondition(() -> closeException.get() != null, "InterruptException did not occur within timeout.");
                Assert.assertTrue((String)("Expected exception not thrown " + closeException), (boolean)(closeException.get() instanceof InterruptException));
            } else {
                future.get(500L, TimeUnit.MILLISECONDS);
                Assert.assertNull((String)"Unexpected exception during close", closeException.get());
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test(expected=AuthenticationException.class)
    public void testPartitionsForAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.partitionsFor("some other topic");
    }

    @Test(expected=AuthenticationException.class)
    public void testBeginningOffsetsAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.beginningOffsets(Collections.singleton(this.tp0));
    }

    @Test(expected=AuthenticationException.class)
    public void testEndOffsetsAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.endOffsets(Collections.singleton(this.tp0));
    }

    @Test(expected=AuthenticationException.class)
    public void testPollAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.subscribe(Collections.singleton("test"));
        consumer.poll(Duration.ZERO);
    }

    @Test(expected=AuthenticationException.class)
    public void testOffsetsForTimesAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.offsetsForTimes(Collections.singletonMap(this.tp0, 0L));
    }

    @Test(expected=AuthenticationException.class)
    public void testCommitSyncAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(this.tp0, new OffsetAndMetadata(10L));
        consumer.commitSync(offsets);
    }

    @Test(expected=AuthenticationException.class)
    public void testCommittedAuthenticationFailure() {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError();
        consumer.committed(Collections.singleton(this.tp0)).get(this.tp0);
    }

    @Test
    public void testRebalanceException() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getExceptionConsumerRebalanceListener());
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse((ConsumerPartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        try {
            consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
            Assert.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            Assert.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)e.getCause().getMessage());
        }
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)subscription.assignedPartitions());
        try {
            consumer.close(Duration.ofMillis(0L));
            Assert.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            Assert.assertEquals((Object)("Hit partition revoke " + this.singleTopicPartition), (Object)e.getCause().getCause().getMessage());
        }
        consumer.close(Duration.ofMillis(0L));
        Assert.assertTrue((boolean)subscription.assignedPartitions().isEmpty());
    }

    @Test
    public void testReturnRecordsDuringRebalance() {
        MockTime time = new MockTime(1L);
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        this.initMetadata(client, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test", (Object)1), Utils.mkEntry((Object)"test2", (Object)1), Utils.mkEntry((Object)"test3", (Object)1)}));
        consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(consumer));
        Node node = (Node)metadata.fetch().nodes().get(0);
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test2"}), (Object)consumer.subscription());
        Assert.assertEquals(Collections.emptySet(), (Object)consumer.assignment());
        consumer.poll(Duration.ofMillis(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t2p0}), (Object)consumer.assignment());
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        ConsumerRecords records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)11L, (long)records.count());
        Assert.assertEquals((long)1L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)10L, (long)consumer.position(this.t2p0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(1L, 1));
        fetches1.put(this.t2p0, new FetchInfo(10L, 20));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(consumer));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t2p0}), (Object)consumer.assignment());
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        records = consumer.poll(Duration.ZERO);
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(2L, 1));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)2L, (long)consumer.position(this.tp0));
        Assert.assertTrue((boolean)commitReceived.get());
        client.respondFrom((AbstractResponse)this.joinGroupFollowerResponse((ConsumerPartitionAssignor)assignor, 2, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Arrays.asList(this.tp0, this.t3p0), Errors.NONE), coordinator);
        records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)3L, (long)consumer.position(this.tp0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(3L, 1));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t3p0}), (Object)consumer.assignment());
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)4L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)0L, (long)consumer.position(this.t3p0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(4L, 1));
        fetches1.put(this.t3p0, new FetchInfo(0L, 100));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        records = consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)101L, (long)records.count());
        Assert.assertEquals((long)5L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)100L, (long)consumer.position(this.t3p0));
        client.requests().clear();
        consumer.unsubscribe();
        consumer.close();
    }

    @Test
    public void testGetGroupMetadata() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        ConsumerGroupMetadata groupMetadataOnStart = consumer.groupMetadata();
        Assert.assertEquals((Object)"mock-group", (Object)groupMetadataOnStart.groupId());
        Assert.assertEquals((Object)"", (Object)groupMetadataOnStart.memberId());
        Assert.assertEquals((long)-1L, (long)groupMetadataOnStart.generationId());
        Assert.assertEquals(this.groupInstanceId, (Object)groupMetadataOnStart.groupInstanceId());
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 0), node);
        consumer.updateAssignmentMetadataIfNeeded(time.timer(Long.MAX_VALUE));
        ConsumerGroupMetadata groupMetadataAfterPoll = consumer.groupMetadata();
        Assert.assertEquals((Object)"mock-group", (Object)groupMetadataAfterPoll.groupId());
        Assert.assertEquals((Object)"memberId", (Object)groupMetadataAfterPoll.memberId());
        Assert.assertEquals((long)1L, (long)groupMetadataAfterPoll.generationId());
        Assert.assertEquals(this.groupInstanceId, (Object)groupMetadataAfterPoll.groupInstanceId());
    }

    private KafkaConsumer<String, String> consumerWithPendingAuthenticationError() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        client.createPendingAuthenticationError(node, 0L);
        return this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
    }

    private ConsumerRebalanceListener getConsumerRebalanceListener(final KafkaConsumer<String, String> consumer) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        };
    }

    private ConsumerRebalanceListener getExceptionConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition revoke " + partitions);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition assign " + partitions);
            }

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition lost " + partitions);
            }
        };
    }

    private ConsumerMetadata createMetadata(SubscriptionState subscription) {
        return new ConsumerMetadata(0L, Long.MAX_VALUE, false, false, subscription, new LogContext(), new ClusterResourceListeners());
    }

    private Node prepareRebalance(MockClient client, Node node, Set<String> subscribedTopics, ConsumerPartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom(body -> {
            JoinGroupRequest joinGroupRequest = (JoinGroupRequest)body;
            Iterator protocolIterator = joinGroupRequest.data().protocols().iterator();
            Assert.assertTrue((boolean)protocolIterator.hasNext());
            ByteBuffer protocolMetadata = ByteBuffer.wrap(((JoinGroupRequestData.JoinGroupRequestProtocol)protocolIterator.next()).metadata());
            ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)protocolMetadata);
            return subscribedTopics.equals(new HashSet(subscription.topics()));
        }, (AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private Node prepareRebalance(MockClient client, Node node, ConsumerPartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private AtomicBoolean prepareHeartbeatResponse(MockClient client, Node coordinator, Errors error) {
        AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(body -> {
            heartbeatReceived.set(true);
            return true;
        }, (AbstractResponse)new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(error.code())), coordinator);
        return heartbeatReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, Map<TopicPartition, Long> partitionOffsets) {
        AtomicBoolean commitReceived = new AtomicBoolean(true);
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitionOffsets.keySet()) {
            response.put(partition, Errors.NONE);
        }
        client.prepareResponseFrom(body -> {
            OffsetCommitRequest commitRequest = (OffsetCommitRequest)body;
            Map commitErrors = commitRequest.offsets();
            for (Map.Entry partitionOffset : partitionOffsets.entrySet()) {
                if (((Long)commitErrors.get(partitionOffset.getKey())).equals(partitionOffset.getValue())) continue;
                commitReceived.set(false);
                return false;
            }
            return true;
        }, (AbstractResponse)this.offsetCommitResponse(response), coordinator);
        return commitReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, TopicPartition partition, long offset) {
        return this.prepareOffsetCommitResponse(client, coordinator, Collections.singletonMap(partition, offset));
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private JoinGroupResponse joinGroupFollowerResponse(ConsumerPartitionAssignor assignor, int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName(assignor.name()).setLeader(leaderId).setMemberId(memberId).setMembers(Collections.emptyList()));
    }

    private SyncGroupResponse syncGroupResponse(List<TopicPartition> partitions, Errors error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(error.code()).setAssignment(Utils.toArray((ByteBuffer)buf)));
    }

    private OffsetFetchResponse offsetResponse(Map<TopicPartition, Long> offsets, Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
            partitionData.put(entry.getKey(), new OffsetFetchResponse.PartitionData(entry.getValue().longValue(), Optional.empty(), "", error));
        }
        return new OffsetFetchResponse(Errors.NONE, partitionData);
    }

    private ListOffsetResponse listOffsetsResponse(Map<TopicPartition, Long> offsets) {
        return this.listOffsetsResponse(offsets, Collections.emptyMap());
    }

    private ListOffsetResponse listOffsetsResponse(Map<TopicPartition, Long> partitionOffsets, Map<TopicPartition, Errors> partitionErrors) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> partitionData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
            partitionData.put(entry.getKey(), new ListOffsetResponse.PartitionData(Errors.NONE, -1L, entry.getValue().longValue(), Optional.empty()));
        }
        for (Map.Entry<TopicPartition, Long> entry : partitionErrors.entrySet()) {
            partitionData.put(entry.getKey(), new ListOffsetResponse.PartitionData((Errors)entry.getValue(), -1L, -1L, Optional.empty()));
        }
        return new ListOffsetResponse(partitionData);
    }

    private FetchResponse<MemoryRecords> fetchResponse(Map<TopicPartition, FetchInfo> fetches) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> tpResponses = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, FetchInfo> fetchEntry : fetches.entrySet()) {
            MemoryRecords records;
            TopicPartition partition = fetchEntry.getKey();
            long fetchOffset = fetchEntry.getValue().offset;
            int fetchCount = fetchEntry.getValue().count;
            if (fetchCount == 0) {
                records = MemoryRecords.EMPTY;
            } else {
                MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)fetchOffset);
                for (int i = 0; i < fetchCount; ++i) {
                    builder.append(0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
                }
                records = builder.build();
            }
            tpResponses.put(partition, new FetchResponse.PartitionData(Errors.NONE, 0L, -1L, 0L, null, (BaseRecords)records));
        }
        return new FetchResponse(Errors.NONE, tpResponses, 0, 0);
    }

    private FetchResponse fetchResponse(TopicPartition partition, long fetchOffset, int count) {
        FetchInfo fetchInfo = new FetchInfo(fetchOffset, count);
        return this.fetchResponse(Collections.singletonMap(partition, fetchInfo));
    }

    private KafkaConsumer<String, String> newConsumer(Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata, ConsumerPartitionAssignor assignor, boolean autoCommitEnabled, Optional<String> groupInstanceId) {
        return this.newConsumer(time, client, subscription, metadata, assignor, autoCommitEnabled, "mock-group", groupInstanceId, false);
    }

    private KafkaConsumer<String, String> newConsumerNoAutoCommit(Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata) {
        return this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)new RangeAssignor(), false, "mock-group", this.groupInstanceId, false);
    }

    private KafkaConsumer<String, String> newConsumer(Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata, ConsumerPartitionAssignor assignor, boolean autoCommitEnabled, String groupId, Optional<String> groupInstanceId, boolean throwOnStableOffsetNotSupported) {
        String clientId = "mock-consumer";
        String metricGroupPrefix = "consumer";
        long retryBackoffMs = 100L;
        int requestTimeoutMs = 30000;
        int defaultApiTimeoutMs = 30000;
        int minBytes = 1;
        int maxBytes = Integer.MAX_VALUE;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        int rebalanceTimeoutMs = 60000;
        StringDeserializer keyDeserializer = new StringDeserializer();
        StringDeserializer valueDeserializer = new StringDeserializer();
        List<ConsumerPartitionAssignor> assignors = Collections.singletonList(assignor);
        ConsumerInterceptors interceptors = new ConsumerInterceptors(Collections.emptyList());
        Metrics metrics = new Metrics(time);
        ConsumerMetrics metricsRegistry = new ConsumerMetrics(metricGroupPrefix);
        LogContext loggerFactory = new LogContext();
        ConsumerNetworkClient consumerClient = new ConsumerNetworkClient(loggerFactory, client, (Metadata)metadata, time, retryBackoffMs, requestTimeoutMs, 1000);
        GroupRebalanceConfig rebalanceConfig = new GroupRebalanceConfig(10000, rebalanceTimeoutMs, 1000, groupId, groupInstanceId, retryBackoffMs, true);
        ConsumerCoordinator consumerCoordinator = new ConsumerCoordinator(rebalanceConfig, loggerFactory, consumerClient, assignors, metadata, subscription, metrics, metricGroupPrefix, time, autoCommitEnabled, 500, interceptors, throwOnStableOffsetNotSupported);
        Fetcher fetcher = new Fetcher(loggerFactory, consumerClient, minBytes, maxBytes, maxWaitMs, fetchSize, maxPollRecords, checkCrcs, "", (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, metadata, subscription, metrics, metricsRegistry.fetcherMetrics, time, retryBackoffMs, (long)requestTimeoutMs, IsolationLevel.READ_UNCOMMITTED, new ApiVersions());
        return new KafkaConsumer(loggerFactory, clientId, consumerCoordinator, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, fetcher, interceptors, time, consumerClient, metrics, subscription, metadata, retryBackoffMs, (long)requestTimeoutMs, defaultApiTimeoutMs, assignors, groupId);
    }

    @Test
    public void testCloseWithTimeUnit() {
        KafkaConsumer consumer = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
        ((KafkaConsumer)Mockito.doCallRealMethod().when((Object)consumer)).close(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        consumer.close(1L, TimeUnit.SECONDS);
        ((KafkaConsumer)Mockito.verify((Object)consumer)).close(Duration.ofSeconds(1L));
    }

    @Test(expected=InvalidTopicException.class)
    public void testSubscriptionOnInvalidTopic() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Cluster cluster = metadata.fetch();
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        String invalidTopicName = "topic abc";
        ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.INVALID_TOPIC_EXCEPTION, invalidTopicName, false, Collections.emptyList()));
        MetadataResponse updateResponse = MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), topicMetadata);
        client.prepareMetadataUpdate(updateResponse);
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton(invalidTopicName), this.getConsumerRebalanceListener(consumer));
        consumer.poll(Duration.ZERO);
    }

    @Test
    public void testPollTimeMetrics() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"));
        Metrics metrics = consumer.metrics;
        MetricName lastPollSecondsAgoName = metrics.metricName("last-poll-seconds-ago", "consumer-metrics");
        MetricName timeBetweenPollAvgName = metrics.metricName("time-between-poll-avg", "consumer-metrics");
        MetricName timeBetweenPollMaxName = metrics.metricName("time-between-poll-max", "consumer-metrics");
        Assert.assertEquals((Object)-1.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assert.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assert.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assert.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assert.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        time.sleep(5000L);
        Assert.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)2500.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assert.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        time.sleep(10000L);
        Assert.assertEquals((Object)10.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assert.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        time.sleep(5000L);
        Assert.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assert.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
    }

    @Test
    public void testPollIdleRatio() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        Metrics metrics = consumer.metrics;
        MetricName pollIdleRatio = metrics.metricName("poll-idle-ratio-avg", "consumer-metrics");
        Assert.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        consumer.kafkaConsumerMetrics.recordPollStart(time.milliseconds());
        time.sleep(50L);
        consumer.kafkaConsumerMetrics.recordPollEnd(time.milliseconds());
        Assert.assertEquals((Object)1.0, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        time.sleep(50L);
        consumer.kafkaConsumerMetrics.recordPollStart(time.milliseconds());
        consumer.kafkaConsumerMetrics.recordPollEnd(time.milliseconds());
        Assert.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        time.sleep(25L);
        consumer.kafkaConsumerMetrics.recordPollStart(time.milliseconds());
        time.sleep(25L);
        consumer.kafkaConsumerMetrics.recordPollEnd(time.milliseconds());
        Assert.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
    }

    private static boolean consumerMetricPresent(KafkaConsumer consumer, String name) {
        MetricName metricName = new MetricName(name, "consumer-metrics", "", Collections.emptyMap());
        return consumer.metrics.metrics().containsKey(metricName);
    }

    @Test
    public void testClosingConsumerUnregistersConsumerMetrics() {
        MockTime time = new MockTime();
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)new RoundRobinAssignor(), true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assert.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assert.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-max"));
        consumer.close();
        Assert.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assert.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assert.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-max"));
    }

    @Test(expected=IllegalStateException.class)
    public void testEnforceRebalanceWithManualAssignment() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer((String)null);){
            consumer.assign(Collections.singleton(new TopicPartition("topic", 0)));
            consumer.enforceRebalance();
        }
    }

    @Test
    public void testEnforceRebalanceTriggersRebalanceOnNextPoll() {
        MockTime time = new MockTime(1L);
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        MockRebalanceListener countingRebalanceListener = new MockRebalanceListener();
        this.initMetadata(client, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test", (Object)1), Utils.mkEntry((Object)"test2", (Object)1), Utils.mkEntry((Object)"test3", (Object)1)}));
        consumer.subscribe(Arrays.asList("test", "test2"), (ConsumerRebalanceListener)countingRebalanceListener);
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.poll(Duration.ZERO);
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)countingRebalanceListener.revokedCount, (long)0L);
        Assert.assertEquals((long)countingRebalanceListener.assignedCount, (long)1L);
        consumer.enforceRebalance();
        consumer.poll(Duration.ZERO);
        Assert.assertEquals((long)countingRebalanceListener.revokedCount, (long)1L);
    }

    private static class FetchInfo {
        long offset;
        int count;

        FetchInfo(long offset, int count) {
            this.offset = offset;
            this.count = count;
        }
    }
}

