/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.AddressChangeHostResolver;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.DefaultHostResolver;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class ClientUtilsTest {
    private final HostResolver hostResolver = new DefaultHostResolver();

    @Test
    public void testParseAndValidateAddresses() throws UnknownHostException {
        this.checkWithoutLookup("127.0.0.1:8000");
        this.checkWithoutLookup("localhost:8080");
        this.checkWithoutLookup("[::1]:8000");
        this.checkWithoutLookup("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "localhost:10000");
        List<InetSocketAddress> validatedAddresses = this.checkWithoutLookup("localhost:10000");
        Assert.assertEquals((long)1L, (long)validatedAddresses.size());
        InetSocketAddress onlyAddress = validatedAddresses.get(0);
        Assert.assertEquals((Object)"localhost", (Object)onlyAddress.getHostName());
        Assert.assertEquals((long)10000L, (long)onlyAddress.getPort());
    }

    @Test
    public void testParseAndValidateAddressesWithReverseLookup() {
        this.checkWithoutLookup("127.0.0.1:8000");
        this.checkWithoutLookup("localhost:8080");
        this.checkWithoutLookup("[::1]:8000");
        this.checkWithoutLookup("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "localhost:10000");
        List<InetSocketAddress> validatedAddresses = this.checkWithLookup(Arrays.asList("example.com:10000"));
        Assert.assertTrue((String)("Unexpected addresses " + validatedAddresses), (validatedAddresses.size() >= 1 ? 1 : 0) != 0);
        List validatedHostNames = validatedAddresses.stream().map(InetSocketAddress::getHostName).collect(Collectors.toList());
        List<String> expectedHostNames = Arrays.asList("93.184.216.34", "2606:2800:220:1:248:1893:25c8:1946");
        Assert.assertTrue((String)("Unexpected addresses " + validatedHostNames), (boolean)expectedHostNames.containsAll(validatedHostNames));
        validatedAddresses.forEach(address -> Assert.assertEquals((long)10000L, (long)address.getPort()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConfig() {
        ClientUtils.parseAndValidateAddresses(Arrays.asList("localhost:10000"), (String)"random.value");
    }

    @Test(expected=ConfigException.class)
    public void testNoPort() {
        this.checkWithoutLookup("127.0.0.1");
    }

    @Test(expected=ConfigException.class)
    public void testOnlyBadHostname() {
        this.checkWithoutLookup("some.invalid.hostname.foo.bar.local:9999");
    }

    @Test
    public void testFilterPreferredAddresses() throws UnknownHostException {
        InetAddress ipv4 = InetAddress.getByName("192.0.0.1");
        InetAddress ipv6 = InetAddress.getByName("::1");
        InetAddress[] ipv4First = new InetAddress[]{ipv4, ipv6, ipv4};
        List result = ClientUtils.filterPreferredAddresses((InetAddress[])ipv4First);
        Assert.assertTrue((boolean)result.contains(ipv4));
        Assert.assertFalse((boolean)result.contains(ipv6));
        Assert.assertEquals((long)2L, (long)result.size());
        InetAddress[] ipv6First = new InetAddress[]{ipv6, ipv4, ipv4};
        result = ClientUtils.filterPreferredAddresses((InetAddress[])ipv6First);
        Assert.assertTrue((boolean)result.contains(ipv6));
        Assert.assertFalse((boolean)result.contains(ipv4));
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testResolveUnknownHostException() {
        Assert.assertThrows(UnknownHostException.class, () -> ClientUtils.resolve((String)"some.invalid.hostname.foo.bar.local", (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS, (HostResolver)this.hostResolver));
    }

    @Test
    public void testResolveDnsLookup() throws UnknownHostException {
        Assert.assertEquals((long)1L, (long)this.resolveToTwoIps(ClientDnsLookup.DEFAULT).size());
    }

    @Test
    public void testResolveDnsLookupAllIps() throws UnknownHostException {
        Assert.assertEquals((long)2L, (long)this.resolveToTwoIps(ClientDnsLookup.USE_ALL_DNS_IPS).size());
    }

    @Test
    public void testResolveDnsLookupResolveCanonicalBootstrapServers() throws UnknownHostException {
        Assert.assertEquals((long)2L, (long)this.resolveToTwoIps(ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY).size());
    }

    private List<InetAddress> resolveToTwoIps(ClientDnsLookup dnsLookup) throws UnknownHostException {
        InetAddress[] addresses = new InetAddress[]{InetAddress.getByName("198.51.100.0"), InetAddress.getByName("198.51.100.5")};
        AddressChangeHostResolver hostResolver = new AddressChangeHostResolver(addresses, addresses);
        return ClientUtils.resolve((String)"kafka.apache.org", (ClientDnsLookup)dnsLookup, (HostResolver)hostResolver);
    }

    private List<InetSocketAddress> checkWithoutLookup(String ... url) {
        return ClientUtils.parseAndValidateAddresses(Arrays.asList(url), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS);
    }

    private List<InetSocketAddress> checkWithLookup(List<String> url) {
        return ClientUtils.parseAndValidateAddresses(url, (ClientDnsLookup)ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY);
    }
}

