/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetRequestData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;

public class ListOffsetRequestTest {
    @Test
    public void testDuplicatePartitions() {
        List<ListOffsetRequestData.ListOffsetTopic> topics = Collections.singletonList(new ListOffsetRequestData.ListOffsetTopic().setName("topic").setPartitions(Arrays.asList(new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(0), new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(0))));
        ListOffsetRequestData data = new ListOffsetRequestData().setTopics(topics).setReplicaId(-1);
        ListOffsetRequest request = new ListOffsetRequest(data.toStruct((short)0), 0);
        Assert.assertEquals(Collections.singleton(new TopicPartition("topic", 0)), (Object)request.duplicatePartitions());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = 1; version <= ApiKeys.LIST_OFFSETS.latestVersion(); version = (short)(version + 1)) {
            List<ListOffsetRequestData.ListOffsetTopic> topics = Arrays.asList(new ListOffsetRequestData.ListOffsetTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(0))));
            ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_COMMITTED).setTargetTimes(topics).build(version);
            ListOffsetResponse response = (ListOffsetResponse)request.getErrorResponse(0, (Throwable)Errors.NOT_LEADER_OR_FOLLOWER.exception());
            List<ListOffsetResponseData.ListOffsetTopicResponse> v = Collections.singletonList(new ListOffsetResponseData.ListOffsetTopicResponse().setName("topic").setPartitions(Collections.singletonList(new ListOffsetResponseData.ListOffsetPartitionResponse().setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setLeaderEpoch(-1).setOffset(-1L).setPartitionIndex(0).setTimestamp(-1L))));
            ListOffsetResponseData data = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(v);
            ListOffsetResponse expectedResponse = new ListOffsetResponse(data);
            Assert.assertEquals(expectedResponse.data().topics(), response.data().topics());
            Assert.assertEquals((long)expectedResponse.throttleTimeMs(), (long)response.throttleTimeMs());
        }
    }

    @Test
    public void testGetErrorResponseV0() {
        List<ListOffsetRequestData.ListOffsetTopic> topics = Arrays.asList(new ListOffsetRequestData.ListOffsetTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(0))));
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(topics).build((short)0);
        ListOffsetResponse response = (ListOffsetResponse)request.getErrorResponse(0, (Throwable)Errors.NOT_LEADER_OR_FOLLOWER.exception());
        List<ListOffsetResponseData.ListOffsetTopicResponse> v = Collections.singletonList(new ListOffsetResponseData.ListOffsetTopicResponse().setName("topic").setPartitions(Collections.singletonList(new ListOffsetResponseData.ListOffsetPartitionResponse().setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setOldStyleOffsets(Collections.emptyList()).setPartitionIndex(0))));
        ListOffsetResponseData data = new ListOffsetResponseData().setThrottleTimeMs(0).setTopics(v);
        ListOffsetResponse expectedResponse = new ListOffsetResponse(data);
        Assert.assertEquals(expectedResponse.data().topics(), response.data().topics());
        Assert.assertEquals((long)expectedResponse.throttleTimeMs(), (long)response.throttleTimeMs());
    }

    @Test
    public void testToListOffsetTopics() {
        ListOffsetRequestData.ListOffsetPartition lop0 = new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(0).setCurrentLeaderEpoch(1).setMaxNumOffsets(2).setTimestamp(123L);
        ListOffsetRequestData.ListOffsetPartition lop1 = new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(1).setCurrentLeaderEpoch(3).setMaxNumOffsets(4).setTimestamp(567L);
        HashMap<TopicPartition, ListOffsetRequestData.ListOffsetPartition> timestampsToSearch = new HashMap<TopicPartition, ListOffsetRequestData.ListOffsetPartition>();
        timestampsToSearch.put(new TopicPartition("topic", 0), lop0);
        timestampsToSearch.put(new TopicPartition("topic", 1), lop1);
        List listOffsetTopics = ListOffsetRequest.toListOffsetTopics(timestampsToSearch);
        Assert.assertEquals((long)1L, (long)listOffsetTopics.size());
        ListOffsetRequestData.ListOffsetTopic topic = (ListOffsetRequestData.ListOffsetTopic)listOffsetTopics.get(0);
        Assert.assertEquals((Object)"topic", (Object)topic.name());
        Assert.assertEquals((long)2L, (long)topic.partitions().size());
        Assert.assertTrue((boolean)topic.partitions().contains(lop0));
        Assert.assertTrue((boolean)topic.partitions().contains(lop1));
    }
}

