/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.DefaultRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordMetadataTest {
    @Test
    public void testConstructionWithMissingRelativeOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        Long checksum = 908923L;
        RecordMetadata metadata = new RecordMetadata(tp, -1L, -1L, timestamp, checksum, keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertFalse((boolean)metadata.hasOffset());
        Assertions.assertEquals((long)-1L, (long)metadata.offset());
        Assertions.assertEquals((long)checksum, (long)metadata.checksum());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
    }

    @Test
    public void testConstructionWithRelativeOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        long baseOffset = 15L;
        long relativeOffset = 3L;
        Long checksum = 908923L;
        RecordMetadata metadata = new RecordMetadata(tp, baseOffset, relativeOffset, timestamp, checksum, keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertEquals((long)(baseOffset + relativeOffset), (long)metadata.offset());
        Assertions.assertEquals((long)checksum, (long)metadata.checksum());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
    }

    @Test
    public void testNullChecksum() {
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        RecordMetadata metadata = new RecordMetadata(new TopicPartition("foo", 0), 15L, 3L, timestamp, null, keySize, valueSize);
        Assertions.assertEquals((long)DefaultRecord.computePartialChecksum((long)timestamp, (int)keySize, (int)valueSize), (long)metadata.checksum());
    }
}

