/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class KafkaFutureTest {
    @Test
    public void testCompleteFutures() throws Exception {
        KafkaFutureImpl future123 = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)future123.complete((Object)123));
        Assertions.assertEquals((Integer)123, (Integer)((Integer)future123.get()));
        Assertions.assertFalse((boolean)future123.complete((Object)456));
        Assertions.assertTrue((boolean)future123.isDone());
        Assertions.assertFalse((boolean)future123.isCancelled());
        Assertions.assertFalse((boolean)future123.isCompletedExceptionally());
        KafkaFuture future456 = KafkaFuture.completedFuture((Object)456);
        Assertions.assertEquals((Integer)456, (Integer)((Integer)future456.get()));
        KafkaFutureImpl futureFail = new KafkaFutureImpl();
        futureFail.completeExceptionally((Throwable)new RuntimeException("We require more vespene gas"));
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFutureImpl)futureFail).get());
        Assertions.assertEquals(RuntimeException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)"We require more vespene gas", (Object)e.getCause().getMessage());
    }

    @Test
    public void testCompletingFutures() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        CompleterThread<String> myThread = new CompleterThread<String>(future, "You must construct additional pylons.");
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertEquals((Object)"I am ready", (Object)future.getNow((Object)"I am ready"));
        myThread.start();
        String str = (String)future.get(5L, TimeUnit.MINUTES);
        Assertions.assertEquals((Object)"You must construct additional pylons.", (Object)str);
        Assertions.assertEquals((Object)"You must construct additional pylons.", (Object)future.getNow((Object)"I am ready"));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertFalse((boolean)future.isCancelled());
        myThread.join();
        Assertions.assertNull((Object)myThread.testException);
    }

    @Test
    public void testThenApply() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture doubledFuture = future.thenApply(integer -> 2 * integer);
        Assertions.assertFalse((boolean)doubledFuture.isDone());
        KafkaFuture tripledFuture = future.thenApply(integer -> 3 * integer);
        Assertions.assertFalse((boolean)tripledFuture.isDone());
        future.complete((Object)21);
        Assertions.assertEquals((Integer)21, (Integer)((Integer)future.getNow((Object)-1)));
        Assertions.assertEquals((Integer)42, (Integer)((Integer)doubledFuture.getNow((Object)-1)));
        Assertions.assertEquals((Integer)63, (Integer)((Integer)tripledFuture.getNow((Object)-1)));
        KafkaFuture quadrupledFuture = future.thenApply(integer -> 4 * integer);
        Assertions.assertEquals((Integer)84, (Integer)((Integer)quadrupledFuture.getNow((Object)-1)));
        KafkaFutureImpl futureFail = new KafkaFutureImpl();
        KafkaFuture futureAppliedFail = futureFail.thenApply(integer -> 2 * integer);
        futureFail.completeExceptionally((Throwable)new RuntimeException());
        Assertions.assertTrue((boolean)futureFail.isCompletedExceptionally());
        Assertions.assertTrue((boolean)futureAppliedFail.isCompletedExceptionally());
    }

    @Test
    public void testAllOfFutures() throws Exception {
        int i;
        int numThreads = 5;
        ArrayList<KafkaFutureImpl> futures = new ArrayList<KafkaFutureImpl>();
        for (int i2 = 0; i2 < 5; ++i2) {
            futures.add(new KafkaFutureImpl());
        }
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])futures.toArray(new KafkaFuture[0]));
        ArrayList<CompleterThread<Integer>> completerThreads = new ArrayList<CompleterThread<Integer>>();
        ArrayList<WaiterThread<Integer>> waiterThreads = new ArrayList<WaiterThread<Integer>>();
        for (i = 0; i < 5; ++i) {
            completerThreads.add(new CompleterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
            waiterThreads.add(new WaiterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
        }
        Assertions.assertFalse((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            ((WaiterThread)waiterThreads.get(i)).start();
        }
        for (i = 0; i < 4; ++i) {
            ((CompleterThread)completerThreads.get(i)).start();
        }
        Assertions.assertFalse((boolean)allFuture.isDone());
        ((CompleterThread)completerThreads.get(4)).start();
        allFuture.get();
        Assertions.assertTrue((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)((KafkaFutureImpl)futures.get(i)).get()));
        }
        for (i = 0; i < 5; ++i) {
            ((CompleterThread)completerThreads.get(i)).join();
            ((WaiterThread)waiterThreads.get(i)).join();
            Assertions.assertNull((Object)((CompleterThread)completerThreads.get((int)i)).testException);
            Assertions.assertNull((Object)((WaiterThread)waiterThreads.get((int)i)).testException);
        }
    }

    @Test
    public void testAllOfFuturesHandlesZeroFutures() throws Exception {
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[0]);
        Assertions.assertTrue((boolean)allFuture.isDone());
        Assertions.assertFalse((boolean)allFuture.isCancelled());
        Assertions.assertFalse((boolean)allFuture.isCompletedExceptionally());
        allFuture.get();
    }

    @Test
    public void testFutureTimeoutWithZeroWait() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Assertions.assertThrows(TimeoutException.class, () -> {
            String cfr_ignored_0 = (String)future.get(0L, TimeUnit.MILLISECONDS);
        });
    }

    private static class WaiterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T expected;
        Throwable testException = null;

        WaiterThread(KafkaFutureImpl<T> future, T expected) {
            this.future = future;
            this.expected = expected;
        }

        @Override
        public void run() {
            try {
                Object value = this.future.get();
                Assertions.assertEquals(this.expected, (Object)value);
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }

    private static class CompleterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T value;
        Throwable testException = null;

        CompleterThread(KafkaFutureImpl<T> future, T value) {
            this.future = future;
            this.value = value;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(0L, 200);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.future.complete(this.value);
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }
}

