/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.UnalignedRecords;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.NoRetryException;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.ValuelessCallable;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    public static final File IO_TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGITS = "0123456789";
    public static final String LETTERS_AND_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final Random SEEDED_RANDOM = new Random(192348092834L);
    public static final Random RANDOM = new Random();
    public static final long DEFAULT_POLL_INTERVAL_MS = 100L;
    public static final long DEFAULT_MAX_WAIT_MS = 15000L;

    public static Cluster singletonCluster() {
        return TestUtils.clusterWith(1);
    }

    public static Cluster singletonCluster(String topic, int partitions) {
        return TestUtils.clusterWith(1, topic, partitions);
    }

    public static Cluster clusterWith(int nodes) {
        return TestUtils.clusterWith(nodes, new HashMap<String, Integer>());
    }

    public static Cluster clusterWith(int nodes, Map<String, Integer> topicPartitionCounts) {
        Node[] ns = new Node[nodes];
        for (int i = 0; i < nodes; ++i) {
            ns[i] = new Node(i, "localhost", 1969);
        }
        ArrayList<PartitionInfo> parts = new ArrayList<PartitionInfo>();
        for (Map.Entry<String, Integer> topicPartition : topicPartitionCounts.entrySet()) {
            String topic = topicPartition.getKey();
            int partitions = topicPartition.getValue();
            for (int i = 0; i < partitions; ++i) {
                parts.add(new PartitionInfo(topic, i, ns[i % ns.length], ns, ns));
            }
        }
        return new Cluster("kafka-cluster", Arrays.asList(ns), parts, Collections.emptySet(), Collections.emptySet());
    }

    public static Cluster clusterWith(int nodes, String topic, int partitions) {
        return TestUtils.clusterWith(nodes, Collections.singletonMap(topic, partitions));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        SEEDED_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(SEEDED_RANDOM.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }

    public static File tempFile() throws IOException {
        File file = File.createTempFile("kafka", ".tmp");
        file.deleteOnExit();
        return file;
    }

    public static File tempFile(String contents) throws IOException {
        File file = TestUtils.tempFile();
        FileWriter writer = new FileWriter(file);
        writer.write(contents);
        writer.close();
        return file;
    }

    public static File tempDirectory(String prefix) {
        return TestUtils.tempDirectory(null, prefix);
    }

    public static File tempDirectory() {
        return TestUtils.tempDirectory(null);
    }

    public static File tempDirectory(Path parent, String prefix) {
        File file;
        prefix = prefix == null ? "kafka-" : prefix;
        try {
            file = parent == null ? Files.createTempDirectory(prefix, new FileAttribute[0]).toFile() : Files.createTempDirectory(parent, prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temp dir", ex);
        }
        file.deleteOnExit();
        Exit.addShutdownHook((String)"delete-temp-file-shutdown-hook", () -> {
            try {
                Utils.delete((File)file);
            }
            catch (IOException e) {
                log.error("Error deleting {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        });
        return file;
    }

    public static Properties producerConfig(String bootstrapServers, Class<?> keySerializer, Class<?> valueSerializer, Properties additional) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("acks", "all");
        properties.put("key.serializer", keySerializer);
        properties.put("value.serializer", valueSerializer);
        properties.putAll((Map<?, ?>)additional);
        return properties;
    }

    public static Properties producerConfig(String bootstrapServers, Class<?> keySerializer, Class<?> valueSerializer) {
        return TestUtils.producerConfig(bootstrapServers, keySerializer, valueSerializer, new Properties());
    }

    public static Properties consumerConfig(String bootstrapServers, String groupId, Class<?> keyDeserializer, Class<?> valueDeserializer, Properties additional) {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", bootstrapServers);
        consumerConfig.put("group.id", groupId);
        consumerConfig.put("auto.offset.reset", "earliest");
        consumerConfig.put("key.deserializer", keyDeserializer);
        consumerConfig.put("value.deserializer", valueDeserializer);
        consumerConfig.putAll((Map<?, ?>)additional);
        return consumerConfig;
    }

    public static Properties consumerConfig(String bootstrapServers, String groupId, Class<?> keyDeserializer, Class<?> valueDeserializer) {
        return TestUtils.consumerConfig(bootstrapServers, groupId, keyDeserializer, valueDeserializer, new Properties());
    }

    public static Properties consumerConfig(String bootstrapServers, Class<?> keyDeserializer, Class<?> valueDeserializer) {
        return TestUtils.consumerConfig(bootstrapServers, UUID.randomUUID().toString(), keyDeserializer, valueDeserializer, new Properties());
    }

    public static void waitForCondition(TestCondition testCondition, String conditionDetails) throws InterruptedException {
        TestUtils.waitForCondition(testCondition, 15000L, () -> conditionDetails);
    }

    public static void waitForCondition(TestCondition testCondition, Supplier<String> conditionDetailsSupplier) throws InterruptedException {
        TestUtils.waitForCondition(testCondition, 15000L, conditionDetailsSupplier);
    }

    public static void waitForCondition(TestCondition testCondition, long maxWaitMs, String conditionDetails) throws InterruptedException {
        TestUtils.waitForCondition(testCondition, maxWaitMs, () -> conditionDetails);
    }

    public static void waitForCondition(TestCondition testCondition, long maxWaitMs, Supplier<String> conditionDetailsSupplier) throws InterruptedException {
        TestUtils.retryOnExceptionWithTimeout(maxWaitMs, () -> {
            String conditionDetailsSupplied = conditionDetailsSupplier != null ? (String)conditionDetailsSupplier.get() : null;
            String conditionDetails = conditionDetailsSupplied != null ? conditionDetailsSupplied : "";
            Assertions.assertTrue((boolean)testCondition.conditionMet(), (String)("Condition not met within timeout " + maxWaitMs + ". " + conditionDetails));
        });
    }

    public static void retryOnExceptionWithTimeout(long timeoutMs, ValuelessCallable runnable) throws InterruptedException {
        TestUtils.retryOnExceptionWithTimeout(100L, timeoutMs, runnable);
    }

    public static void retryOnExceptionWithTimeout(ValuelessCallable runnable) throws InterruptedException {
        TestUtils.retryOnExceptionWithTimeout(100L, 15000L, runnable);
    }

    public static void retryOnExceptionWithTimeout(long pollIntervalMs, long timeoutMs, ValuelessCallable runnable) throws InterruptedException {
        long expectedEnd = System.currentTimeMillis() + timeoutMs;
        while (true) {
            block6: {
                try {
                    runnable.call();
                    return;
                }
                catch (NoRetryException e) {
                    throw e;
                }
                catch (AssertionError t) {
                    if (expectedEnd <= System.currentTimeMillis()) {
                        throw t;
                    }
                }
                catch (Exception e) {
                    if (expectedEnd > System.currentTimeMillis()) break block6;
                    throw new AssertionError(String.format("Assertion failed with an exception after %s ms", timeoutMs), e);
                }
            }
            Thread.sleep(Math.min(pollIntervalMs, timeoutMs));
        }
    }

    public static void isValidClusterId(String clusterId) {
        Assertions.assertNotNull((Object)clusterId);
        Assertions.assertEquals((int)clusterId.length(), (int)22);
        Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
        Matcher matcher = clusterIdPattern.matcher(clusterId);
        Assertions.assertTrue((boolean)matcher.matches());
        String originalClusterId = String.format("%s==", clusterId.replace("_", "/").replace("-", "+"));
        byte[] decodedUuid = Base64.getDecoder().decode(originalClusterId);
        Assertions.assertEquals((int)decodedUuid.length, (int)16);
        try {
            ByteBuffer uuidBuffer = ByteBuffer.wrap(decodedUuid);
            new UUID(uuidBuffer.getLong(), uuidBuffer.getLong()).toString();
        }
        catch (Exception e) {
            Assertions.fail((String)(clusterId + " cannot be converted back to UUID."));
        }
    }

    public static <T> void checkEquals(Iterable<T> it1, Iterable<T> it2) {
        Assertions.assertEquals(TestUtils.toList(it1), TestUtils.toList(it2));
    }

    public static <T> void checkEquals(Iterator<T> it1, Iterator<T> it2) {
        Assertions.assertEquals((Object)Utils.toList(it1), (Object)Utils.toList(it2));
    }

    public static <T> void checkEquals(Set<T> c1, Set<T> c2, String firstDesc, String secondDesc) {
        if (!c1.equals(c2)) {
            HashSet<T> missing1 = new HashSet<T>(c2);
            missing1.removeAll(c1);
            HashSet<T> missing2 = new HashSet<T>(c1);
            missing2.removeAll(c2);
            Assertions.fail((String)String.format("Sets not equal, missing %s=%s, missing %s=%s", firstDesc, missing1, secondDesc, missing2));
        }
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    public static ByteBuffer toBuffer(Send send) {
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        try {
            Assertions.assertEquals((long)send.size(), (long)send.writeTo((TransferableChannel)channel));
            channel.close();
            return channel.buffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer toBuffer(UnalignedRecords records) {
        return TestUtils.toBuffer((Send)records.toSend());
    }

    public static Set<TopicPartition> generateRandomTopicPartitions(int numTopic, int numPartitionPerTopic) {
        HashSet<TopicPartition> tps = new HashSet<TopicPartition>();
        for (int i = 0; i < numTopic; ++i) {
            String topic = TestUtils.randomString(32);
            for (int j = 0; j < numPartitionPerTopic; ++j) {
                tps.add(new TopicPartition(topic, j));
            }
        }
        return tps;
    }

    public static <T extends Throwable> T assertFutureThrows(Future<?> future, Class<T> exceptionCauseClass) {
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        Assertions.assertTrue((boolean)exceptionCauseClass.isInstance(exception.getCause()), (String)("Unexpected exception cause " + exception.getCause()));
        return (T)((Throwable)exceptionCauseClass.cast(exception.getCause()));
    }

    public static <T extends Throwable> void assertFutureThrows(Future<?> future, Class<T> expectedCauseClassApiException, String expectedMessage) {
        T receivedException = TestUtils.assertFutureThrows(future, expectedCauseClassApiException);
        Assertions.assertEquals((Object)expectedMessage, (Object)((Throwable)receivedException).getMessage());
    }

    public static void assertFutureError(Future<?> future, Class<? extends Throwable> exceptionClass) throws InterruptedException {
        try {
            future.get();
            Assertions.fail((String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got success."));
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertEquals(exceptionClass, cause.getClass(), (String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got " + cause.getClass().getSimpleName()));
        }
    }

    public static ApiKeys apiKeyFrom(NetworkReceive networkReceive) {
        return RequestHeader.parse((ByteBuffer)networkReceive.payload().duplicate()).apiKey();
    }

    public static <T> void assertOptional(Optional<T> optional, Consumer<T> assertion) {
        if (optional.isPresent()) {
            assertion.accept(optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
    }

    public static <T> T fieldValue(Object o, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }
}

