/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.common.TopicPartition;

public class CooperativeStickyAssignor
extends AbstractStickyAssignor {
    @Override
    public String name() {
        return "cooperative-sticky";
    }

    @Override
    public List<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols() {
        return Arrays.asList(ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE, ConsumerPartitionAssignor.RebalanceProtocol.EAGER);
    }

    @Override
    protected AbstractStickyAssignor.MemberData memberData(ConsumerPartitionAssignor.Subscription subscription) {
        return new AbstractStickyAssignor.MemberData(subscription.ownedPartitions(), Optional.empty());
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        Map<String, List<TopicPartition>> assignments = super.assign(partitionsPerTopic, subscriptions);
        Map<TopicPartition, String> partitionsTransferringOwnership = this.partitionsTransferringOwnership == null ? this.computePartitionsTransferringOwnership(subscriptions, assignments) : this.partitionsTransferringOwnership;
        this.adjustAssignment(assignments, partitionsTransferringOwnership);
        return assignments;
    }

    private void adjustAssignment(Map<String, List<TopicPartition>> assignments, Map<TopicPartition, String> partitionsTransferringOwnership) {
        for (Map.Entry<TopicPartition, String> partitionEntry : partitionsTransferringOwnership.entrySet()) {
            assignments.get(partitionEntry.getValue()).remove(partitionEntry.getKey());
        }
    }

    private Map<TopicPartition, String> computePartitionsTransferringOwnership(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashMap<TopicPartition, String> allAddedPartitions = new HashMap<TopicPartition, String>();
        HashSet<TopicPartition> allRevokedPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            String consumer = entry.getKey();
            List<TopicPartition> ownedPartitions = subscriptions.get(consumer).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            HashSet<TopicPartition> ownedPartitionsSet = new HashSet<TopicPartition>(ownedPartitions);
            for (TopicPartition tp : assignedPartitions) {
                if (ownedPartitionsSet.contains(tp)) continue;
                allAddedPartitions.put(tp, consumer);
            }
            HashSet<TopicPartition> assignedPartitionsSet = new HashSet<TopicPartition>(assignedPartitions);
            for (TopicPartition tp : ownedPartitions) {
                if (assignedPartitionsSet.contains(tp)) continue;
                allRevokedPartitions.add(tp);
            }
        }
        allAddedPartitions.keySet().retainAll(allRevokedPartitions);
        return allAddedPartitions;
    }
}

