/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SaslExtensionsTest {
    Map<String, String> map;

    @BeforeEach
    public void setUp() {
        this.map = new HashMap<String, String>();
        this.map.put("what", "42");
        this.map.put("who", "me");
    }

    @Test
    public void testReturnedMapIsImmutable() {
        SaslExtensions extensions = new SaslExtensions(this.map);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> extensions.map().put("hello", "test"));
    }

    @Test
    public void testCannotAddValueToMapReferenceAndGetFromExtensions() {
        SaslExtensions extensions = new SaslExtensions(this.map);
        Assertions.assertNull(extensions.map().get("hello"));
        this.map.put("hello", "42");
        Assertions.assertNull(extensions.map().get("hello"));
    }
}

