/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerBatchTest {
    private final long now = 1488748346917L;
    private final MemoryRecordsBuilder memoryRecordsBuilder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(128), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)128L);

    @Test
    public void testChecksumNullForMagicV2() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        Assertions.assertNotNull((Object)future);
        Assertions.assertNull((Object)future.checksumOrNull());
    }

    @Test
    public void testBatchAbort() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        MockCallback callback = new MockCallback();
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, (Callback)callback, 1488748346917L);
        KafkaException exception = new KafkaException();
        batch.abort((RuntimeException)((Object)exception));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((int)1, (int)callback.invocations);
        Assertions.assertEquals((Object)((Object)exception), (Object)callback.exception);
        Assertions.assertNull((Object)callback.metadata);
        Assertions.assertFalse((boolean)batch.done(500L, 2342342341L, null));
        Assertions.assertFalse((boolean)batch.done(-1L, -1L, (RuntimeException)((Object)new KafkaException())));
        Assertions.assertEquals((int)1, (int)callback.invocations);
        Assertions.assertTrue((boolean)future.isDone());
        try {
            future.get();
            Assertions.fail((String)"Future should have thrown");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals((Object)((Object)exception), (Object)e.getCause());
        }
    }

    @Test
    public void testBatchCannotAbortTwice() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        MockCallback callback = new MockCallback();
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, (Callback)callback, 1488748346917L);
        KafkaException exception = new KafkaException();
        batch.abort((RuntimeException)((Object)exception));
        Assertions.assertEquals((int)1, (int)callback.invocations);
        Assertions.assertEquals((Object)((Object)exception), (Object)callback.exception);
        Assertions.assertNull((Object)callback.metadata);
        try {
            batch.abort((RuntimeException)((Object)new KafkaException()));
            Assertions.fail((String)"Expected exception from abort");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)callback.invocations);
        Assertions.assertTrue((boolean)future.isDone());
        try {
            future.get();
            Assertions.fail((String)"Future should have thrown");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals((Object)((Object)exception), (Object)e.getCause());
        }
    }

    @Test
    public void testBatchCannotCompleteTwice() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        MockCallback callback = new MockCallback();
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, (Callback)callback, 1488748346917L);
        batch.done(500L, 10L, null);
        Assertions.assertEquals((int)1, (int)callback.invocations);
        Assertions.assertNull((Object)callback.exception);
        Assertions.assertNotNull((Object)callback.metadata);
        try {
            batch.done(1000L, 20L, null);
            Assertions.fail((String)"Expected exception from done");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RecordMetadata recordMetadata = future.get();
        Assertions.assertEquals((long)500L, (long)recordMetadata.offset());
        Assertions.assertEquals((long)10L, (long)recordMetadata.timestamp());
    }

    @Test
    public void testAppendedChecksumMagicV0AndV1() {
        for (byte magic : Arrays.asList((byte)0, (byte)1)) {
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(128), (byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
            byte[] key = "hi".getBytes();
            byte[] value = "there".getBytes();
            FutureRecordMetadata future = batch.tryAppend(1488748346917L, key, value, Record.EMPTY_HEADERS, null, 1488748346917L);
            Assertions.assertNotNull((Object)future);
            byte attributes = LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
            long expectedChecksum = LegacyRecord.computeChecksum((byte)magic, (byte)attributes, (long)1488748346917L, (byte[])key, (byte[])value);
            Assertions.assertEquals((long)expectedChecksum, (long)future.checksumOrNull());
        }
    }

    @Test
    public void testSplitPreservesHeaders() {
        for (CompressionType compressionType : CompressionType.values()) {
            FutureRecordMetadata future;
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
            RecordHeader header = new RecordHeader("header-key", "header-value".getBytes());
            while ((future = batch.tryAppend(1488748346917L, "hi".getBytes(), "there".getBytes(), new Header[]{header}, null, 1488748346917L)) != null) {
            }
            Deque batches = batch.split(200);
            Assertions.assertTrue((batches.size() >= 2 ? 1 : 0) != 0, (String)"This batch should be split to multiple small batches.");
            for (ProducerBatch splitProducerBatch : batches) {
                for (RecordBatch splitBatch : splitProducerBatch.records().batches()) {
                    for (Record record : splitBatch) {
                        Assertions.assertTrue((record.headers().length == 1 ? 1 : 0) != 0, (String)"Header size should be 1.");
                        Assertions.assertTrue((boolean)record.headers()[0].key().equals("header-key"), (String)"Header key should be 'header-key'.");
                        Assertions.assertTrue((boolean)new String(record.headers()[0].value()).equals("header-value"), (String)"Header value should be 'header-value'.");
                    }
                }
            }
        }
    }

    @Test
    public void testSplitPreservesMagicAndCompressionType() {
        for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
            for (CompressionType compressionType : CompressionType.values()) {
                FutureRecordMetadata future;
                if (compressionType == CompressionType.NONE && magic < 2 || compressionType == CompressionType.ZSTD && magic < 2) continue;
                MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magic, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
                ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
                while ((future = batch.tryAppend(1488748346917L, "hi".getBytes(), "there".getBytes(), Record.EMPTY_HEADERS, null, 1488748346917L)) != null) {
                }
                Deque batches = batch.split(512);
                Assertions.assertTrue((batches.size() >= 2 ? 1 : 0) != 0);
                for (ProducerBatch splitProducerBatch : batches) {
                    Assertions.assertEquals((byte)magic, (byte)splitProducerBatch.magic());
                    Assertions.assertTrue((boolean)splitProducerBatch.isSplitBatch());
                    for (RecordBatch splitBatch : splitProducerBatch.records().batches()) {
                        Assertions.assertEquals((byte)magic, (byte)splitBatch.magic());
                        Assertions.assertEquals((long)0L, (long)splitBatch.baseOffset());
                        Assertions.assertEquals((Object)compressionType, (Object)splitBatch.compressionType());
                    }
                }
            }
        }
    }

    @Test
    public void testBatchExpiration() {
        long deliveryTimeoutMs = 10240L;
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        Assertions.assertFalse((boolean)batch.hasReachedDeliveryTimeout(deliveryTimeoutMs, 1488748346915L));
        Assertions.assertTrue((boolean)batch.hasReachedDeliveryTimeout(deliveryTimeoutMs, 1488748346917L + deliveryTimeoutMs));
    }

    @Test
    public void testBatchExpirationAfterReenqueue() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        batch.reenqueued(1488748346917L);
        Assertions.assertFalse((boolean)batch.hasReachedDeliveryTimeout(10240L, 1488748346915L));
    }

    @Test
    public void testShouldNotAttemptAppendOnceRecordsBuilderIsClosedForAppends() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata result0 = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        Assertions.assertNotNull((Object)result0);
        Assertions.assertTrue((boolean)this.memoryRecordsBuilder.hasRoomFor(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS));
        this.memoryRecordsBuilder.closeForRecordAppends();
        Assertions.assertFalse((boolean)this.memoryRecordsBuilder.hasRoomFor(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS));
        Assertions.assertNull((Object)batch.tryAppend(1488748346918L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346918L));
    }

    private static class MockCallback
    implements Callback {
        private int invocations = 0;
        private RecordMetadata metadata;
        private Exception exception;

        private MockCallback() {
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            ++this.invocations;
            this.metadata = metadata;
            this.exception = exception;
        }
    }
}

