/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeUserScramCredentialsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<DescribeUserScramCredentialsResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The message-level error code, 0 except for user authorization or infrastructure issues."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The message-level error message, if any."), new Field("results", (Type)new CompactArrayOf((Type)DescribeUserScramCredentialsResult.SCHEMA_0), "The results for descriptions, one per user."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeUserScramCredentialsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeUserScramCredentialsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.results = new ArrayList<DescribeUserScramCredentialsResult>(0);
    }

    public short apiKey() {
        return 50;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field results was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<DescribeUserScramCredentialsResult> newCollection = new ArrayList<DescribeUserScramCredentialsResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeUserScramCredentialsResult(_readable, _version));
        }
        this.results = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.results.size() + 1);
        _stringBytes = this.results.iterator();
        while (_stringBytes.hasNext()) {
            DescribeUserScramCredentialsResult resultsElement = (DescribeUserScramCredentialsResult)_stringBytes.next();
            resultsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.results.size() + 1)));
        for (DescribeUserScramCredentialsResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeUserScramCredentialsResponseData)) {
            return false;
        }
        DescribeUserScramCredentialsResponseData other = (DescribeUserScramCredentialsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public DescribeUserScramCredentialsResponseData duplicate() {
        DescribeUserScramCredentialsResponseData _duplicate = new DescribeUserScramCredentialsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<DescribeUserScramCredentialsResult> newResults = new ArrayList<DescribeUserScramCredentialsResult>(this.results.size());
        for (DescribeUserScramCredentialsResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "DescribeUserScramCredentialsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DescribeUserScramCredentialsResult> results() {
        return this.results;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeUserScramCredentialsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeUserScramCredentialsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeUserScramCredentialsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeUserScramCredentialsResponseData setResults(List<DescribeUserScramCredentialsResult> v) {
        this.results = v;
        return this;
    }

    public static class CredentialInfo
    implements Message {
        byte mechanism;
        int iterations;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("mechanism", (Type)Type.INT8, "The SCRAM mechanism."), new Field("iterations", (Type)Type.INT32, "The number of iterations used in the SCRAM credential."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public CredentialInfo(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CredentialInfo() {
            this.mechanism = 0;
            this.iterations = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CredentialInfo");
            }
            this.mechanism = _readable.readByte();
            this.iterations = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.mechanism);
            _writable.writeInt(this.iterations);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CredentialInfo");
            }
            _size.addBytes(1);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CredentialInfo)) {
                return false;
            }
            CredentialInfo other = (CredentialInfo)obj;
            if (this.mechanism != other.mechanism) {
                return false;
            }
            if (this.iterations != other.iterations) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.mechanism;
            hashCode = 31 * hashCode + this.iterations;
            return hashCode;
        }

        public CredentialInfo duplicate() {
            CredentialInfo _duplicate = new CredentialInfo();
            _duplicate.mechanism = this.mechanism;
            _duplicate.iterations = this.iterations;
            return _duplicate;
        }

        public String toString() {
            return "CredentialInfo(mechanism=" + this.mechanism + ", iterations=" + this.iterations + ")";
        }

        public byte mechanism() {
            return this.mechanism;
        }

        public int iterations() {
            return this.iterations;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CredentialInfo setMechanism(byte v) {
            this.mechanism = v;
            return this;
        }

        public CredentialInfo setIterations(int v) {
            this.iterations = v;
            return this;
        }
    }

    public static class DescribeUserScramCredentialsResult
    implements Message {
        String user;
        short errorCode;
        String errorMessage;
        List<CredentialInfo> credentialInfos;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("user", (Type)Type.COMPACT_STRING, "The user name."), new Field("error_code", (Type)Type.INT16, "The user-level error code."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The user-level error message, if any."), new Field("credential_infos", (Type)new CompactArrayOf((Type)CredentialInfo.SCHEMA_0), "The mechanism and related information associated with the user's SCRAM credentials."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeUserScramCredentialsResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeUserScramCredentialsResult() {
            this.user = "";
            this.errorCode = 0;
            this.errorMessage = "";
            this.credentialInfos = new ArrayList<CredentialInfo>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeUserScramCredentialsResult");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field user was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field user had invalid length " + length);
            }
            this.user = _readable.readString(length);
            this.errorCode = _readable.readShort();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field credentialInfos was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<CredentialInfo> newCollection = new ArrayList<CredentialInfo>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new CredentialInfo(_readable, _version));
            }
            this.credentialInfos = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.user);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeUnsignedVarint(this.credentialInfos.size() + 1);
            _stringBytes = this.credentialInfos.iterator();
            while (_stringBytes.hasNext()) {
                CredentialInfo credentialInfosElement = (CredentialInfo)_stringBytes.next();
                credentialInfosElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeUserScramCredentialsResult");
            }
            byte[] _stringBytes = this.user.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'user' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.user, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.credentialInfos.size() + 1)));
            for (CredentialInfo credentialInfosElement : this.credentialInfos) {
                credentialInfosElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeUserScramCredentialsResult)) {
                return false;
            }
            DescribeUserScramCredentialsResult other = (DescribeUserScramCredentialsResult)obj;
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.credentialInfos == null ? other.credentialInfos != null : !this.credentialInfos.equals(other.credentialInfos)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.user == null ? 0 : this.user.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.credentialInfos == null ? 0 : this.credentialInfos.hashCode());
            return hashCode;
        }

        public DescribeUserScramCredentialsResult duplicate() {
            DescribeUserScramCredentialsResult _duplicate = new DescribeUserScramCredentialsResult();
            _duplicate.user = this.user;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            ArrayList<CredentialInfo> newCredentialInfos = new ArrayList<CredentialInfo>(this.credentialInfos.size());
            for (CredentialInfo _element : this.credentialInfos) {
                newCredentialInfos.add(_element.duplicate());
            }
            _duplicate.credentialInfos = newCredentialInfos;
            return _duplicate;
        }

        public String toString() {
            return "DescribeUserScramCredentialsResult(user=" + (this.user == null ? "null" : "'" + this.user.toString() + "'") + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", credentialInfos=" + MessageUtil.deepToString(this.credentialInfos.iterator()) + ")";
        }

        public String user() {
            return this.user;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<CredentialInfo> credentialInfos() {
            return this.credentialInfos;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeUserScramCredentialsResult setUser(String v) {
            this.user = v;
            return this;
        }

        public DescribeUserScramCredentialsResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeUserScramCredentialsResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DescribeUserScramCredentialsResult setCredentialInfos(List<CredentialInfo> v) {
            this.credentialInfos = v;
            return this;
        }
    }
}

