/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteBufferChannelTest {
    @Test
    public void testWriteBufferArrayWithNonZeroPosition() {
        byte[] data = Utils.utf8((String)"hello");
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.position(10);
        buffer.put(data);
        int limit = buffer.position();
        buffer.position(10);
        buffer.limit(limit);
        ByteBufferChannel channel = new ByteBufferChannel(buffer.remaining());
        ByteBuffer[] buffers = new ByteBuffer[]{buffer};
        channel.write(buffers);
        channel.close();
        ByteBuffer channelBuffer = channel.buffer();
        Assertions.assertEquals((int)data.length, (int)channelBuffer.remaining());
        Assertions.assertEquals((Object)"hello", (Object)Utils.utf8((ByteBuffer)channelBuffer));
    }

    @Test
    public void testWriteMultiplesByteBuffers() {
        ByteBuffer buf;
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(Utils.utf8((String)"hello")), ByteBuffer.wrap(Utils.utf8((String)"world"))};
        int size = Arrays.stream(buffers).mapToInt(Buffer::remaining).sum();
        try (ByteBufferChannel channel = new ByteBufferChannel(size);){
            channel.write(buffers, 1, 1);
            buf = channel.buffer();
        }
        Assertions.assertEquals((Object)"world", (Object)Utils.utf8((ByteBuffer)buf));
        channel = new ByteBufferChannel(size);
        var5_4 = null;
        try {
            channel.write(buffers, 0, 1);
            buf = channel.buffer();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (channel != null) {
                if (var5_4 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    channel.close();
                }
            }
        }
        Assertions.assertEquals((Object)"hello", (Object)Utils.utf8((ByteBuffer)buf));
        channel = new ByteBufferChannel(size);
        var5_4 = null;
        try {
            channel.write(buffers, 0, 2);
            buf = channel.buffer();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (channel != null) {
                if (var5_4 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    channel.close();
                }
            }
        }
        Assertions.assertEquals((Object)"helloworld", (Object)Utils.utf8((ByteBuffer)buf));
    }

    @Test
    public void testInvalidArgumentsInWritsMultiplesByteBuffers() {
        try (ByteBufferChannel channel = new ByteBufferChannel(10L);){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> channel.write(new ByteBuffer[0], 1, 1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> channel.write(new ByteBuffer[0], -1, 1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> channel.write(new ByteBuffer[0], 0, -1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> channel.write(new ByteBuffer[0], 0, 1));
            Assertions.assertEquals((long)0L, (long)channel.write(new ByteBuffer[0], 0, 0));
        }
    }
}

