/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitRequestTest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TxnOffsetCommitRequestTest
extends OffsetCommitRequestTest {
    private static String transactionalId = "transactionalId";
    private static int producerId = 10;
    private static short producerEpoch = 1;
    private static int generationId = 5;
    private static Map<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
    private static TxnOffsetCommitRequest.Builder builder;
    private static TxnOffsetCommitRequest.Builder builderWithGroupMetadata;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        offsets.clear();
        offsets.put(new TopicPartition(topicOne, partitionOne), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        offsets.put(new TopicPartition(topicTwo, partitionTwo), new TxnOffsetCommitRequest.CommittedOffset(offset, metadata, Optional.of(Integer.valueOf(leaderEpoch))));
        builder = new TxnOffsetCommitRequest.Builder(transactionalId, groupId, (long)producerId, producerEpoch, offsets);
        builderWithGroupMetadata = new TxnOffsetCommitRequest.Builder(transactionalId, groupId, (long)producerId, producerEpoch, offsets, memberId, generationId, Optional.of(groupInstanceId));
    }

    @Override
    @Test
    public void testConstructor() {
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(new TopicPartition(topicOne, partitionOne), Errors.NOT_COORDINATOR);
        errorsMap.put(new TopicPartition(topicTwo, partitionTwo), Errors.NOT_COORDINATOR);
        List<TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic> expectedTopics = Arrays.asList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicOne).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionOne).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata))), new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicTwo).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partitionTwo).setCommittedOffset(offset).setCommittedLeaderEpoch(leaderEpoch).setCommittedMetadata(metadata))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitRequest request = version < 3 ? builder.build(version) : builderWithGroupMetadata.build(version);
            Assertions.assertEquals(offsets, (Object)request.offsets());
            Assertions.assertEquals(expectedTopics, (Object)TxnOffsetCommitRequest.getTopics((Map)request.offsets()));
            TxnOffsetCommitResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assertions.assertEquals(errorsMap, (Object)response.errors());
            Assertions.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 2), (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }
}

