/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Base64;
import java.util.Random;
import org.apache.kafka.common.security.oauthbearer.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerTest;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HttpAccessTokenRetrieverTest
extends OAuthBearerTest {
    @Test
    public void test() throws IOException {
        String expectedResponse = "Hiya, buddy";
        HttpURLConnection mockedCon = this.createHttpURLConnection(expectedResponse);
        String response = HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null);
        Assertions.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testEmptyResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("");
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testErrorReadingResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testCopy() throws IOException {
        byte[] expected = new byte[4097];
        Random r = new Random();
        r.nextBytes(expected);
        ByteArrayInputStream in = new ByteArrayInputStream(expected);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpAccessTokenRetriever.copy((InputStream)in, (OutputStream)out);
        Assertions.assertArrayEquals((byte[])expected, (byte[])out.toByteArray());
    }

    @Test
    public void testCopyError() throws IOException {
        InputStream mockedIn = (InputStream)Mockito.mock(InputStream.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Mockito.when((Object)mockedIn.read((byte[])ArgumentMatchers.any(byte[].class))).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.copy((InputStream)mockedIn, (OutputStream)out));
    }

    @Test
    public void testParseAccessToken() throws IOException {
        String expected = "abc";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", expected);
        String actual = HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseAccessTokenEmptyAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", "");
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseAccessTokenMissingAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("sub", "jdoe");
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseAccessTokenInvalidJson() {
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)"not valid JSON"));
    }

    @Test
    public void testFormatAuthorizationHeader() throws IOException {
        String expected = "Basic " + Base64.getUrlEncoder().encodeToString(Utils.utf8((String)"id:secret"));
        String actual = HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", (String)"secret");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatAuthorizationHeaderMissingValues() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader(null, (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"", (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"  ", (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", (String)"  "));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"  ", (String)"  "));
    }

    @Test
    public void testFormatRequestBody() throws IOException {
        String expected = "grant_type=client_credentials&scope=scope";
        String actual = HttpAccessTokenRetriever.formatRequestBody((String)"scope");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatRequestBodyWithEscaped() throws IOException {
        String questionMark = "%3F";
        String exclamationMark = "%21";
        String expected = String.format("grant_type=client_credentials&scope=earth+is+great%s", exclamationMark);
        String actual = HttpAccessTokenRetriever.formatRequestBody((String)"earth is great!");
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected = String.format("grant_type=client_credentials&scope=what+on+earth%s%s%s%s%s", questionMark, exclamationMark, questionMark, exclamationMark, questionMark);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"what on earth?!?!?");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatRequestBodyMissingValues() throws IOException {
        String expected = "grant_type=client_credentials";
        String actual = HttpAccessTokenRetriever.formatRequestBody(null);
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"");
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"  ");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

