/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListTransactionsResultTest {
    private final KafkaFutureImpl<Map<Integer, KafkaFutureImpl<Collection<TransactionListing>>>> future = new KafkaFutureImpl();
    private final ListTransactionsResult result = new ListTransactionsResult(this.future);

    @Test
    public void testAllFuturesFailIfLookupFails() {
        this.future.completeExceptionally((Throwable)new KafkaException());
        TestUtils.assertFutureThrows(this.result.all(), KafkaException.class);
        TestUtils.assertFutureThrows(this.result.allByBrokerId(), KafkaException.class);
        TestUtils.assertFutureThrows(this.result.byBrokerId(), KafkaException.class);
    }

    @Test
    public void testAllFuturesSucceed() throws Exception {
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        HashMap<Integer, KafkaFutureImpl> brokerFutures = new HashMap<Integer, KafkaFutureImpl>();
        brokerFutures.put(1, future1);
        brokerFutures.put(2, future2);
        this.future.complete(brokerFutures);
        List<TransactionListing> broker1Listings = Arrays.asList(new TransactionListing("foo", 12345L, TransactionState.ONGOING), new TransactionListing("bar", 98765L, TransactionState.PREPARE_ABORT));
        future1.complete(broker1Listings);
        List<TransactionListing> broker2Listings = Collections.singletonList(new TransactionListing("baz", 13579L, TransactionState.COMPLETE_COMMIT));
        future2.complete(broker2Listings);
        Map resultBrokerFutures = (Map)this.result.byBrokerId().get();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{1, 2}), resultBrokerFutures.keySet());
        Assertions.assertEquals(broker1Listings, (Object)((KafkaFuture)resultBrokerFutures.get(1)).get());
        Assertions.assertEquals(broker2Listings, (Object)((KafkaFuture)resultBrokerFutures.get(2)).get());
        Assertions.assertEquals(broker1Listings, ((Map)this.result.allByBrokerId().get()).get(1));
        Assertions.assertEquals(broker2Listings, ((Map)this.result.allByBrokerId().get()).get(2));
        HashSet<TransactionListing> allExpected = new HashSet<TransactionListing>();
        allExpected.addAll(broker1Listings);
        allExpected.addAll(broker2Listings);
        Assertions.assertEquals(allExpected, new HashSet((Collection)this.result.all().get()));
    }

    @Test
    public void testPartialFailure() throws Exception {
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        HashMap<Integer, KafkaFutureImpl> brokerFutures = new HashMap<Integer, KafkaFutureImpl>();
        brokerFutures.put(1, future1);
        brokerFutures.put(2, future2);
        this.future.complete(brokerFutures);
        List<TransactionListing> broker1Listings = Arrays.asList(new TransactionListing("foo", 12345L, TransactionState.ONGOING), new TransactionListing("bar", 98765L, TransactionState.PREPARE_ABORT));
        future1.complete(broker1Listings);
        future2.completeExceptionally((Throwable)new KafkaException());
        Map resultBrokerFutures = (Map)this.result.byBrokerId().get();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{1, 2}), resultBrokerFutures.keySet());
        Assertions.assertEquals(broker1Listings, (Object)((KafkaFuture)resultBrokerFutures.get(1)).get());
        TestUtils.assertFutureThrows(this.result.all(), KafkaException.class);
        TestUtils.assertFutureThrows(this.result.allByBrokerId(), KafkaException.class);
        TestUtils.assertFutureThrows((Future)resultBrokerFutures.get(2), KafkaException.class);
    }
}

