/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DescribeTransactionsHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeTransactionsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final Node node = new Node(1, "host", 1234);

    @Test
    public void testBuildRequest() {
        String transactionalId1 = "foo";
        String transactionalId2 = "bar";
        String transactionalId3 = "baz";
        Set transactionalIds = Utils.mkSet((Object[])new String[]{transactionalId1, transactionalId2, transactionalId3});
        DescribeTransactionsHandler handler = new DescribeTransactionsHandler(this.logContext);
        this.assertLookup(handler, transactionalIds);
        this.assertLookup(handler, Utils.mkSet((Object[])new String[]{transactionalId1}));
        this.assertLookup(handler, Utils.mkSet((Object[])new String[]{transactionalId2, transactionalId3}));
    }

    @Test
    public void testHandleSuccessfulResponse() {
        String transactionalId1 = "foo";
        String transactionalId2 = "bar";
        Set transactionalIds = Utils.mkSet((Object[])new String[]{transactionalId1, transactionalId2});
        DescribeTransactionsHandler handler = new DescribeTransactionsHandler(this.logContext);
        DescribeTransactionsResponseData.TransactionState transactionState1 = this.sampleTransactionState1(transactionalId1);
        DescribeTransactionsResponseData.TransactionState transactionState2 = this.sampleTransactionState2(transactionalId2);
        Set<CoordinatorKey> keys = DescribeTransactionsHandlerTest.coordinatorKeys(transactionalIds);
        DescribeTransactionsResponse response = new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Arrays.asList(transactionState1, transactionState2)));
        AdminApiHandler.ApiResult result = handler.handleResponse(this.node, keys, (AbstractResponse)response);
        Assertions.assertEquals(keys, result.completedKeys.keySet());
        this.assertMatchingTransactionState(this.node.id(), transactionState1, (TransactionDescription)result.completedKeys.get(CoordinatorKey.byTransactionalId((String)transactionalId1)));
        this.assertMatchingTransactionState(this.node.id(), transactionState2, (TransactionDescription)result.completedKeys.get(CoordinatorKey.byTransactionalId((String)transactionalId2)));
    }

    @Test
    public void testHandleErrorResponse() {
        String transactionalId = "foo";
        DescribeTransactionsHandler handler = new DescribeTransactionsHandler(this.logContext);
        this.assertFatalError(handler, transactionalId, Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED);
        this.assertFatalError(handler, transactionalId, Errors.TRANSACTIONAL_ID_NOT_FOUND);
        this.assertFatalError(handler, transactionalId, Errors.UNKNOWN_SERVER_ERROR);
        this.assertRetriableError(handler, transactionalId, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.assertUnmappedKey(handler, transactionalId, Errors.NOT_COORDINATOR);
        this.assertUnmappedKey(handler, transactionalId, Errors.COORDINATOR_NOT_AVAILABLE);
    }

    private void assertFatalError(DescribeTransactionsHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new CoordinatorKey[]{key}), result.failedKeys.keySet());
        Throwable throwable = (Throwable)result.failedKeys.get(key);
        Assertions.assertTrue((boolean)error.exception().getClass().isInstance(throwable));
    }

    private void assertRetriableError(DescribeTransactionsHandler handler, String transactionalId, Errors error) {
        AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    private void assertUnmappedKey(DescribeTransactionsHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.singletonList(key), (Object)result.unmappedKeys);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription> handleResponseError(DescribeTransactionsHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        Set keys = Utils.mkSet((Object[])new CoordinatorKey[]{key});
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setErrorCode(error.code()).setTransactionalId(transactionalId);
        DescribeTransactionsResponse response = new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(transactionState)));
        AdminApiHandler.ApiResult result = handler.handleResponse(this.node, keys, (AbstractResponse)response);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        return result;
    }

    private void assertLookup(DescribeTransactionsHandler handler, Set<String> transactionalIds) {
        Set<CoordinatorKey> keys = DescribeTransactionsHandlerTest.coordinatorKeys(transactionalIds);
        DescribeTransactionsRequest.Builder request = handler.buildBatchedRequest(1, keys);
        Assertions.assertEquals(transactionalIds, new HashSet<String>(request.data.transactionalIds()));
    }

    private static Set<CoordinatorKey> coordinatorKeys(Set<String> transactionalIds) {
        return transactionalIds.stream().map(CoordinatorKey::byTransactionalId).collect(Collectors.toSet());
    }

    private DescribeTransactionsResponseData.TransactionState sampleTransactionState1(String transactionalId) {
        return new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setTransactionState("Ongoing").setTransactionalId(transactionalId).setProducerId(12345L).setProducerEpoch((short)15).setTransactionStartTimeMs(1599151791L).setTransactionTimeoutMs(10000).setTopics(new DescribeTransactionsResponseData.TopicDataCollection(Arrays.asList(new DescribeTransactionsResponseData.TopicData().setTopic("foo").setPartitions(Arrays.asList(1, 3, 5)), new DescribeTransactionsResponseData.TopicData().setTopic("bar").setPartitions(Arrays.asList(1, 3, 5))).iterator()));
    }

    private DescribeTransactionsResponseData.TransactionState sampleTransactionState2(String transactionalId) {
        return new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setTransactionState("Empty").setTransactionalId(transactionalId).setProducerId(98765L).setProducerEpoch((short)30).setTransactionStartTimeMs(-1L);
    }

    private void assertMatchingTransactionState(int expectedCoordinatorId, DescribeTransactionsResponseData.TransactionState expected, TransactionDescription actual) {
        Assertions.assertEquals((int)expectedCoordinatorId, (int)actual.coordinatorId());
        Assertions.assertEquals((long)expected.producerId(), (long)actual.producerId());
        Assertions.assertEquals((int)expected.producerEpoch(), (int)actual.producerEpoch());
        Assertions.assertEquals((long)expected.transactionTimeoutMs(), (long)actual.transactionTimeoutMs());
        Assertions.assertEquals((long)expected.transactionStartTimeMs(), (long)actual.transactionStartTimeMs().orElse(-1L));
        Assertions.assertEquals(this.collectTransactionPartitions(expected), (Object)actual.topicPartitions());
    }

    private Set<TopicPartition> collectTransactionPartitions(DescribeTransactionsResponseData.TransactionState transactionState) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        Iterator iterator = transactionState.topics().iterator();
        while (iterator.hasNext()) {
            DescribeTransactionsResponseData.TopicData topicData = (DescribeTransactionsResponseData.TopicData)iterator.next();
            for (Integer partitionId : topicData.partitions()) {
                topicPartitions.add(new TopicPartition(topicData.topic(), partitionId.intValue()));
            }
        }
        return topicPartitions;
    }
}

