/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.RemoveMembersFromConsumerGroupHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveMembersFromConsumerGroupHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId = "group-id";
    private final LeaveGroupRequestData.MemberIdentity m1 = new LeaveGroupRequestData.MemberIdentity().setMemberId("m1").setGroupInstanceId("m1-gii");
    private final LeaveGroupRequestData.MemberIdentity m2 = new LeaveGroupRequestData.MemberIdentity().setMemberId("m2").setGroupInstanceId("m2-gii");
    private final List<LeaveGroupRequestData.MemberIdentity> members = Arrays.asList(this.m1, this.m2);

    @Test
    public void testBuildRequest() {
        RemoveMembersFromConsumerGroupHandler handler = new RemoveMembersFromConsumerGroupHandler("group-id", this.members, this.logContext);
        LeaveGroupRequest request = (LeaveGroupRequest)handler.buildBatchedRequest(1, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id"))).build();
        Assertions.assertEquals((Object)"group-id", (Object)request.data().groupId());
        Assertions.assertEquals((int)2, (int)request.data().members().size());
    }

    @Test
    public void testSuccessfulHandleResponse() {
        Map<LeaveGroupRequestData.MemberIdentity, Errors> responseData = Collections.singletonMap(this.m1, Errors.NONE);
        this.assertCompleted(this.handleWithGroupError(Errors.NONE), responseData);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithGroupError(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertUnmapped(this.handleWithGroupError(Errors.NOT_COORDINATOR));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithGroupError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithGroupError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(UnknownServerException.class, this.handleWithGroupError(Errors.UNKNOWN_SERVER_ERROR));
    }

    @Test
    public void testFailedHandleResponseInMemberLevel() {
        this.assertMemberFailed(Errors.FENCED_INSTANCE_ID, this.handleWithMemberError(Errors.FENCED_INSTANCE_ID));
        this.assertMemberFailed(Errors.UNKNOWN_MEMBER_ID, this.handleWithMemberError(Errors.UNKNOWN_MEMBER_ID));
    }

    private LeaveGroupResponse buildResponse(Errors error) {
        LeaveGroupResponse response = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(error.code()).setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setErrorCode(Errors.NONE.code()).setMemberId("m1").setGroupInstanceId("m1-gii"))));
        return response;
    }

    private LeaveGroupResponse buildResponseWithMemberError(Errors error) {
        LeaveGroupResponse response = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setErrorCode(error.code()).setMemberId("m1").setGroupInstanceId("m1-gii"))));
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> handleWithGroupError(Errors error) {
        RemoveMembersFromConsumerGroupHandler handler = new RemoveMembersFromConsumerGroupHandler("group-id", this.members, this.logContext);
        LeaveGroupResponse response = this.buildResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> handleWithMemberError(Errors error) {
        RemoveMembersFromConsumerGroupHandler handler = new RemoveMembersFromConsumerGroupHandler("group-id", this.members, this.logContext);
        LeaveGroupResponse response = this.buildResponseWithMemberError(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> result, Map<LeaveGroupRequestData.MemberIdentity, Errors> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(key));
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }

    private void assertMemberFailed(Errors expectedError, AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> result) {
        Map<LeaveGroupRequestData.MemberIdentity, Errors> expectedResponseData = Collections.singletonMap(this.m1, expectedError);
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expectedResponseData, result.completedKeys.get(key));
    }
}

