/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.message.EnvelopeRequestData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnvelopeRequestTest {
    @Test
    public void testGetPrincipal() {
        KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", "principal", true);
        DefaultKafkaPrincipalBuilder kafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
        EnvelopeRequest.Builder requestBuilder = new EnvelopeRequest.Builder(ByteBuffer.allocate(0), kafkaPrincipalBuilder.serialize(kafkaPrincipal), "client-address".getBytes());
        EnvelopeRequest request = requestBuilder.build((short)0);
        Assertions.assertEquals((Object)kafkaPrincipal, (Object)kafkaPrincipalBuilder.deserialize(request.requestPrincipal()));
    }

    @Test
    public void testToSend() throws IOException {
        Iterator iterator = ApiKeys.ENVELOPE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBuffer requestData = ByteBuffer.wrap("foobar".getBytes());
            RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, version, "clientId", 15);
            EnvelopeRequest request = new EnvelopeRequest.Builder(requestData, "principal".getBytes(), InetAddress.getLocalHost().getAddress()).build(version);
            Send send = request.toSend(header);
            ByteBuffer buffer = TestUtils.toBuffer(send);
            Assertions.assertEquals((long)(send.size() - 4L), (long)buffer.getInt());
            Assertions.assertEquals((Object)header, (Object)RequestHeader.parse((ByteBuffer)buffer));
            EnvelopeRequestData parsedRequestData = new EnvelopeRequestData();
            parsedRequestData.read((Readable)new ByteBufferAccessor(buffer), version);
            Assertions.assertEquals((Object)request.data(), (Object)parsedRequestData);
        }
    }
}

