/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OffsetFetchResponseTest {
    private final int throttleTimeMs = 10;
    private final int offset = 100;
    private final String metadata = "metadata";
    private final String groupOne = "group1";
    private final String groupTwo = "group2";
    private final String groupThree = "group3";
    private final String topicOne = "topic1";
    private final int partitionOne = 1;
    private final Optional<Integer> leaderEpochOne = Optional.of(1);
    private final String topicTwo = "topic2";
    private final int partitionTwo = 2;
    private final Optional<Integer> leaderEpochTwo = Optional.of(2);
    private final String topicThree = "topic3";
    private final int partitionThree = 3;
    private final Optional<Integer> leaderEpochThree = Optional.of(3);
    private Map<TopicPartition, OffsetFetchResponse.PartitionData> partitionDataMap;

    @BeforeEach
    public void setUp() {
        this.partitionDataMap = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, "metadata", Errors.TOPIC_AUTHORIZATION_FAILED));
        this.partitionDataMap.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
    }

    @Test
    public void testConstructor() {
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            Map responseData;
            OffsetFetchResponse response;
            short version = (Short)iterator.next();
            if (version < 8) {
                response = new OffsetFetchResponse(10, Errors.NOT_COORDINATOR, this.partitionDataMap);
                Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)response.error());
                Assertions.assertEquals((int)3, (int)response.errorCounts().size());
                Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.NOT_COORDINATOR, (Object)1), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1), Utils.mkEntry((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)1)}), (Object)response.errorCounts());
                Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
                responseData = response.responseDataV0ToV7();
                Assertions.assertEquals(this.partitionDataMap, (Object)responseData);
                responseData.forEach((tp, data) -> Assertions.assertTrue((boolean)data.hasError()));
                continue;
            }
            response = new OffsetFetchResponse(10, Collections.singletonMap("group1", Errors.NOT_COORDINATOR), Collections.singletonMap("group1", this.partitionDataMap));
            Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)response.groupLevelError("group1"));
            Assertions.assertEquals((int)3, (int)response.errorCounts().size());
            Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.NOT_COORDINATOR, (Object)1), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1), Utils.mkEntry((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)1)}), (Object)response.errorCounts());
            Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
            responseData = response.partitionDataMap("group1");
            Assertions.assertEquals(this.partitionDataMap, (Object)responseData);
            responseData.forEach((tp, data) -> Assertions.assertTrue((boolean)data.hasError()));
        }
    }

    @Test
    public void testConstructorWithMultipleGroups() {
        HashMap responseData = new HashMap();
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> pd1 = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> pd2 = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> pd3 = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        pd1.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, "metadata", Errors.TOPIC_AUTHORIZATION_FAILED));
        pd2.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
        pd3.put(new TopicPartition("topic3", 3), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochThree, "metadata", Errors.NONE));
        responseData.put("group1", pd1);
        responseData.put("group2", pd2);
        responseData.put("group3", pd3);
        errorMap.put("group1", Errors.NOT_COORDINATOR);
        errorMap.put("group2", Errors.COORDINATOR_LOAD_IN_PROGRESS);
        errorMap.put("group3", Errors.NONE);
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            OffsetFetchResponse response = new OffsetFetchResponse(10, errorMap, responseData);
            Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)response.groupLevelError("group1"));
            Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)response.groupLevelError("group2"));
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.groupLevelError("group3"));
            Assertions.assertTrue((boolean)response.groupHasError("group1"));
            Assertions.assertTrue((boolean)response.groupHasError("group2"));
            Assertions.assertFalse((boolean)response.groupHasError("group3"));
            Assertions.assertEquals((int)5, (int)response.errorCounts().size());
            Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.NOT_COORDINATOR, (Object)1), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1), Utils.mkEntry((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)1), Utils.mkEntry((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)1), Utils.mkEntry((Object)Errors.NONE, (Object)2)}), (Object)response.errorCounts());
            Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
            Map responseData1 = response.partitionDataMap("group1");
            Assertions.assertEquals(pd1, (Object)responseData1);
            responseData1.forEach((tp, data) -> Assertions.assertTrue((boolean)data.hasError()));
            Map responseData2 = response.partitionDataMap("group2");
            Assertions.assertEquals(pd2, (Object)responseData2);
            responseData2.forEach((tp, data) -> Assertions.assertTrue((boolean)data.hasError()));
            Map responseData3 = response.partitionDataMap("group3");
            Assertions.assertEquals(pd3, (Object)responseData3);
            responseData3.forEach((tp, data) -> Assertions.assertFalse((boolean)data.hasError()));
        }
    }

    @Test
    public void testStructBuild() {
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            Object responseData;
            OffsetFetchResponse.PartitionData partitionData;
            HashMap<Object, OffsetFetchResponse.PartitionData> expectedDataMap;
            OffsetFetchResponse oldResponse;
            OffsetFetchResponseData data;
            OffsetFetchResponse latestResponse;
            short version = (Short)iterator.next();
            if (version < 8) {
                this.partitionDataMap.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.GROUP_AUTHORIZATION_FAILED));
                latestResponse = new OffsetFetchResponse(10, Errors.NONE, this.partitionDataMap);
                data = new OffsetFetchResponseData((Readable)new ByteBufferAccessor(latestResponse.serialize(version)), version);
                oldResponse = new OffsetFetchResponse(data, version);
                if (version <= 1) {
                    Assertions.assertEquals((short)Errors.NONE.code(), (short)data.errorCode());
                    Assertions.assertEquals((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)oldResponse.error());
                    Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)2), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1)}), (Object)oldResponse.errorCounts());
                } else {
                    Assertions.assertEquals((short)Errors.NONE.code(), (short)data.errorCode());
                    Assertions.assertEquals((Object)Errors.NONE, (Object)oldResponse.error());
                    Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.NONE, (Object)1), Utils.mkEntry((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)1), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1)}), (Object)oldResponse.errorCounts());
                }
                if (version <= 2) {
                    Assertions.assertEquals((int)0, (int)oldResponse.throttleTimeMs());
                } else {
                    Assertions.assertEquals((int)10, (int)oldResponse.throttleTimeMs());
                }
                expectedDataMap = new HashMap<Object, OffsetFetchResponse.PartitionData>();
                for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> entry : this.partitionDataMap.entrySet()) {
                    partitionData = entry.getValue();
                    expectedDataMap.put(entry.getKey(), new OffsetFetchResponse.PartitionData(partitionData.offset, version <= 4 ? Optional.empty() : partitionData.leaderEpoch, partitionData.metadata, partitionData.error));
                }
                responseData = oldResponse.responseDataV0ToV7();
                Assertions.assertEquals(expectedDataMap, (Object)responseData);
                responseData.forEach((tp, rdata) -> Assertions.assertTrue((boolean)rdata.hasError()));
                continue;
            }
            this.partitionDataMap.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.GROUP_AUTHORIZATION_FAILED));
            latestResponse = new OffsetFetchResponse(10, Collections.singletonMap("group1", Errors.NONE), Collections.singletonMap("group1", this.partitionDataMap));
            data = new OffsetFetchResponseData((Readable)new ByteBufferAccessor(latestResponse.serialize(version)), version);
            oldResponse = new OffsetFetchResponse(data, version);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)data.groups().get(0).errorCode());
            Assertions.assertEquals((Object)Errors.NONE, (Object)oldResponse.groupLevelError("group1"));
            Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)Errors.NONE, (Object)1), Utils.mkEntry((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)1), Utils.mkEntry((Object)Errors.TOPIC_AUTHORIZATION_FAILED, (Object)1)}), (Object)oldResponse.errorCounts());
            Assertions.assertEquals((int)10, (int)oldResponse.throttleTimeMs());
            expectedDataMap = new HashMap();
            for (Map.Entry entry : this.partitionDataMap.entrySet()) {
                partitionData = (OffsetFetchResponse.PartitionData)entry.getValue();
                expectedDataMap.put(entry.getKey(), new OffsetFetchResponse.PartitionData(partitionData.offset, partitionData.leaderEpoch, partitionData.metadata, partitionData.error));
            }
            responseData = oldResponse.partitionDataMap("group1");
            Assertions.assertEquals(expectedDataMap, (Object)responseData);
            responseData.forEach((tp, rdata) -> Assertions.assertTrue((boolean)rdata.hasError()));
        }
    }

    @Test
    public void testShouldThrottle() {
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            OffsetFetchResponse response;
            short version = (Short)iterator.next();
            if (version < 8) {
                response = new OffsetFetchResponse(10, Errors.NONE, this.partitionDataMap);
                if (version >= 4) {
                    Assertions.assertTrue((boolean)response.shouldClientThrottle(version));
                    continue;
                }
                Assertions.assertFalse((boolean)response.shouldClientThrottle(version));
                continue;
            }
            response = new OffsetFetchResponse(10, Collections.singletonMap("group1", Errors.NOT_COORDINATOR), Collections.singletonMap("group1", this.partitionDataMap));
            Assertions.assertTrue((boolean)response.shouldClientThrottle(version));
        }
    }

    @Test
    public void testNullableMetadataV0ToV7() {
        OffsetFetchResponse.PartitionData pd = new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, null, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        Assertions.assertEquals((Object)pd, (Object)pd);
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), pd);
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.GROUP_AUTHORIZATION_FAILED, this.partitionDataMap);
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code()).setThrottleTimeMs(10).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(this.leaderEpochOne.orElse(-1)).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata(null)))));
        Assertions.assertEquals((Object)expectedData, (Object)response.data());
    }

    @Test
    public void testNullableMetadataV8AndAbove() {
        OffsetFetchResponse.PartitionData pd = new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, null, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        Assertions.assertEquals((Object)pd, (Object)pd);
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), pd);
        OffsetFetchResponse response = new OffsetFetchResponse(10, Collections.singletonMap("group1", Errors.GROUP_AUTHORIZATION_FAILED), Collections.singletonMap("group1", this.partitionDataMap));
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setGroups(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(this.leaderEpochOne.orElse(-1)).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata(null))))).setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code()))).setThrottleTimeMs(10);
        Assertions.assertEquals((Object)expectedData, (Object)response.data());
    }

    @Test
    public void testUseDefaultLeaderEpochV0ToV7() {
        Optional emptyLeaderEpoch = Optional.empty();
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, emptyLeaderEpoch, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.NOT_COORDINATOR, this.partitionDataMap);
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata("metadata")))));
        Assertions.assertEquals((Object)expectedData, (Object)response.data());
    }

    @Test
    public void testUseDefaultLeaderEpochV8() {
        Optional emptyLeaderEpoch = Optional.empty();
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, emptyLeaderEpoch, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
        OffsetFetchResponse response = new OffsetFetchResponse(10, Collections.singletonMap("group1", Errors.NOT_COORDINATOR), Collections.singletonMap("group1", this.partitionDataMap));
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setGroups(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata("metadata"))))).setErrorCode(Errors.NOT_COORDINATOR.code()))).setThrottleTimeMs(10);
        Assertions.assertEquals((Object)expectedData, (Object)response.data());
    }
}

