/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.message.SimpleExampleMessageDataJsonConverter;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleExampleMessageTest {
    @Test
    public void shouldStoreField() {
        Uuid uuid = Uuid.randomUuid();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf);
        Assertions.assertEquals((Object)uuid, (Object)out.processId());
        Assertions.assertEquals((Object)buf, (Object)out.zeroCopyByteBuffer());
        out.setNullableZeroCopyByteBuffer(null);
        Assertions.assertNull((Object)out.nullableZeroCopyByteBuffer());
        out.setNullableZeroCopyByteBuffer(buf);
        Assertions.assertEquals((Object)buf, (Object)out.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldThrowIfCannotWriteNonIgnorableField() {
        SimpleExampleMessageData out = new SimpleExampleMessageData().setProcessId(Uuid.randomUuid());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> out.write((Writable)new ByteBufferAccessor(ByteBuffer.allocate(64)), new ObjectSerializationCache(), (short)0));
    }

    @Test
    public void shouldDefaultField() {
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        Assertions.assertEquals((Object)Uuid.fromString((String)"AAAAAAAAAAAAAAAAAAAAAA"), (Object)out.processId());
        Assertions.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)out.zeroCopyByteBuffer());
        Assertions.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)out.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughBuffer() {
        Uuid uuid = Uuid.randomUuid();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf);
        ByteBuffer buffer = MessageUtil.toByteBuffer((Message)out, (short)1);
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.read((Readable)new ByteBufferAccessor(buffer), (short)1);
        buf.rewind();
        Assertions.assertEquals((Object)uuid, (Object)in.processId());
        Assertions.assertEquals((Object)buf, (Object)in.zeroCopyByteBuffer());
        Assertions.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughBufferWithNullable() {
        Uuid uuid = Uuid.randomUuid();
        ByteBuffer buf1 = ByteBuffer.wrap(new byte[]{1, 2, 3});
        ByteBuffer buf2 = ByteBuffer.wrap(new byte[]{4, 5, 6});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf1);
        out.setNullableZeroCopyByteBuffer(buf2);
        ByteBuffer buffer = MessageUtil.toByteBuffer((Message)out, (short)1);
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.read((Readable)new ByteBufferAccessor(buffer), (short)1);
        buf1.rewind();
        buf2.rewind();
        Assertions.assertEquals((Object)uuid, (Object)in.processId());
        Assertions.assertEquals((Object)buf1, (Object)in.zeroCopyByteBuffer());
        Assertions.assertEquals((Object)buf2, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldImplementEqualsAndHashCode() {
        Uuid uuid = Uuid.randomUuid();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData a = new SimpleExampleMessageData();
        a.setProcessId(uuid);
        a.setZeroCopyByteBuffer(buf);
        SimpleExampleMessageData b = new SimpleExampleMessageData();
        b.setProcessId(uuid);
        b.setZeroCopyByteBuffer(buf);
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)a.toString(), (Object)b.toString());
        a.setNullableZeroCopyByteBuffer(buf);
        b.setNullableZeroCopyByteBuffer(buf);
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)a.toString(), (Object)b.toString());
        a.setNullableZeroCopyByteBuffer(null);
        b.setNullableZeroCopyByteBuffer(null);
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)a.toString(), (Object)b.toString());
    }

    @Test
    public void testMyTaggedIntArray() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals(Collections.emptyList(), message.myTaggedIntArray()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyTaggedIntArray(Arrays.asList(1, 2, 3)), message -> Assertions.assertEquals(Arrays.asList(1, 2, 3), message.myTaggedIntArray()));
    }

    @Test
    public void testMyNullableString() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertNull((Object)message.myNullableString()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyNullableString("foobar"), message -> Assertions.assertEquals((Object)"foobar", (Object)message.myNullableString()));
    }

    @Test
    public void testMyInt16() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals((short)123, (short)message.myInt16()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyInt16((short)456), message -> Assertions.assertEquals((short)456, (short)message.myInt16()));
    }

    @Test
    public void testMyUint16() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals((int)33000, (int)message.myUint16()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyUint16(123), message -> Assertions.assertEquals((int)123, (int)message.myUint16()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyUint16(60000), message -> Assertions.assertEquals((int)60000, (int)message.myUint16()));
    }

    @Test
    public void testMyString() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals((Object)"", (Object)message.myString()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assertions.assertEquals((Object)"abc", (Object)message.myString()));
    }

    @Test
    public void testMyBytes() {
        Assertions.assertThrows(RuntimeException.class, () -> new SimpleExampleMessageData().setMyUint16(-1));
        Assertions.assertThrows(RuntimeException.class, () -> new SimpleExampleMessageData().setMyUint16(65536));
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertArrayEquals((byte[])new byte[0], (byte[])message.myBytes()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyBytes(new byte[]{67, 102}), message -> Assertions.assertArrayEquals((byte[])new byte[]{67, 102}, (byte[])message.myBytes()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyBytes(null), message -> Assertions.assertNull((Object)message.myBytes()));
    }

    @Test
    public void testTaggedUuid() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"), (Object)message.taggedUuid()));
        Uuid randomUuid = Uuid.randomUuid();
        this.testRoundTrip(new SimpleExampleMessageData().setTaggedUuid(randomUuid), message -> Assertions.assertEquals((Object)randomUuid, (Object)message.taggedUuid()));
    }

    @Test
    public void testTaggedLong() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assertions.assertEquals((long)0xCAFCACAFCACAFCAL, (long)message.taggedLong()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("blah").setMyTaggedIntArray(Collections.singletonList(4)).setTaggedLong(81984200049378354L), message -> Assertions.assertEquals((long)81984200049378354L, (long)message.taggedLong()));
    }

    @Test
    public void testMyStruct() {
        SimpleExampleMessageData.MyStruct myStruct = new SimpleExampleMessageData.MyStruct().setStructId(10).setArrayInStruct(Collections.singletonList(new SimpleExampleMessageData.StructArray().setArrayFieldId(20)));
        this.testRoundTrip(new SimpleExampleMessageData().setMyStruct(myStruct), message -> Assertions.assertEquals((Object)myStruct, (Object)message.myStruct()), (short)2);
    }

    @Test
    public void testMyStructUnsupportedVersion() {
        SimpleExampleMessageData.MyStruct myStruct = new SimpleExampleMessageData.MyStruct().setStructId(10);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testRoundTrip(new SimpleExampleMessageData().setMyStruct(myStruct), (short)1));
    }

    @Test
    public void testMyTaggedStruct() {
        SimpleExampleMessageData.TaggedStruct myStruct = new SimpleExampleMessageData.TaggedStruct().setStructId("abc");
        this.testRoundTrip(new SimpleExampleMessageData().setMyTaggedStruct(myStruct), message -> Assertions.assertEquals((Object)myStruct, (Object)message.myTaggedStruct()), (short)2);
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assertions.assertEquals((Object)"abc", (Object)message.myString()), (short)1);
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assertions.assertEquals((Object)"abc", (Object)message.myString()), (short)2);
    }

    @Test
    public void testCommonStruct() {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyCommonStruct(new SimpleExampleMessageData.TestCommonStruct().setFoo(1).setBar(2));
        message.setMyOtherCommonStruct(new SimpleExampleMessageData.TestCommonStruct().setFoo(3).setBar(4));
        this.testRoundTrip(message, (short)2);
    }

    private SimpleExampleMessageData deserialize(ByteBuffer buf, short version) {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.read((Readable)new ByteBufferAccessor(buf.duplicate()), version);
        return message;
    }

    private void testRoundTrip(SimpleExampleMessageData message, short version) {
        this.testRoundTrip(message, m -> {}, version);
    }

    private void testRoundTrip(SimpleExampleMessageData message, Consumer<SimpleExampleMessageData> validator) {
        this.testRoundTrip(message, validator, (short)1);
    }

    private void testRoundTrip(SimpleExampleMessageData message, Consumer<SimpleExampleMessageData> validator, short version) {
        validator.accept(message);
        ByteBuffer buf = MessageUtil.toByteBuffer((Message)message, (short)version);
        SimpleExampleMessageData message2 = this.deserialize(buf.duplicate(), version);
        validator.accept(message2);
        Assertions.assertEquals((Object)message, (Object)message2);
        Assertions.assertEquals((int)message.hashCode(), (int)message2.hashCode());
        JsonNode serializedJson = SimpleExampleMessageDataJsonConverter.write(message, version);
        SimpleExampleMessageData messageFromJson = SimpleExampleMessageDataJsonConverter.read(serializedJson, version);
        validator.accept(messageFromJson);
        Assertions.assertEquals((Object)message, (Object)messageFromJson);
        Assertions.assertEquals((int)message.hashCode(), (int)messageFromJson.hashCode());
    }

    @Test
    public void testToString() {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyUint16(65535);
        message.setTaggedUuid(Uuid.fromString((String)"x7D3Ck_ZRA22-dzIvu_pnQ"));
        message.setMyFloat64(1.0);
        Assertions.assertEquals((Object)"SimpleExampleMessageData(processId=AAAAAAAAAAAAAAAAAAAAAA, myTaggedIntArray=[], myNullableString=null, myInt16=123, myFloat64=1.0, myString='', myBytes=[], taggedUuid=x7D3Ck_ZRA22-dzIvu_pnQ, taggedLong=914172222550880202, zeroCopyByteBuffer=java.nio.HeapByteBuffer[pos=0 lim=0 cap=0], nullableZeroCopyByteBuffer=java.nio.HeapByteBuffer[pos=0 lim=0 cap=0], myStruct=MyStruct(structId=0, arrayInStruct=[]), myTaggedStruct=TaggedStruct(structId=''), myCommonStruct=TestCommonStruct(foo=123, bar=123), myOtherCommonStruct=TestCommonStruct(foo=123, bar=123), myUint16=65535)", (Object)message.toString());
    }
}

