/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AllBrokersStrategy;
import org.apache.kafka.clients.admin.internals.ListTransactionsHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListTransactionsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final Node node = new Node(1, "host", 1234);

    @Test
    public void testBuildRequestWithoutFilters() {
        int brokerId = 1;
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        ListTransactionsOptions options = new ListTransactionsOptions();
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        ListTransactionsRequest request = (ListTransactionsRequest)handler.buildBatchedRequest(brokerId, Collections.singleton(brokerKey)).build();
        Assertions.assertEquals(Collections.emptyList(), request.data().producerIdFilters());
        Assertions.assertEquals(Collections.emptyList(), request.data().stateFilters());
    }

    @Test
    public void testBuildRequestWithFilteredProducerId() {
        int brokerId = 1;
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        long filteredProducerId = 23423L;
        ListTransactionsOptions options = new ListTransactionsOptions().filterProducerIds(Collections.singleton(filteredProducerId));
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        ListTransactionsRequest request = (ListTransactionsRequest)handler.buildBatchedRequest(brokerId, Collections.singleton(brokerKey)).build();
        Assertions.assertEquals(Collections.singletonList(filteredProducerId), request.data().producerIdFilters());
        Assertions.assertEquals(Collections.emptyList(), request.data().stateFilters());
    }

    @Test
    public void testBuildRequestWithFilteredState() {
        int brokerId = 1;
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        TransactionState filteredState = TransactionState.ONGOING;
        ListTransactionsOptions options = new ListTransactionsOptions().filterStates(Collections.singleton(filteredState));
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        ListTransactionsRequest request = (ListTransactionsRequest)handler.buildBatchedRequest(brokerId, Collections.singleton(brokerKey)).build();
        Assertions.assertEquals(Collections.singletonList(filteredState.toString()), request.data().stateFilters());
        Assertions.assertEquals(Collections.emptyList(), request.data().producerIdFilters());
    }

    @Test
    public void testHandleSuccessfulResponse() {
        int brokerId = 1;
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        ListTransactionsOptions options = new ListTransactionsOptions();
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        ListTransactionsResponse response = this.sampleListTransactionsResponse1();
        AdminApiHandler.ApiResult result = handler.handleResponse(this.node, Collections.singleton(brokerKey), (AbstractResponse)response);
        Assertions.assertEquals(Collections.singleton(brokerKey), result.completedKeys.keySet());
        this.assertExpectedTransactions(response.data().transactionStates(), (Collection)result.completedKeys.get(brokerKey));
    }

    @Test
    public void testCoordinatorLoadingErrorIsRetriable() {
        int brokerId = 1;
        AdminApiHandler.ApiResult<AllBrokersStrategy.BrokerKey, Collection<TransactionListing>> result = this.handleResponseWithError(brokerId, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    @Test
    public void testHandleResponseWithFatalErrors() {
        this.assertFatalError(Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertFatalError(Errors.UNKNOWN_SERVER_ERROR);
    }

    private void assertFatalError(Errors error) {
        int brokerId = 1;
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        AdminApiHandler.ApiResult<AllBrokersStrategy.BrokerKey, Collection<TransactionListing>> result = this.handleResponseWithError(brokerId, error);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(brokerKey), result.failedKeys.keySet());
        Throwable throwable = (Throwable)result.failedKeys.get(brokerKey);
        Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)throwable));
    }

    private AdminApiHandler.ApiResult<AllBrokersStrategy.BrokerKey, Collection<TransactionListing>> handleResponseWithError(int brokerId, Errors error) {
        AllBrokersStrategy.BrokerKey brokerKey = new AllBrokersStrategy.BrokerKey(OptionalInt.of(brokerId));
        ListTransactionsOptions options = new ListTransactionsOptions();
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        ListTransactionsResponse response = new ListTransactionsResponse(new ListTransactionsResponseData().setErrorCode(error.code()));
        return handler.handleResponse(this.node, Collections.singleton(brokerKey), (AbstractResponse)response);
    }

    private ListTransactionsResponse sampleListTransactionsResponse1() {
        return new ListTransactionsResponse(new ListTransactionsResponseData().setErrorCode(Errors.NONE.code()).setTransactionStates(Arrays.asList(new ListTransactionsResponseData.TransactionState().setTransactionalId("foo").setProducerId(12345L).setTransactionState("Ongoing"), new ListTransactionsResponseData.TransactionState().setTransactionalId("bar").setProducerId(98765L).setTransactionState("PrepareAbort"))));
    }

    private void assertExpectedTransactions(List<ListTransactionsResponseData.TransactionState> expected, Collection<TransactionListing> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Map expectedMap = expected.stream().collect(Collectors.toMap(ListTransactionsResponseData.TransactionState::transactionalId, Function.identity()));
        for (TransactionListing actualListing : actual) {
            ListTransactionsResponseData.TransactionState expectedState = (ListTransactionsResponseData.TransactionState)expectedMap.get(actualListing.transactionalId());
            Assertions.assertNotNull((Object)expectedState);
            this.assertExpectedTransactionState(expectedState, actualListing);
        }
    }

    private void assertExpectedTransactionState(ListTransactionsResponseData.TransactionState expected, TransactionListing actual) {
        Assertions.assertEquals((Object)expected.transactionalId(), (Object)actual.transactionalId());
        Assertions.assertEquals((long)expected.producerId(), (long)actual.producerId());
        Assertions.assertEquals((Object)expected.transactionState(), (Object)actual.state().toString());
    }
}

