/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerRecordTest {
    @Test
    public void testEqualsAndHashCode() {
        ProducerRecord producerRecord = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)1);
        Assertions.assertEquals((Object)producerRecord, (Object)producerRecord);
        Assertions.assertEquals((int)producerRecord.hashCode(), (int)producerRecord.hashCode());
        ProducerRecord equalRecord = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)1);
        Assertions.assertEquals((Object)producerRecord, (Object)equalRecord);
        Assertions.assertEquals((int)producerRecord.hashCode(), (int)equalRecord.hashCode());
        ProducerRecord topicMisMatch = new ProducerRecord("test-1", Integer.valueOf(1), (Object)"key", (Object)1);
        Assertions.assertFalse((boolean)producerRecord.equals((Object)topicMisMatch));
        ProducerRecord partitionMismatch = new ProducerRecord("test", Integer.valueOf(2), (Object)"key", (Object)1);
        Assertions.assertFalse((boolean)producerRecord.equals((Object)partitionMismatch));
        ProducerRecord keyMisMatch = new ProducerRecord("test", Integer.valueOf(1), (Object)"key-1", (Object)1);
        Assertions.assertFalse((boolean)producerRecord.equals((Object)keyMisMatch));
        ProducerRecord valueMisMatch = new ProducerRecord("test", Integer.valueOf(1), (Object)"key", (Object)2);
        Assertions.assertFalse((boolean)producerRecord.equals((Object)valueMisMatch));
        ProducerRecord nullFieldsRecord = new ProducerRecord("topic", null, null, null, null, null);
        Assertions.assertEquals((Object)nullFieldsRecord, (Object)nullFieldsRecord);
        Assertions.assertEquals((int)nullFieldsRecord.hashCode(), (int)nullFieldsRecord.hashCode());
    }

    @Test
    public void testInvalidRecords() {
        try {
            new ProducerRecord(null, Integer.valueOf(0), (Object)"key", (Object)1);
            Assertions.fail((String)"Expected IllegalArgumentException to be raised because topic is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ProducerRecord("test", Integer.valueOf(0), Long.valueOf(-1L), (Object)"key", (Object)1);
            Assertions.fail((String)"Expected IllegalArgumentException to be raised because of negative timestamp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ProducerRecord("test", Integer.valueOf(-1), (Object)"key", (Object)1);
            Assertions.fail((String)"Expected IllegalArgumentException to be raised because of negative partition");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

